/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity.player;

import com.bobmowzie.mowziesmobs.client.model.entity.ModelBipedAnimated;
import com.bobmowzie.mowziesmobs.client.model.entity.ModelGeckoPlayerThirdPerson;
import com.bobmowzie.mowziesmobs.client.model.entity.ModelPlayerAnimated;
import com.bobmowzie.mowziesmobs.client.model.tools.MathUtils;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoBone;
import com.bobmowzie.mowziesmobs.client.render.entity.FrozenRenderHandler;
import com.bobmowzie.mowziesmobs.client.render.entity.layer.GeckoArmorLayer;
import com.bobmowzie.mowziesmobs.client.render.entity.layer.GeckoCapeLayer;
import com.bobmowzie.mowziesmobs.client.render.entity.layer.GeckoElytraLayer;
import com.bobmowzie.mowziesmobs.client.render.entity.layer.GeckoParrotOnShoulderLayer;
import com.bobmowzie.mowziesmobs.client.render.entity.layer.GeckoPlayerItemInHandLayer;
import com.bobmowzie.mowziesmobs.client.render.entity.layer.IGeckoRenderLayer;
import com.bobmowzie.mowziesmobs.client.render.entity.layer.SolarFlareLayer;
import com.bobmowzie.mowziesmobs.client.render.entity.layer.SunblockLayer;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.Deadmau5EarsLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.texture.AnimatableTexture;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.util.RenderUtil;

public class GeckoRenderPlayer
extends PlayerRenderer
implements GeoRenderer<GeckoPlayer> {
    public MultiBufferSource rtb;
    private static HashMap<Class<? extends GeckoPlayer>, GeckoRenderPlayer> modelsToLoad = new HashMap();
    private ModelGeckoPlayerThirdPerson geoModel;
    private Matrix4f worldRenderMat;
    public Vec3 betweenHandsPos;
    public Vec3 particleEmitterRoot;
    private boolean isInvisible = false;
    private GeckoPlayer animatable;

    public GeckoRenderPlayer(EntityRendererProvider.Context context, boolean slim, ModelGeckoPlayerThirdPerson geoModel) {
        super(context, slim);
        ModelPlayerAnimated modelPlayerAnimated = new ModelPlayerAnimated(context.bakeLayer(slim ? ModelLayers.PLAYER_SLIM : ModelLayers.PLAYER), slim);
        ModelPlayerAnimated.setUseMatrixMode(modelPlayerAnimated, true);
        this.model = modelPlayerAnimated;
        this.layers.clear();
        this.addLayer((RenderLayer)new GeckoArmorLayer(this, new ModelBipedAnimated(context.bakeLayer(slim ? ModelLayers.PLAYER_SLIM_INNER_ARMOR : ModelLayers.PLAYER_INNER_ARMOR)), new ModelBipedAnimated(context.bakeLayer(slim ? ModelLayers.PLAYER_SLIM_OUTER_ARMOR : ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
        this.addLayer(new GeckoPlayerItemInHandLayer(this));
        this.addLayer((RenderLayer)new ArrowLayer(context, (LivingEntityRenderer)this));
        this.addLayer((RenderLayer)new Deadmau5EarsLayer((RenderLayerParent)this));
        this.addLayer((RenderLayer)new GeckoCapeLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)this));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new GeckoElytraLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)this, context.getModelSet()));
        this.addLayer((RenderLayer)new GeckoParrotOnShoulderLayer(this, context.getModelSet()));
        this.addLayer((RenderLayer)new SpinAttackEffectLayer((RenderLayerParent)this, context.getModelSet()));
        this.addLayer((RenderLayer)new BeeStingerLayer((LivingEntityRenderer)this));
        this.addLayer(new FrozenRenderHandler.LayerFrozen(this));
        this.addLayer(new SolarFlareLayer(this));
        this.addLayer(new SunblockLayer(this));
        this.geoModel = geoModel;
        this.geoModel.setUseSmallArms(slim);
        this.worldRenderMat = new Matrix4f();
        this.worldRenderMat.identity();
    }

    public ModelGeckoPlayerThirdPerson getGeckoModel() {
        return this.geoModel;
    }

    public HashMap<Class<? extends GeckoPlayer>, GeckoRenderPlayer> getModelsToLoad() {
        return modelsToLoad;
    }

    public void render(AbstractClientPlayer entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, GeckoPlayer geckoPlayer) {
        this.rtb = bufferIn;
        this.setModelVisibilities(entityIn);
        this.renderLiving(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn, geckoPlayer);
    }

    private void setModelVisibilities(AbstractClientPlayer clientPlayer) {
        ModelGeckoPlayerThirdPerson playermodel = this.getGeckoModel();
        if (playermodel.isInitialized()) {
            if (clientPlayer.isSpectator()) {
                playermodel.setVisible(false);
                playermodel.bipedHead().setHidden(false);
                playermodel.bipedHeadwear().setHidden(false);
            } else {
                playermodel.setVisible(true);
                playermodel.bipedHeadwear().setHidden(!clientPlayer.isModelPartShown(PlayerModelPart.HAT));
                playermodel.bipedBodywear().setHidden(!clientPlayer.isModelPartShown(PlayerModelPart.JACKET));
                playermodel.bipedLeftLegwear().setHidden(!clientPlayer.isModelPartShown(PlayerModelPart.LEFT_PANTS_LEG));
                playermodel.bipedRightLegwear().setHidden(!clientPlayer.isModelPartShown(PlayerModelPart.RIGHT_PANTS_LEG));
                playermodel.bipedLeftArmwear().setHidden(!clientPlayer.isModelPartShown(PlayerModelPart.LEFT_SLEEVE));
                playermodel.bipedRightArmwear().setHidden(!clientPlayer.isModelPartShown(PlayerModelPart.RIGHT_SLEEVE));
                playermodel.isSneak = clientPlayer.isCrouching();
                HumanoidModel.ArmPose bipedmodel$armpose = GeckoRenderPlayer.getArmPose((AbstractClientPlayer)clientPlayer, (InteractionHand)InteractionHand.MAIN_HAND);
                HumanoidModel.ArmPose bipedmodel$armpose1 = GeckoRenderPlayer.getArmPose((AbstractClientPlayer)clientPlayer, (InteractionHand)InteractionHand.OFF_HAND);
                if (bipedmodel$armpose.isTwoHanded()) {
                    HumanoidModel.ArmPose armPose = bipedmodel$armpose1 = clientPlayer.getOffhandItem().isEmpty() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
                }
                if (clientPlayer.getMainArm() == HumanoidArm.RIGHT) {
                    this.geoModel.rightArmPose = bipedmodel$armpose;
                    this.geoModel.leftArmPose = bipedmodel$armpose1;
                } else {
                    this.geoModel.rightArmPose = bipedmodel$armpose1;
                    this.geoModel.leftArmPose = bipedmodel$armpose;
                }
            }
        }
    }

    public void renderLiving(AbstractClientPlayer entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, GeckoPlayer geckoPlayer) {
        this.animatable = geckoPlayer;
        matrixStackIn.pushPose();
        Minecraft minecraft = Minecraft.getInstance();
        boolean flag = this.isBodyVisible((LivingEntity)entityIn);
        boolean flag1 = !flag && !entityIn.isInvisibleTo((Player)minecraft.player);
        boolean flag2 = minecraft.shouldEntityAppearGlowing((Entity)entityIn);
        this.isInvisible = !flag && !flag1 && !flag2;
        RenderType rendertype = this.getRenderType((LivingEntity)entityIn, flag, flag1, flag2);
        if (this.isInvisible) {
            rendertype = ((PlayerModel)this.model).renderType(this.getTextureLocation(geckoPlayer));
        }
        if (rendertype != null) {
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(rendertype);
            this.defaultRender(matrixStackIn, (GeoAnimatable)this.animatable, bufferIn, rendertype, ivertexbuilder, 0.0f, partialTicks, packedLightIn);
        }
        matrixStackIn.popPose();
        this.renderEntity(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public int getPackedOverlay(GeckoPlayer animatable, float u, float partialTick) {
        AbstractClientPlayer player = (AbstractClientPlayer)animatable.getPlayer();
        return GeckoRenderPlayer.getOverlayCoords((LivingEntity)player, (float)this.getWhiteOverlayProgress((LivingEntity)player, partialTick));
    }

    public void actuallyRender(PoseStack poseStack, GeckoPlayer animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        Direction direction;
        boolean shouldSit;
        AbstractClientPlayer entity = (AbstractClientPlayer)animatable.getPlayer();
        ((PlayerModel)this.model).attackTime = this.getAttackAnim((LivingEntity)entity, partialTick);
        ((PlayerModel)this.model).riding = shouldSit = entity.isPassenger() && entity.getVehicle() != null && entity.getVehicle().shouldRiderSit();
        ((PlayerModel)this.model).young = entity.isBaby();
        float f_lerpBodyRot = Mth.rotLerp((float)partialTick, (float)entity.yBodyRotO, (float)entity.yBodyRot);
        float f1_lerpHeadRot = Mth.rotLerp((float)partialTick, (float)entity.yHeadRotO, (float)entity.yHeadRot);
        float f2_netHeadYaw = f1_lerpHeadRot - f_lerpBodyRot;
        if (shouldSit && entity.getVehicle() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity.getVehicle();
            f_lerpBodyRot = Mth.rotLerp((float)partialTick, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            f2_netHeadYaw = f1_lerpHeadRot - f_lerpBodyRot;
            float f3 = Mth.wrapDegrees((float)f2_netHeadYaw);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f_lerpBodyRot = f1_lerpHeadRot - f3;
            if (f3 * f3 > 2500.0f) {
                f_lerpBodyRot += f3 * 0.2f;
            }
            f2_netHeadYaw = f1_lerpHeadRot - f_lerpBodyRot;
        }
        float f6 = Mth.lerp((float)partialTick, (float)entity.xRotO, (float)entity.getXRot());
        if (GeckoRenderPlayer.isEntityUpsideDown((LivingEntity)entity)) {
            f6 *= -1.0f;
            f2_netHeadYaw *= -1.0f;
        }
        if (entity.hasPose(Pose.SLEEPING) && (direction = entity.getBedOrientation()) != null) {
            float f4 = entity.getEyeHeight(Pose.STANDING) - 0.1f;
            poseStack.translate((float)(-direction.getStepX()) * f4, 0.0f, (float)(-direction.getStepZ()) * f4);
        }
        float f7 = this.getBob((LivingEntity)entity, partialTick);
        this.scale(entity, poseStack, partialTick);
        float f8_limbSwingAmount = 0.0f;
        float f5_limbSwing = 0.0f;
        if (!shouldSit && entity.isAlive()) {
            f8_limbSwingAmount = entity.walkAnimation.speed(partialTick);
            f5_limbSwing = entity.walkAnimation.position(partialTick);
            if (entity.isBaby()) {
                f5_limbSwing *= 3.0f;
            }
            if (f8_limbSwingAmount > 1.0f) {
                f8_limbSwingAmount = 1.0f;
            }
        }
        if (!isReRender) {
            float headPitch = Mth.lerp((float)partialTick, (float)entity.xRotO, (float)entity.getXRot());
            float motionThreshold = this.getMotionAnimThreshold((GeoAnimatable)animatable);
            Vec3 velocity = entity.getDeltaMovement();
            float avgVelocity = (float)(Math.abs(velocity.x) + Math.abs(velocity.z)) / 2.0f;
            AnimationState animationState = new AnimationState((GeoAnimatable)animatable, f5_limbSwing, f8_limbSwingAmount, partialTick, avgVelocity >= motionThreshold && f8_limbSwingAmount != 0.0f);
            long instanceId = this.getInstanceId((GeoAnimatable)animatable);
            AnimatableManager animatableManager = animatable.getAnimatableInstanceCache().getManagerForId(instanceId);
            animationState.setData(DataTickets.TICK, (Object)(animatable.getTick(animatable) + animatableManager.getFirstTickTime() + (double)partialTick));
            animationState.setData(DataTickets.ENTITY, (Object)entity);
            animationState.setData(DataTickets.ENTITY_MODEL_DATA, (Object)new EntityModelData(shouldSit, entity.isBaby(), -f2_netHeadYaw, -headPitch));
            this.getGeckoModel().addAdditionalStateData((GeoAnimatable)animatable, instanceId, (arg_0, arg_1) -> ((AnimationState)animationState).setData(arg_0, arg_1));
            this.getGeckoModel().handleAnimations((GeoAnimatable)animatable, instanceId, animationState, partialTick);
        }
        if (this.geoModel.isInitialized()) {
            this.setupRotations(entity, poseStack, f7, f_lerpBodyRot, partialTick, f1_lerpHeadRot);
            float bodyRotateAmount = this.geoModel.getControllerValueInverted("BodyRotateController");
            this.geoModel.setRotationAngles((Player)entity, f5_limbSwing, f8_limbSwingAmount, f7, Mth.rotLerp((float)bodyRotateAmount, (float)0.0f, (float)f2_netHeadYaw), f6, partialTick);
            MowzieGeoBone leftHeldItem = this.geoModel.getMowzieBone("LeftHeldItem");
            MowzieGeoBone rightHeldItem = this.geoModel.getMowzieBone("RightHeldItem");
            Matrix4f worldMatInverted = new Matrix4f((Matrix4fc)poseStack.last().pose());
            worldMatInverted.invert();
            Matrix3f worldNormInverted = new Matrix3f((Matrix3fc)poseStack.last().normal());
            worldNormInverted.invert();
            PoseStack toWorldSpace = new PoseStack();
            toWorldSpace.mulPose(MathUtils.quatFromRotationXYZ(0.0f, -f_lerpBodyRot + 180.0f, 0.0f, true));
            toWorldSpace.translate(0.0f, -1.5f, 0.0f);
            toWorldSpace.last().normal().mul((Matrix3fc)worldNormInverted);
            toWorldSpace.last().pose().mul((Matrix4fc)worldMatInverted);
            Vector4f leftHeldItemPos = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
            leftHeldItemPos.mul((Matrix4fc)leftHeldItem.getWorldSpaceMatrix());
            leftHeldItemPos.mul((Matrix4fc)toWorldSpace.last().pose());
            Vec3 leftHeldItemPos3 = new Vec3((double)leftHeldItemPos.x(), (double)leftHeldItemPos.y(), (double)leftHeldItemPos.z());
            Vector4f rightHeldItemPos = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
            rightHeldItemPos.mul((Matrix4fc)rightHeldItem.getWorldSpaceMatrix());
            rightHeldItemPos.mul((Matrix4fc)toWorldSpace.last().pose());
            Vec3 rightHeldItemPos3 = new Vec3((double)rightHeldItemPos.x(), (double)rightHeldItemPos.y(), (double)rightHeldItemPos.z());
            this.betweenHandsPos = rightHeldItemPos3.add(leftHeldItemPos3.subtract(rightHeldItemPos3).scale(0.5));
            MowzieGeoBone particleEmitterRootBone = this.geoModel.getMowzieBone("ParticleEmitterRoot");
            Vector4f emitterRootPos = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
            emitterRootPos.mul((Matrix4fc)particleEmitterRootBone.getWorldSpaceMatrix());
            emitterRootPos.mul((Matrix4fc)toWorldSpace.last().pose());
            this.particleEmitterRoot = new Vec3((double)emitterRootPos.x(), (double)emitterRootPos.y(), (double)emitterRootPos.z());
        }
        poseStack.translate(0.0f, 0.01f, 0.0f);
        if (!entity.isInvisibleTo((Player)Minecraft.getInstance().player)) {
            super.actuallyRender(poseStack, (GeoAnimatable)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
        }
        ModelPlayerAnimated.copyFromGeckoModel((PlayerModel)this.model, this.geoModel);
        if (!entity.isSpectator()) {
            for (RenderLayer layerrenderer : this.layers) {
                layerrenderer.render(poseStack, bufferSource, packedLight, (Entity)entity, f5_limbSwing, f8_limbSwingAmount, partialTick, f7, f2_netHeadYaw, f6);
            }
        }
    }

    public void renderEntity(AbstractClientPlayer entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        RenderNameTagEvent renderNameplateEvent = new RenderNameTagEvent((Entity)entityIn, entityIn.getDisplayName(), (EntityRenderer)this, matrixStackIn, bufferIn, packedLightIn, partialTicks);
        NeoForge.EVENT_BUS.post((Event)renderNameplateEvent);
        if (renderNameplateEvent.canRender().isTrue() || renderNameplateEvent.canRender().isDefault() && this.shouldShowName((LivingEntity)entityIn)) {
            this.renderNameTag(entityIn, renderNameplateEvent.getContent(), matrixStackIn, bufferIn, packedLightIn, partialTicks);
        }
    }

    protected void setupRotations(AbstractClientPlayer entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks, float headYaw) {
        float f = entityLiving.getSwimAmount(partialTicks);
        if (entityLiving.isFallFlying()) {
            this.applyRotationsLivingRenderer(entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks, headYaw);
            float f1 = (float)entityLiving.getFallFlyingTicks() + partialTicks;
            float f2 = Mth.clamp((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!entityLiving.isAutoSpinAttack()) {
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(f2 * (-90.0f - entityLiving.getXRot())));
            }
            Vec3 vector3d = entityLiving.getViewVector(partialTicks);
            Vec3 vector3d1 = entityLiving.getDeltaMovement();
            double d0 = vector3d1.horizontalDistanceSqr();
            double d1 = vector3d.horizontalDistanceSqr();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vector3d1.x * vector3d.x + vector3d1.z * vector3d.z) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.x * vector3d.z - vector3d1.z * vector3d.x;
                matrixStackIn.mulPose(Axis.YP.rotation((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            float swimController = this.geoModel.getControllerValueInverted("SwimController");
            this.applyRotationsLivingRenderer(entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks, headYaw);
            float f3 = entityLiving.isInWater() || entityLiving.isInFluidType((fluidType, height) -> entityLiving.canSwimInFluidType(fluidType)) ? -90.0f - entityLiving.getXRot() : -90.0f;
            float f4 = Mth.lerp((float)f, (float)0.0f, (float)f3) * swimController;
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(f4));
            if (entityLiving.isVisuallySwimming()) {
                matrixStackIn.translate(0.0, -1.0, (double)0.3f);
            }
        } else {
            this.applyRotationsLivingRenderer(entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks, headYaw);
        }
    }

    protected void applyRotationsLivingRenderer(AbstractClientPlayer entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks, float headYaw) {
        Pose pose;
        if (this.isShaking((LivingEntity)entityLiving)) {
            rotationYaw += (float)(Math.cos((double)entityLiving.tickCount * 3.25) * Math.PI * (double)0.4f);
        }
        if ((pose = entityLiving.getPose()) != Pose.SLEEPING) {
            float bodyRotateAmount = this.geoModel.getControllerValueInverted("BodyRotateController");
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f - Mth.rotLerp((float)bodyRotateAmount, (float)headYaw, (float)rotationYaw)));
        }
        if (entityLiving.deathTime > 0) {
            float f = ((float)entityLiving.deathTime + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.sqrt((float)f)) > 1.0f) {
                f = 1.0f;
            }
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(f * this.getFlipDegrees((LivingEntity)entityLiving)));
        } else if (entityLiving.isAutoSpinAttack()) {
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(-90.0f - entityLiving.getXRot()));
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(((float)entityLiving.tickCount + partialTicks) * -75.0f));
        } else if (pose == Pose.SLEEPING) {
            Direction direction = entityLiving.getBedOrientation();
            float f1 = direction != null ? GeckoRenderPlayer.getFacingAngle(direction) : rotationYaw;
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(f1));
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(this.getFlipDegrees((LivingEntity)entityLiving)));
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(270.0f));
        } else if (GeckoRenderPlayer.isEntityUpsideDown((LivingEntity)entityLiving)) {
            matrixStackIn.translate(0.0f, entityLiving.getBbHeight() + 0.1f, 0.0f);
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
    }

    private static float getFacingAngle(Direction facingIn) {
        switch (facingIn) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    public GeoModel<GeckoPlayer> getGeoModel() {
        return this.geoModel;
    }

    public GeckoPlayer getAnimatable() {
        return this.animatable;
    }

    public ModelGeckoPlayerThirdPerson getAnimatedPlayerModel() {
        return this.geoModel;
    }

    public ResourceLocation getTextureLocation(GeckoPlayer geckoPlayer) {
        return this.getTextureLocation((AbstractClientPlayer)geckoPlayer.getPlayer());
    }

    public void renderRecursively(PoseStack poseStack, GeckoPlayer animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        MowzieGeoBone mowzieBone;
        poseStack.pushPose();
        RenderUtil.translateMatrixToBone((PoseStack)poseStack, (GeoBone)bone);
        RenderUtil.translateToPivotPoint((PoseStack)poseStack, (GeoBone)bone);
        RenderUtil.rotateMatrixAroundBone((PoseStack)poseStack, (GeoBone)bone);
        RenderUtil.scaleMatrixForBone((PoseStack)poseStack, (GeoBone)bone);
        if (bone instanceof MowzieGeoBone && ((mowzieBone = (MowzieGeoBone)bone).getName().equals("LeftHeldItem") || mowzieBone.getName().equals("RightHeldItem") || mowzieBone.getName().equals("Head") || mowzieBone.getName().equals("Body") || mowzieBone.getName().equals("BodyLayer") || mowzieBone.getName().equals("LeftArm") || mowzieBone.getName().equals("RightArm") || mowzieBone.getName().equals("RightLeg") || mowzieBone.getName().equals("LeftLeg") || mowzieBone.getName().equals("ParticleEmitterRoot"))) {
            poseStack.pushPose();
            if (!mowzieBone.getName().equals("LeftHeldItem") && !mowzieBone.getName().equals("RightHeldItem")) {
                poseStack.scale(-1.0f, -1.0f, 1.0f);
            }
            if (mowzieBone.getName().equals("Body")) {
                poseStack.translate(0.0, -0.75, 0.0);
            }
            if (mowzieBone.getName().equals("LeftArm")) {
                poseStack.translate(-0.075, 0.0, 0.0);
            }
            if (mowzieBone.getName().equals("RightArm")) {
                poseStack.translate(0.075, 0.0, 0.0);
            }
            PoseStack.Pose entry = poseStack.last();
            mowzieBone.setWorldSpaceNormal(new Matrix3f((Matrix3fc)entry.normal()));
            mowzieBone.setWorldSpaceMatrix(new Matrix4f((Matrix4fc)entry.pose()));
            poseStack.popPose();
        }
        RenderUtil.translateAwayFromPivotPoint((PoseStack)poseStack, (GeoBone)bone);
        this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, color);
        if (!isReRender) {
            this.applyRenderLayersForBone(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
        this.renderChildBones(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
        poseStack.popPose();
        for (RenderLayer layerrenderer : this.layers) {
            if (!(layerrenderer instanceof IGeckoRenderLayer)) continue;
            ((IGeckoRenderLayer)layerrenderer).renderRecursively(bone, poseStack, buffer, packedLight, packedOverlay, color);
        }
    }

    public void updateAnimatedTextureFrame(GeckoPlayer animatable) {
        AnimatableTexture.setAndUpdate((ResourceLocation)this.getTextureLocation(animatable));
    }

    public void fireCompileRenderLayersEvent() {
    }

    public boolean firePreRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
        return true;
    }

    public void firePostRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
    }
}

