/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity.layer;

import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoBone;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoModel;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthana;
import com.ilexiconn.llibrary.client.util.ClientUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class UmvuthanaSunLayer
extends GeoRenderLayer<EntityUmvuthana> {
    protected final EntityRenderDispatcher entityRenderDispatcher;

    public UmvuthanaSunLayer(GeoRenderer<EntityUmvuthana> entityRendererIn, EntityRendererProvider.Context context) {
        super(entityRendererIn);
        this.entityRenderDispatcher = context.getEntityRenderDispatcher();
    }

    public void render(PoseStack poseStack, EntityUmvuthana animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        super.render(poseStack, (GeoAnimatable)animatable, bakedModel, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        MowzieGeoModel model = (MowzieGeoModel)this.getGeoModel();
        MowzieGeoBone head = model.getMowzieBone("head");
        if (!head.isHidden()) {
            poseStack.pushPose();
            poseStack.setIdentity();
            poseStack.mulPose(head.getPose());
            this.renderSun(animatable, bufferSource, poseStack, packedLight, partialTick);
            bufferSource.getBuffer(renderType);
            poseStack.popPose();
        }
    }

    private void renderSun(EntityUmvuthana animatable, MultiBufferSource bufferSource, PoseStack poseStack, int packedLight, float partialTick) {
        PoseStack.Pose matrixstack$entry = poseStack.last();
        Matrix4f matrix4f = matrixstack$entry.pose();
        Vector4f vecTranslation = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vecTranslation.mul((Matrix4fc)matrix4f);
        PoseStack newPoseStack = new PoseStack();
        newPoseStack.translate(vecTranslation.x(), vecTranslation.y(), vecTranslation.z());
        Vector4f vecScale = new Vector4f(1.0f, 0.0f, 0.0f, 1.0f);
        vecScale.mul((Matrix4fc)matrix4f);
        float scale = (float)new Vec3((double)(vecScale.x() - vecTranslation.x()), (double)(vecScale.y() - vecTranslation.y()), (double)(vecScale.z() - vecTranslation.z())).length();
        newPoseStack.scale(scale, scale, scale);
        newPoseStack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
        VertexConsumer ivertexbuilder = bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"textures/particle/sun_no_glow.png"), (boolean)true));
        PoseStack.Pose matrixstack$entry2 = newPoseStack.last();
        Matrix4f matrix4f2 = matrixstack$entry2.pose();
        Matrix3f matrix3f = matrixstack$entry.normal();
        this.drawSun(matrix4f2, matrix3f, ivertexbuilder, packedLight, (float)animatable.tickCount + partialTick);
    }

    private void drawSun(Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer builder, int packedLightIn, float time) {
        float sunRadius = 1.2f + (float)Math.sin(time * 4.0f) * 0.085f;
        this.drawVertex(matrix4f, matrix3f, builder, -sunRadius, -sunRadius, 0.0f, 0.0f, 0.0f, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -sunRadius, sunRadius, 0.0f, 0.0f, 1.0f, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, sunRadius, sunRadius, 0.0f, 1.0f, 1.0f, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, sunRadius, -sunRadius, 0.0f, 1.0f, 0.0f, 1.0f, packedLightIn);
    }

    public void drawVertex(Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int packedLightIn) {
        VertexConsumer consumer = vertexBuilder.addVertex(matrix, offsetX, offsetY, offsetZ).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(textureX, textureY).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
        ClientUtils.transformNormals(consumer, normals, 1.0f, 1.0f, 1.0f);
    }
}

