/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.client.model.tools.MathUtils;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityFallingBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class RenderFallingBlock
extends EntityRenderer<EntityFallingBlock> {
    public RenderFallingBlock(EntityRendererProvider.Context mgr) {
        super(mgr);
    }

    public void render(EntityFallingBlock entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0f, 0.5f, 0.0f);
        if (entityIn.getMode() == EntityFallingBlock.EnumFallingBlockMode.MOBILE) {
            matrixStackIn.mulPose(MathUtils.quatFromRotationXYZ(0.0f, Mth.lerp((float)partialTicks, (float)entityIn.yRotO, (float)entityIn.getYRot()), 0.0f, true));
            matrixStackIn.mulPose(MathUtils.quatFromRotationXYZ(Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot()), 0.0f, 0.0f, true));
        } else {
            matrixStackIn.translate(0.0f, Mth.lerp((float)partialTicks, (float)entityIn.prevAnimY, (float)entityIn.animY), 0.0f);
            matrixStackIn.translate(0.0f, -1.0f, 0.0f);
        }
        matrixStackIn.translate(-0.5f, -0.5f, -0.5f);
        dispatcher.renderSingleBlock(entityIn.getBlock(), matrixStackIn, bufferIn, packedLightIn, OverlayTexture.NO_OVERLAY);
        matrixStackIn.popPose();
    }

    public ResourceLocation getTextureLocation(EntityFallingBlock entity) {
        return null;
    }
}

