/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle.util;

import com.bobmowzie.mowziesmobs.client.model.tools.SimplexNoise;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleRotation;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class ParticleComponent {
    public void init(AdvancedParticleBase particle) {
    }

    public void preUpdate(AdvancedParticleBase particle) {
    }

    public void postUpdate(AdvancedParticleBase particle) {
    }

    public void preRender(AdvancedParticleBase particle, float partialTicks) {
    }

    public void postRender(AdvancedParticleBase particle, VertexConsumer buffer, Camera renderInfo, float partialTicks, int lightmap) {
    }

    public static Constant constant(float value) {
        return new Constant(value);
    }

    public static class Constant
    extends AnimData {
        float value;

        public Constant(float value) {
            this.value = value;
        }

        @Override
        public float evaluate(float t) {
            return this.value;
        }
    }

    public static class CurlNoise
    extends ParticleComponent {
        float strength;
        float frequency;

        public CurlNoise(float strength, float frequency) {
            this.strength = strength;
            this.frequency = frequency;
        }

        @Override
        public void preUpdate(AdvancedParticleBase particle) {
            super.preUpdate(particle);
            Vec3 curlNoise = this.curlNoise(particle.getPos().scale((double)this.frequency)).scale((double)this.strength);
            particle.setMotionX(particle.getMotionX() + curlNoise.x());
            particle.setMotionY(particle.getMotionY() + curlNoise.y());
            particle.setMotionZ(particle.getMotionZ() + curlNoise.z());
        }

        Vec3 snoiseVec3(Vec3 x) {
            double s = SimplexNoise.noise(x.x, x.y, x.z);
            double s1 = SimplexNoise.noise(x.y - 19.1, x.z + 33.4, x.x + 47.2);
            double s2 = SimplexNoise.noise(x.z + 74.2, x.x - 124.5, x.y + 99.4);
            return new Vec3(s, s1, s2);
        }

        Vec3 curlNoise(Vec3 p) {
            float e = 0.1f;
            Vec3 dx = new Vec3((double)e, 0.0, 0.0);
            Vec3 dy = new Vec3(0.0, (double)e, 0.0);
            Vec3 dz = new Vec3(0.0, 0.0, (double)e);
            Vec3 p_x0 = this.snoiseVec3(p.subtract(dx));
            Vec3 p_x1 = this.snoiseVec3(p.add(dx));
            Vec3 p_y0 = this.snoiseVec3(p.subtract(dy));
            Vec3 p_y1 = this.snoiseVec3(p.add(dy));
            Vec3 p_z0 = this.snoiseVec3(p.subtract(dz));
            Vec3 p_z1 = this.snoiseVec3(p.add(dz));
            double x = p_y1.z - p_y0.z - p_z1.y + p_z0.y;
            double y = p_z1.x - p_z0.x - p_x1.z + p_x0.z;
            double z = p_x1.y - p_x0.y - p_y1.x + p_y0.x;
            double divisor = 1.0 / (2.0 * (double)e);
            return new Vec3(x, y, z).scale(divisor).normalize();
        }
    }

    public static class ForceOverTime
    extends ParticleComponent {
        AnimData fx;
        AnimData fy;
        AnimData fz;

        public ForceOverTime(Vec3 force) {
            this.fx = new Constant((float)force.x());
            this.fy = new Constant((float)force.y());
            this.fz = new Constant((float)force.z());
        }

        public ForceOverTime(AnimData fx, AnimData fy, AnimData fz) {
            this.fx = fx;
            this.fy = fy;
            this.fz = fz;
        }

        @Override
        public void preUpdate(AdvancedParticleBase particle) {
            super.preUpdate(particle);
            float ageFrac = particle.getAge() / (float)particle.getLifetime();
            particle.setMotionX(particle.getMotionX() + (double)this.fx.evaluate(ageFrac));
            particle.setMotionY(particle.getMotionY() + (double)this.fy.evaluate(ageFrac));
            particle.setMotionZ(particle.getMotionZ() + (double)this.fz.evaluate(ageFrac));
        }
    }

    public static class AnimatedTexture
    extends ParticleComponent {
    }

    public static class FaceMotion
    extends ParticleComponent {
        @Override
        public void preRender(AdvancedParticleBase particle, float partialTicks) {
            super.preRender(particle, partialTicks);
            double dx = particle.getPosX() - particle.getPrevPosX();
            double dy = particle.getPosY() - particle.getPrevPosY();
            double dz = particle.getPosZ() - particle.getPrevPosZ();
            double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (d != 0.0) {
                ParticleRotation particleRotation = particle.rotation;
                if (particleRotation instanceof ParticleRotation.EulerAngles) {
                    ParticleRotation.EulerAngles eulerRot = (ParticleRotation.EulerAngles)particleRotation;
                    double a = dy / d;
                    a = Math.max(-1.0, Math.min(1.0, a));
                    float pitch = -((float)Math.asin(a));
                    float yaw = -((float)(Math.atan2(dz, dx) + Math.PI));
                    eulerRot.roll = pitch;
                    eulerRot.yaw = yaw;
                } else {
                    particleRotation = particle.rotation;
                    if (particleRotation instanceof ParticleRotation.OrientVector) {
                        ParticleRotation.OrientVector orientRot = (ParticleRotation.OrientVector)particleRotation;
                        orientRot.orientation = new Vec3(dx, dy, dz).normalize();
                    }
                }
            }
        }
    }

    public static class Orbit
    extends ParticleComponent {
        private final Vec3[] location;
        private final AnimData phase;
        private final AnimData radius;
        private final AnimData axisX;
        private final AnimData axisY;
        private final AnimData axisZ;
        private final boolean faceCamera;

        public Orbit(Vec3[] location, AnimData phase, AnimData radius, AnimData axisX, AnimData axisY, AnimData axisZ, boolean faceCamera) {
            this.location = location;
            this.phase = phase;
            this.radius = radius;
            this.axisX = axisX;
            this.axisY = axisY;
            this.axisZ = axisZ;
            this.faceCamera = faceCamera;
        }

        @Override
        public void init(AdvancedParticleBase particle) {
            this.apply(particle, 0.0f);
        }

        @Override
        public void preUpdate(AdvancedParticleBase particle) {
            float ageFrac = particle.getAge() / (float)particle.getLifetime();
            this.apply(particle, ageFrac);
        }

        private void apply(AdvancedParticleBase particle, float t) {
            Vector3f axis;
            float p = this.phase.evaluate(t);
            float r = this.radius.evaluate(t);
            if (this.faceCamera && Minecraft.getInstance().player != null) {
                Vec3 lookAngle = Minecraft.getInstance().player.getLookAngle();
                axis = new Vector3f((float)lookAngle.x(), (float)lookAngle.y(), (float)lookAngle.z());
                axis.normalize();
            } else {
                axis = new Vector3f(this.axisX.evaluate(t), this.axisY.evaluate(t), this.axisZ.evaluate(t));
                axis.normalize();
            }
            Quaternionf quat = new Quaternionf(new AxisAngle4f(p * (float)Math.PI * 2.0f, (Vector3fc)axis));
            Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
            Vector3f start = axis;
            if ((double)Math.abs(axis.dot((Vector3fc)up)) > 0.99) {
                start = new Vector3f(1.0f, 0.0f, 0.0f);
            }
            start.cross((Vector3fc)up);
            start.normalize();
            Vector3f newPos = start;
            quat.transform(newPos);
            newPos.mul(r);
            if (this.location.length > 0 && this.location[0] != null) {
                newPos.add((float)this.location[0].x, (float)this.location[0].y, (float)this.location[0].z);
            }
            particle.setPos(newPos.x(), newPos.y(), newPos.z());
        }
    }

    public static class Attractor
    extends ParticleComponent {
        private final Vec3[] location;
        private final AnimData strengthData;
        private final float killDist;
        private final EnumAttractorBehavior behavior;
        private Vec3 startLocation;

        public Attractor(Vec3[] location, float strength, float killDist, EnumAttractorBehavior behavior) {
            this(location, new Constant(strength), killDist, behavior);
        }

        public Attractor(Vec3[] location, AnimData strength, float killDist, EnumAttractorBehavior behavior) {
            this.location = location;
            this.strengthData = strength;
            this.killDist = killDist;
            this.behavior = behavior;
        }

        @Override
        public void init(AdvancedParticleBase particle) {
            this.startLocation = new Vec3(particle.getPosX(), particle.getPosY(), particle.getPosZ());
        }

        @Override
        public void preUpdate(AdvancedParticleBase particle) {
            float ageFrac = particle.getAge() / (float)(particle.getLifetime() - 1);
            double strength = this.strengthData.evaluate(ageFrac);
            if (this.location.length > 0) {
                Vec3 destinationVec = this.location[0];
                Vec3 currPos = new Vec3(particle.getPosX(), particle.getPosY(), particle.getPosZ());
                Vec3 diff = destinationVec.subtract(currPos);
                if (diff.length() < (double)this.killDist) {
                    particle.remove();
                }
                if (this.behavior == EnumAttractorBehavior.EXPONENTIAL) {
                    Vec3 path = destinationVec.subtract(this.startLocation).scale(Math.pow(ageFrac, strength)).add(this.startLocation).subtract(currPos);
                    particle.move(path.x, path.y, path.z);
                } else if (this.behavior == EnumAttractorBehavior.LINEAR) {
                    Vec3 path = destinationVec.subtract(this.startLocation).scale((double)ageFrac).add(this.startLocation).subtract(currPos);
                    particle.move(path.x, path.y, path.z);
                } else {
                    double dist = Math.max(diff.length(), 0.001);
                    diff = diff.normalize().scale(strength / (dist * dist));
                    particle.setMotionX(Math.min(particle.getMotionX() + diff.x, 5.0));
                    particle.setMotionY(Math.min(particle.getMotionY() + diff.y, 5.0));
                    particle.setMotionZ(Math.min(particle.getMotionZ() + diff.z, 5.0));
                }
            }
        }

        public static enum EnumAttractorBehavior {
            LINEAR,
            EXPONENTIAL,
            SIMULATED;

        }
    }

    public static class PinLocation
    extends ParticleComponent {
        private final Vec3[] location;

        public PinLocation(Vec3[] location) {
            this.location = location;
        }

        @Override
        public void init(AdvancedParticleBase particle) {
            if (this.location != null && this.location.length > 0 && this.location[0] != null) {
                particle.setPos(this.location[0].x, this.location[0].y, this.location[0].z);
            }
        }

        @Override
        public void preUpdate(AdvancedParticleBase particle) {
            if (this.location != null && this.location.length > 0 && this.location[0] != null) {
                particle.setPos(this.location[0].x, this.location[0].y, this.location[0].z);
            }
        }

        @Override
        public void preRender(AdvancedParticleBase particle, float partialTicks) {
            super.preRender(particle, partialTicks);
            particle.doRender = this.location != null && this.location.length > 0 && this.location[0] != null;
        }
    }

    public static class PropertyControl
    extends ParticleComponent {
        private final AnimData animData;
        private final EnumParticleProperty property;
        private final boolean additive;

        public PropertyControl(EnumParticleProperty property, AnimData animData, boolean additive) {
            this.property = property;
            this.animData = animData;
            this.additive = additive;
        }

        @Override
        public void init(AdvancedParticleBase particle) {
            float value = this.animData.evaluate(0.0f);
            this.applyUpdate(particle, value);
            this.applyRender(particle, value);
        }

        @Override
        public void preRender(AdvancedParticleBase particle, float partialTicks) {
            float ageFrac = (particle.getAge() + partialTicks) / (float)particle.getLifetime();
            float value = this.animData.evaluate(ageFrac);
            this.applyRender(particle, value);
        }

        @Override
        public void preUpdate(AdvancedParticleBase particle) {
            float ageFrac = particle.getAge() / (float)particle.getLifetime();
            float value = this.animData.evaluate(ageFrac);
            this.applyUpdate(particle, value);
        }

        private void applyUpdate(AdvancedParticleBase particle, float value) {
            if (this.property == EnumParticleProperty.POS_X) {
                if (this.additive) {
                    particle.setPosX(particle.getPosX() + (double)value);
                } else {
                    particle.setPosX(value);
                }
            } else if (this.property == EnumParticleProperty.POS_Y) {
                if (this.additive) {
                    particle.setPosY(particle.getPosY() + (double)value);
                } else {
                    particle.setPosY(value);
                }
            } else if (this.property == EnumParticleProperty.POS_Z) {
                if (this.additive) {
                    particle.setPosZ(particle.getPosZ() + (double)value);
                } else {
                    particle.setPosZ(value);
                }
            } else if (this.property == EnumParticleProperty.MOTION_X) {
                if (this.additive) {
                    particle.setMotionX(particle.getMotionX() + (double)value);
                } else {
                    particle.setMotionX(value);
                }
            } else if (this.property == EnumParticleProperty.MOTION_Y) {
                if (this.additive) {
                    particle.setMotionY(particle.getMotionY() + (double)value);
                } else {
                    particle.setMotionY(value);
                }
            } else if (this.property == EnumParticleProperty.MOTION_Z) {
                if (this.additive) {
                    particle.setMotionZ(particle.getMotionZ() + (double)value);
                } else {
                    particle.setMotionZ(value);
                }
            } else if (this.property == EnumParticleProperty.AIR_DRAG) {
                particle.airDrag = this.additive ? (particle.airDrag += value) : value;
            }
        }

        private void applyRender(AdvancedParticleBase particle, float value) {
            ParticleRotation particleRotation;
            if (this.property == EnumParticleProperty.RED) {
                particle.red = this.additive ? (particle.red += value) : value;
            } else if (this.property == EnumParticleProperty.GREEN) {
                particle.green = this.additive ? (particle.green += value) : value;
            } else if (this.property == EnumParticleProperty.BLUE) {
                particle.blue = this.additive ? (particle.blue += value) : value;
            } else if (this.property == EnumParticleProperty.ALPHA) {
                particle.alpha = this.additive ? (particle.alpha += value) : value;
            } else if (this.property == EnumParticleProperty.SCALE) {
                particle.scale = this.additive ? (particle.scale += value) : value;
            } else if (this.property == EnumParticleProperty.YAW) {
                ParticleRotation particleRotation2 = particle.rotation;
                if (particleRotation2 instanceof ParticleRotation.EulerAngles) {
                    ParticleRotation.EulerAngles eulerRot = (ParticleRotation.EulerAngles)particleRotation2;
                    eulerRot.yaw = this.additive ? (eulerRot.yaw += value) : value;
                }
            } else if (this.property == EnumParticleProperty.PITCH) {
                ParticleRotation particleRotation3 = particle.rotation;
                if (particleRotation3 instanceof ParticleRotation.EulerAngles) {
                    ParticleRotation.EulerAngles eulerRot = (ParticleRotation.EulerAngles)particleRotation3;
                    eulerRot.pitch = this.additive ? (eulerRot.pitch += value) : value;
                }
            } else if (this.property == EnumParticleProperty.ROLL) {
                ParticleRotation particleRotation4 = particle.rotation;
                if (particleRotation4 instanceof ParticleRotation.EulerAngles) {
                    ParticleRotation.EulerAngles eulerRot = (ParticleRotation.EulerAngles)particleRotation4;
                    eulerRot.roll = this.additive ? (eulerRot.roll += value) : value;
                }
            } else if (this.property == EnumParticleProperty.PARTICLE_ANGLE && (particleRotation = particle.rotation) instanceof ParticleRotation.FaceCamera) {
                ParticleRotation.FaceCamera faceCameraRot = (ParticleRotation.FaceCamera)particleRotation;
                faceCameraRot.angle = this.additive ? (faceCameraRot.angle += value) : value;
            }
        }

        public static enum EnumParticleProperty {
            POS_X,
            POS_Y,
            POS_Z,
            MOTION_X,
            MOTION_Y,
            MOTION_Z,
            RED,
            GREEN,
            BLUE,
            ALPHA,
            SCALE,
            YAW,
            PITCH,
            ROLL,
            PARTICLE_ANGLE,
            AIR_DRAG;

        }
    }

    public static class Gravity
    extends ParticleComponent {
        private final AnimData animData;

        public Gravity(AnimData gravityOverTime) {
            this.animData = gravityOverTime;
        }

        public Gravity(float gravity) {
            this(new Constant(gravity));
        }

        @Override
        public void init(AdvancedParticleBase particle) {
            particle.setGravity(this.animData.evaluate(0.0f));
        }

        @Override
        public void preUpdate(AdvancedParticleBase particle) {
            super.preUpdate(particle);
            float ageFrac = particle.getAge() / (float)particle.getLifetime();
            particle.setGravity(this.animData.evaluate(ageFrac));
        }
    }

    public static class Oscillator
    extends AnimData {
        float value1;
        float value2;
        float frequency;
        float phaseShift;

        public Oscillator(float value1, float value2, float frequency, float phaseShift) {
            this.value1 = value1;
            this.value2 = value2;
            this.frequency = frequency;
            this.phaseShift = phaseShift;
        }

        @Override
        public float evaluate(float t) {
            float a = (this.value2 - this.value1) / 2.0f;
            return (float)((double)(this.value1 + a) + (double)a * Math.cos(t * this.frequency + this.phaseShift));
        }
    }

    public static class KeyTrack
    extends AnimData {
        float[] values;
        float[] times;

        public KeyTrack(float[] values, float[] times) {
            this.values = values;
            this.times = times;
            if (values.length != times.length) {
                System.out.println("Malformed key track. Must have same number of keys and values or key track will evaluate to 0.");
            }
        }

        @Override
        public float evaluate(float t) {
            if (this.values.length != this.times.length) {
                return 0.0f;
            }
            for (int i = 0; i < this.times.length; ++i) {
                float time = this.times[i];
                if (t == time) {
                    return this.values[i];
                }
                if (t < time) {
                    if (i == 0) {
                        return this.values[0];
                    }
                    float a = (t - this.times[i - 1]) / (time - this.times[i - 1]);
                    return this.values[i - 1] * (1.0f - a) + this.values[i] * a;
                }
                if (i != this.values.length - 1) continue;
                return this.values[i];
            }
            return 0.0f;
        }

        public static KeyTrack startAndEnd(float startValue, float endValue) {
            return new KeyTrack(new float[]{startValue, endValue}, new float[]{0.0f, 1.0f});
        }

        public static KeyTrack oscillate(float value1, float value2, int frequency) {
            if (frequency <= 1) {
                new KeyTrack(new float[]{value1, value2}, new float[]{0.0f, 1.0f});
            }
            float step = 1.0f / (float)frequency;
            float[] times = new float[frequency + 1];
            float[] values = new float[frequency + 1];
            for (int i = 0; i < frequency + 1; ++i) {
                float value = i % 2 == 0 ? value1 : value2;
                times[i] = step * (float)i;
                values[i] = value;
            }
            return new KeyTrack(values, times);
        }
    }

    public static abstract class AnimData {
        public float evaluate(float t) {
            return 0.0f;
        }
    }
}

