/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.model.armor;

import com.bobmowzie.mowziesmobs.server.item.ItemGeomancerArmor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;

public class ModelGeomancerArmor
extends GeoModel<ItemGeomancerArmor> {
    public ResourceLocation getModelResource(ItemGeomancerArmor object) {
        return ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"geo/geomancer_armor.geo.json");
    }

    public ResourceLocation getTextureResource(ItemGeomancerArmor object) {
        return ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"textures/item/geomancer_armor.png");
    }

    public ResourceLocation getAnimationResource(ItemGeomancerArmor animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"animations/empty.animation.json");
    }

    public RenderType getRenderType(ItemGeomancerArmor animatable, ResourceLocation texture) {
        return RenderType.entityCutoutNoCull((ResourceLocation)texture);
    }

    public void setCustomAnimations(ItemGeomancerArmor animatable, long instanceId, AnimationState<ItemGeomancerArmor> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        Entity entity = (Entity)animationState.getData(DataTickets.ENTITY);
        if (entity instanceof Player) {
            Player playerEntity = (Player)entity;
            GeoBone cloth = this.getBone("cloth").orElse(null);
            GeoBone backCloth = this.getBone("backCloth").orElse(null);
            if (cloth != null) {
                boolean flag = playerEntity.getFallFlyingTicks() > 4;
                float f = 1.0f;
                if (flag) {
                    f = (float)playerEntity.getDeltaMovement().lengthSqr();
                    f /= 0.2f;
                    f = f * f * f;
                }
                if (f < 1.0f) {
                    f = 1.0f;
                }
                boolean shouldSit = entity.isPassenger() && entity.getVehicle() != null && entity.getVehicle().shouldRiderSit();
                float f8_limbSwingAmount = 0.0f;
                float f5_limbSwing = 0.0f;
                if (!shouldSit && entity.isAlive()) {
                    f8_limbSwingAmount = playerEntity.walkAnimation.speed(animationState.getPartialTick());
                    f5_limbSwing = playerEntity.walkAnimation.position(animationState.getPartialTick());
                    if (playerEntity.isBaby()) {
                        f5_limbSwing *= 3.0f;
                    }
                    if (f8_limbSwingAmount > 1.0f) {
                        f8_limbSwingAmount = 1.0f;
                    }
                }
                cloth.setRotX(Math.abs(Mth.cos((float)(f5_limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * f8_limbSwingAmount * 0.5f / f) + f8_limbSwingAmount * 0.5f);
            }
            if (backCloth != null) {
                double d0 = Mth.lerp((double)animationState.getPartialTick(), (double)playerEntity.xCloakO, (double)playerEntity.xCloak) - Mth.lerp((double)animationState.getPartialTick(), (double)playerEntity.xo, (double)playerEntity.getX());
                double d1 = Mth.lerp((double)animationState.getPartialTick(), (double)playerEntity.yCloakO, (double)playerEntity.yCloak) - Mth.lerp((double)animationState.getPartialTick(), (double)playerEntity.yo, (double)playerEntity.getY());
                double d2 = Mth.lerp((double)animationState.getPartialTick(), (double)playerEntity.zCloakO, (double)playerEntity.zCloak) - Mth.lerp((double)animationState.getPartialTick(), (double)playerEntity.zo, (double)playerEntity.getZ());
                float f = Mth.rotLerp((float)animationState.getPartialTick(), (float)playerEntity.yBodyRotO, (float)playerEntity.yBodyRot);
                double d3 = Mth.sin((float)(f * ((float)Math.PI / 180)));
                double d4 = -Mth.cos((float)(f * ((float)Math.PI / 180)));
                float f1 = (float)d1 * 10.0f;
                f1 = Mth.clamp((float)f1, (float)-6.0f, (float)32.0f);
                float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
                f2 = Mth.clamp((float)f2, (float)0.0f, (float)150.0f);
                float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
                f3 = Mth.clamp((float)f3, (float)-20.0f, (float)20.0f);
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                }
                float f4 = Mth.lerp((float)animationState.getPartialTick(), (float)playerEntity.oBob, (float)playerEntity.bob);
                f1 += Mth.sin((float)(Mth.lerp((float)animationState.getPartialTick(), (float)playerEntity.walkDistO, (float)playerEntity.walkDist) * 6.0f)) * 32.0f * f4;
                if (playerEntity.isCrouching()) {
                    f1 += 25.0f;
                }
                backCloth.setRotX(0.0f - (float)Math.toRadians(6.0f + f2 / 2.0f + f1));
            }
        }
    }
}

