/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplylight;

import com.flanks255.simplylight.SLBlocks;
import com.flanks255.simplylight.data.Generator;
import com.flanks255.simplylight.network.SLNetwork;
import com.flanks255.simplylight.util.RecipeUnlocker;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="simplylight")
public class SimplyLight {
    public static final String MODID = "simplylight";
    public static final Logger LOGGER = LogManager.getLogger((String)"Simply Light");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"simplylight");
    private static final CreativeModeTab.DisplayItemsGenerator TABITEMS = (params, output) -> {
        SLBlocks.LAMPBLOCKS_ON.forEach(block -> output.accept(block.getItem()));
        SLBlocks.LAMPBLOCKS_OFF.forEach(block -> output.accept(block.getItem()));
        SLBlocks.SLABS.forEach(block -> output.accept(block.getItem()));
        SLBlocks.PANELS.forEach(block -> output.accept(block.getItem()));
        SLBlocks.RODS.forEach(block -> output.accept(block.getItem()));
        SLBlocks.BULBS.forEach(block -> output.accept(block.getItem()));
        SLBlocks.FIXTURES.forEach(block -> output.accept(block.getItem()));
        SLBlocks.POSTS.forEach(block -> output.accept(block.getItem()));
        SLBlocks.EDGE_LIGHTS.forEach(block -> output.accept(block.getItem()));
        SLBlocks.EDGE_LIGHTS_TOP.forEach(block -> output.accept(block.getItem()));
    };
    public static final Supplier<CreativeModeTab> TAB = TABS.register("lights", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)SLBlocks.ILLUMINANTBLOCK_ON.getItem())).title((Component)Component.literal((String)"Simply Light")).displayItems(TABITEMS).build());
    public static final TagKey<Item> ANY_ON_LAMP = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)SimplyLight.SLRes("any_lamp_on"));
    public static final TagKey<Item> ANY_OFF_LAMP = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)SimplyLight.SLRes("any_lamp_off"));
    public static final TagKey<Item> ANY_SLAB = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)SimplyLight.SLRes("any_slab"));
    public static final TagKey<Item> ANY_PANEL = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)SimplyLight.SLRes("any_panel"));
    public static final TagKey<Item> ANY_ROD = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)SimplyLight.SLRes("any_rod"));
    public static final TagKey<Item> ANY_BULB = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)SimplyLight.SLRes("any_bulb"));
    public static final TagKey<Item> ANY_FIXTURE = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)SimplyLight.SLRes("any_fixture"));
    public static final TagKey<Item> ANY_POST = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)SimplyLight.SLRes("any_post"));
    public static final TagKey<Item> ANY_EDGE_LIGHT = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)SimplyLight.SLRes("any_edge_light"));
    public static final TagKey<Item> ANY_EDGE_LIGHT_TOP = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)SimplyLight.SLRes("any_edge_light_top"));

    public SimplyLight(IEventBus bus, ModContainer container, Dist dist) {
        SLBlocks.init(bus);
        TABS.register(bus);
        bus.addListener(Generator::gatherData);
        bus.addListener(SLNetwork::register);
        RecipeUnlocker.register(MODID, NeoForge.EVENT_BUS, 4);
        if (dist.isClient()) {
            bus.addListener(SimplyLight::PackFinders);
        }
    }

    public static ResourceLocation SLRes(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static void PackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            event.addPackFinders(SimplyLight.SLRes("optional_fullblock_ctm"), PackType.CLIENT_RESOURCES, (Component)Component.translatable((String)"simplylight.pack.fullblock_ctm"), PackSource.BUILT_IN, false, Pack.Position.TOP);
        }
    }
}

