/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.vendor;

import dev.ithundxr.createnumismatics.registry.packets.VendorContainerSetContentPacket;
import dev.ithundxr.createnumismatics.registry.packets.VendorContainerSetSlotPacket;
import java.util.List;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class VendorContainerSynchronizer
implements ContainerSynchronizer {
    private final ServerPlayer serverPlayer;

    public VendorContainerSynchronizer(ServerPlayer serverPlayer) {
        this.serverPlayer = serverPlayer;
    }

    public void sendInitialData(AbstractContainerMenu container, @NotNull NonNullList<ItemStack> items, @NotNull ItemStack carriedItem, int[] initialData) {
        CatnipServices.NETWORK.sendToClient(this.serverPlayer, (CustomPacketPayload)new VendorContainerSetContentPacket(container.containerId, container.incrementStateId(), (List<ItemStack>)items, carriedItem));
        for (int i = 0; i < initialData.length; ++i) {
            this.sendDataChange(container, i, initialData[i]);
        }
    }

    public void sendSlotChange(AbstractContainerMenu container, int slot, ItemStack itemStack) {
        CatnipServices.NETWORK.sendToClient(this.serverPlayer, (CustomPacketPayload)new VendorContainerSetSlotPacket(container.containerId, container.incrementStateId(), slot, itemStack));
    }

    public void sendCarriedChange(AbstractContainerMenu containerMenu, @NotNull ItemStack stack) {
        this.serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(-1, containerMenu.incrementStateId(), -1, stack));
    }

    public void sendDataChange(AbstractContainerMenu container, int id, int value) {
        this.serverPlayer.connection.send((Packet)new ClientboundContainerSetDataPacket(container.containerId, id, value));
    }
}

