/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.depositor;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.backend.Trusted;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListContainer;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListHolder;
import dev.ithundxr.createnumismatics.content.bank.CardItem;
import dev.ithundxr.createnumismatics.content.coins.DiscreteCoinBag;
import dev.ithundxr.createnumismatics.content.depositor.AbstractDepositorBlock;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import dev.ithundxr.createnumismatics.registry.packets.OpenTrustListPacket;
import dev.ithundxr.createnumismatics.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDepositorBlockEntity
extends SmartBlockEntity
implements IHaveHoveringInformation,
Trusted,
TrustListHolder {
    public final Container cardContainer = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            AbstractDepositorBlockEntity.this.setChanged();
        }
    };
    @Nullable
    protected UUID owner;
    protected final List<UUID> trustList = new ArrayList<UUID>();
    public final TrustListContainer trustListContainer = new TrustListContainer(this.trustList, () -> ((AbstractDepositorBlockEntity)this).setChanged());
    protected final DiscreteCoinBag inventory = new DiscreteCoinBag();
    private boolean delayedDataSync = false;

    public AbstractDepositorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public UUID getCardId() {
        ItemStack card = this.cardContainer.getItem(0);
        if (!(card.getItem() instanceof CardItem)) {
            return null;
        }
        return CardItem.get(card);
    }

    public void activate() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Block block = this.getBlockState().getBlock();
            if (block instanceof AbstractDepositorBlock) {
                AbstractDepositorBlock depositorBlock = (AbstractDepositorBlock)block;
                depositorBlock.activate(this.getBlockState(), serverLevel, this.worldPosition);
            }
        }
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        if (this.owner != null) {
            tag.putUUID("Owner", this.owner);
        }
        if (!this.inventory.isEmpty()) {
            tag.put("Inventory", (Tag)this.inventory.save(new CompoundTag()));
        }
        if (!this.cardContainer.getItem(0).isEmpty()) {
            tag.put("Card", this.cardContainer.getItem(0).save(registries));
        }
        if (!this.trustListContainer.isEmpty()) {
            tag.put("TrustListInv", (Tag)this.trustListContainer.save(new CompoundTag(), registries));
        }
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.owner = tag.hasUUID("Owner") ? tag.getUUID("Owner") : null;
        this.inventory.clear();
        if (tag.contains("Inventory", 10)) {
            this.inventory.load(tag.getCompound("Inventory"));
        }
        ItemStack cardStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("Card"));
        this.cardContainer.setItem(0, cardStack);
        this.trustListContainer.clearContent();
        this.trustList.clear();
        if (tag.contains("TrustListInv", 10)) {
            this.trustListContainer.load(tag.getCompound("TrustListInv"), registries);
        }
    }

    @Override
    public boolean isTrustedInternal(Player player) {
        if (Utils.isDevEnv()) {
            return player.getItemBySlot(EquipmentSlot.FEET).is(Items.GOLDEN_BOOTS);
        }
        return this.owner == null || this.owner.equals(player.getUUID()) || this.trustList.contains(player.getUUID());
    }

    @Nullable
    public UUID getDepositAccount() {
        ItemStack cardStack = this.cardContainer.getItem(0);
        if (cardStack.isEmpty()) {
            return null;
        }
        if (!NumismaticsTags.AllItemTags.CARDS.matches(cardStack)) {
            return null;
        }
        return CardItem.get(cardStack);
    }

    public void addCoin(Coin coin, int count) {
        BankAccount account;
        UUID depositAccount = this.getDepositAccount();
        if (depositAccount != null && (account = Numismatics.BANK.getAccount(depositAccount)) != null) {
            account.deposit(coin, count);
            return;
        }
        this.inventory.add(coin, count);
        this.setChanged();
    }

    public void lazyTick() {
        BankAccount account;
        UUID depositAccount;
        super.lazyTick();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (this.delayedDataSync) {
            this.delayedDataSync = false;
            this.sendData();
        }
        if ((depositAccount = this.getDepositAccount()) != null && !this.inventory.isEmpty() && (account = Numismatics.BANK.getAccount(depositAccount)) != null) {
            for (Coin coin : Coin.values()) {
                int count = this.inventory.getDiscrete(coin);
                this.inventory.subtract(coin, count);
                account.deposit(coin, count);
                this.notifyUpdate();
            }
        }
    }

    void notifyDelayedDataSync() {
        this.delayedDataSync = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openTrustList() {
        if (this.level == null || !this.level.isClientSide) {
            return;
        }
        CatnipServices.NETWORK.sendToServer(new OpenTrustListPacket(this.getBlockPos()));
    }

    @Override
    public ImmutableList<UUID> getTrustList() {
        return ImmutableList.copyOf(this.trustList);
    }

    @Override
    public Container getTrustListBackingContainer() {
        return this.trustListContainer;
    }
}

