/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.createmetalwork.fluid;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.damageTypes.DamageTypeBuilder;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import dev.averageanime.createmetalwork.CreateMetalwork;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ModFluids {
    public static final FluidEntry<BaseFlowingFluid.Flowing> MOLTEN_ANDESITE_ALLOY = CreateMetalwork.REGISTRATE.standardFluid("molten_andesite_alloy", SolidRenderedPlaceableFluidType.create(10793897, () -> Float.valueOf(0.020833334f))).lang("Molten Andesite Alloy").properties(b -> b.sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).lightLevel(15).density(5500).viscosity(100).temperature(1300).canSwim(false)).fluidProperties(p -> p.levelDecreasePerBlock(3).tickRate(20).slopeFindDistance(4).explosionResistance(100.0f)).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> MOLTEN_ANDESITE = CreateMetalwork.REGISTRATE.standardFluid("molten_andesite", SolidRenderedPlaceableFluidType.create(16092754, () -> Float.valueOf(0.020833334f))).lang("Molten Andesite").properties(b -> b.sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).lightLevel(15).density(4000).viscosity(5000).temperature(1300).canSwim(false)).fluidProperties(p -> p.levelDecreasePerBlock(3).tickRate(22).slopeFindDistance(4).explosionResistance(100.0f)).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> MOLTEN_BRASS = CreateMetalwork.REGISTRATE.standardFluid("molten_brass", SolidRenderedPlaceableFluidType.create(16690715, () -> Float.valueOf(0.020833334f))).lang("Molten Brass").properties(b -> b.sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).lightLevel(15).density(8500).viscosity(65).temperature(1300).canSwim(false)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(13).slopeFindDistance(4).explosionResistance(100.0f)).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> MOLTEN_COPPER = CreateMetalwork.REGISTRATE.standardFluid("molten_copper", SolidRenderedPlaceableFluidType.create(16691037, () -> Float.valueOf(0.020833334f))).lang("Molten Copper").properties(b -> b.sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).lightLevel(15).density(8900).viscosity(60).temperature(1300).canSwim(false)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(12).slopeFindDistance(4).explosionResistance(100.0f)).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> MOLTEN_GOLD = CreateMetalwork.REGISTRATE.standardFluid("molten_gold", SolidRenderedPlaceableFluidType.create(15501312, () -> Float.valueOf(0.020833334f))).lang("Molten Gold").properties(b -> b.sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).lightLevel(15).density(19300).viscosity(50).temperature(1300).canSwim(false)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(10).slopeFindDistance(4).explosionResistance(100.0f)).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> MOLTEN_IRON = CreateMetalwork.REGISTRATE.standardFluid("molten_iron", SolidRenderedPlaceableFluidType.create(15115624, () -> Float.valueOf(0.020833334f))).lang("Molten Iron").properties(b -> b.sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).lightLevel(15).density(7800).viscosity(70).temperature(1300).canSwim(false)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(15).slopeFindDistance(4).explosionResistance(100.0f)).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> MOLTEN_NETHERITE = CreateMetalwork.REGISTRATE.standardFluid("molten_netherite", SolidRenderedPlaceableFluidType.create(9984590, () -> Float.valueOf(0.020833334f))).lang("Molten Netherite").properties(b -> b.sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).lightLevel(15).density(12000).viscosity(80).temperature(1300).canSwim(false)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(18).slopeFindDistance(4).explosionResistance(100.0f)).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> MOLTEN_ZINC = CreateMetalwork.REGISTRATE.standardFluid("molten_zinc", SolidRenderedPlaceableFluidType.create(8959643, () -> Float.valueOf(0.020833334f))).lang("Molten Zinc").properties(b -> b.sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).lightLevel(15).density(6800).viscosity(55).temperature(1300).canSwim(false)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(11).slopeFindDistance(4).explosionResistance(100.0f)).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> MOLTEN_TIN = CreateMetalwork.REGISTRATE.standardFluid("molten_tin", SolidRenderedPlaceableFluidType.create(15057822, () -> Float.valueOf(0.020833334f))).lang("Molten Tin").properties(b -> b.sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).lightLevel(15).density(7000).viscosity(55).temperature(1300).canSwim(false)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(11).slopeFindDistance(4).explosionResistance(100.0f)).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> MOLTEN_STEEL = CreateMetalwork.REGISTRATE.standardFluid("molten_steel", SolidRenderedPlaceableFluidType.create(12954003, () -> Float.valueOf(0.020833334f))).lang("Molten Steel").properties(b -> b.sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).lightLevel(15).density(7900).viscosity(72).temperature(1300).canSwim(false)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(16).slopeFindDistance(4).explosionResistance(100.0f)).register();
    public static final FluidEntry<BaseFlowingFluid.Flowing> MOLTEN_BRONZE = CreateMetalwork.REGISTRATE.standardFluid("molten_bronze", SolidRenderedPlaceableFluidType.create(15508558, () -> Float.valueOf(0.020833334f))).lang("Molten Bronze").properties(b -> b.sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).lightLevel(15).density(8700).viscosity(68).temperature(1300).canSwim(false)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(14).slopeFindDistance(4).explosionResistance(100.0f)).register();

    public static void register() {
    }

    static class SolidRenderedPlaceableFluidType
    extends TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidType fluidType = new SolidRenderedPlaceableFluidType(p, s, f);
                fluidType.fogColor = new Color(fogColor, false).asVectorF();
                fluidType.fogDistance = fogDistance;
                return fluidType;
            };
        }

        private SolidRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        @Override
        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        @Override
        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }

        @Override
        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        @Override
        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }

    private static class TransparentRenderedPlaceableFluidType
    extends TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                TransparentRenderedPlaceableFluidType fluidType = new TransparentRenderedPlaceableFluidType(p, s, f);
                fluidType.fogColor = new Color(fogColor, true).asVectorF();
                fluidType.fogDistance = fogDistance;
                return fluidType;
            };
        }

        private TransparentRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        @Override
        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        @Override
        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return -855638017;
        }

        @Override
        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        @Override
        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }

    public static abstract class TintedFluidType
    extends FluidType {
        protected static final int NO_TINT = -1;
        private ResourceLocation stillTexture;
        private ResourceLocation flowingTexture;
        public static final ResourceKey<DamageType> MOLTEN_FLUID = TintedFluidType.key("molten_fluid");

        public TintedFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties);
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
        }

        private static ResourceKey<DamageType> key(String name) {
            return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)CreateMetalwork.asResource(name));
        }

        public static void bootstrap(BootstrapContext<DamageType> ctx) {
            new DamageTypeBuilder(MOLTEN_FLUID).scaling(DamageScaling.ALWAYS).effects(DamageEffects.BURNING).register(ctx);
        }

        private static DamageSource source(ResourceKey<DamageType> key, LevelReader level) {
            Registry registry = level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
            return new DamageSource((Holder)registry.getHolderOrThrow(key));
        }

        public static DamageSource moltenFluid(Level level) {
            return TintedFluidType.source(MOLTEN_FLUID, (LevelReader)level);
        }

        public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
            entity.setDeltaMovement(entity.getDeltaMovement().scale(0.6));
            entity.hurt(TintedFluidType.moltenFluid(entity.level()), 4.0f);
            entity.setRemainingFireTicks(300);
            return false;
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return stillTexture;
                }

                public ResourceLocation getFlowingTexture() {
                    return flowingTexture;
                }

                public int getTintColor(FluidStack stack) {
                    return this.getTintColor(stack);
                }

                public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                    return this.getTintColor(state, getter, pos);
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    Vector3f customFogColor = this.getCustomFogColor();
                    return customFogColor == null ? fluidFogColor : customFogColor;
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    float modifier = this.getFogDistanceModifier();
                    float baseWaterFog = 96.0f;
                    if (modifier != 1.0f) {
                        RenderSystem.setShaderFogShape((FogShape)FogShape.CYLINDER);
                        RenderSystem.setShaderFogStart((float)-8.0f);
                        RenderSystem.setShaderFogEnd((float)(baseWaterFog * modifier));
                    }
                }
            });
        }

        protected abstract int getTintColor(FluidStack var1);

        protected abstract int getTintColor(FluidState var1, BlockAndTintGetter var2, BlockPos var3);

        protected Vector3f getCustomFogColor() {
            return null;
        }

        protected float getFogDistanceModifier() {
            return 1.0f;
        }
    }
}

