/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.MoltenVents.core.objects;

import com.Apothic0n.MoltenVents.MoltenVentsJsonReader;
import com.Apothic0n.MoltenVents.core.objects.ActiveMoltenBlock;
import com.Apothic0n.MoltenVents.core.objects.DormantMoltenBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class MoltenBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"molten_vents");
    public static final Supplier<Block> Asurine = () -> (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"asurine"));
    public static final Supplier<Block> Veridium = () -> (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"veridium"));
    public static final Supplier<Block> Crimsite = () -> (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"crimsite"));
    public static final Supplier<Block> Ochrum = () -> (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"ochrum"));
    public static final Supplier<Block> Scorchia = () -> (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"scorchia"));
    public static final Supplier<Block> Scoria = () -> (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"scoria"));
    public static final List<Map<DeferredHolder<Block, Block>, DeferredHolder<Block, Block>>> moltenBlocks = new ArrayList<Map<DeferredHolder<Block, Block>, DeferredHolder<Block, Block>>>(List.of());

    private MoltenBlocks() {
    }

    public static List<Map<Block, Block>> getMoltenBlocks() {
        ArrayList<Map<Block, Block>> moltenBlocksBlocks = new ArrayList<Map<Block, Block>>(List.of());
        for (int i = 0; i < moltenBlocks.size(); ++i) {
            moltenBlocksBlocks.add(Map.of((Block)moltenBlocks.get(i).keySet().iterator().next().get(), (Block)moltenBlocks.get(i).values().iterator().next().get()));
        }
        return moltenBlocksBlocks;
    }

    public static void createCustomMoltenBlocks() {
        for (int i = 0; i < MoltenVentsJsonReader.customBlocks.size(); ++i) {
            moltenBlocks.add(MoltenBlocks.createMoltenBlocks(MoltenVentsJsonReader.customBlocks.get(i)));
        }
    }

    public static Map<DeferredHolder<Block, Block>, DeferredHolder<Block, Block>> createMoltenBlocks(String blockName) {
        return Map.of(BLOCKS.register("dormant_molten_" + blockName, () -> new DormantMoltenBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TUFF).sound(SoundType.TUFF).pushReaction(PushReaction.BLOCK))), BLOCKS.register("active_molten_" + blockName, () -> new ActiveMoltenBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TUFF).explosionResistance(1200.0f).sound(SoundType.TUFF).lightLevel(brightness -> 15))));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

