/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.MoltenVents;

import com.Apothic0n.MoltenVents.core.objects.ActiveMoltenBlockEntity;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.fml.loading.FMLPaths;

public class MoltenVentsJsonReader {
    public static List<String> customBlocks;

    public static void main() throws Exception {
        Path moltenVentsCustomBlocks = Path.of(String.valueOf(FMLPaths.CONFIGDIR.get()) + "/molten_vents/custom_blocks.json", new String[0]);
        Gson gson = new Gson();
        if (!Files.exists(moltenVentsCustomBlocks, new LinkOption[0])) {
            Files.createDirectories(Path.of(String.valueOf(FMLPaths.CONFIGDIR.get()) + "/molten_vents", new String[0]), new FileAttribute[0]);
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(moltenVentsCustomBlocks.toString()));
            JsonObject defaultData = (JsonObject)gson.fromJson("{\"values\":[\"asurine\",\"veridium\",\"crimsite\",\"ochrum\",\"scorchia\",\"scoria\"]}", JsonObject.class);
            gson.toJson((JsonElement)defaultData, writer);
            writer.close();
        }
        JsonReader reader = new JsonReader((Reader)new FileReader(moltenVentsCustomBlocks.toString()));
        JsonObject data = (JsonObject)gson.fromJson(reader, JsonObject.class);
        JsonArray customBlockNames = data.get("values").getAsJsonArray();
        ArrayList<String> tempCustomBlocks = new ArrayList<String>(List.of());
        for (int i = 0; i < customBlockNames.size(); ++i) {
            tempCustomBlocks.add(customBlockNames.get(i).getAsString());
        }
        customBlocks = tempCustomBlocks;
        for (String name : customBlocks) {
            MoltenVentsJsonReader.createConductive(gson, Path.of(ActiveMoltenBlockEntity.configDir + "/conductive/" + name + ".json", new String[0]), name);
            MoltenVentsJsonReader.createConvertible(gson, Path.of(ActiveMoltenBlockEntity.configDir + "/convertible/" + name + ".json", new String[0]));
        }
    }

    public static void createConductive(Gson gson, Path dir, String name) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(Path.of(ActiveMoltenBlockEntity.configDir + "/conductive", new String[0]), new FileAttribute[0]);
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(dir.toString()));
            JsonObject defaultData = (JsonObject)gson.fromJson("{\n  \"values\": [\n    \"create:" + name + "\",\n    \"molten_vents:dormant_molten_" + name + "\",\n    \"molten_vents:active_molten_" + name + "\"\n  ]\n}", JsonObject.class);
            gson.toJson((JsonElement)defaultData, writer);
            writer.close();
        }
    }

    public static void createConvertible(Gson gson, Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(Path.of(ActiveMoltenBlockEntity.configDir + "/convertible", new String[0]), new FileAttribute[0]);
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(dir.toString()));
            JsonObject defaultData = (JsonObject)gson.fromJson("{\n  \"values\": [\n    \"minecraft:lava\"\n  ]\n}", JsonObject.class);
            gson.toJson((JsonElement)defaultData, writer);
            writer.close();
        }
    }
}

