/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.world.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import vectorwing.farmersdelight.common.world.configuration.WildCropConfiguration;

public class WildCropFeature
extends Feature<WildCropConfiguration> {
    public WildCropFeature(Codec<WildCropConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<WildCropConfiguration> context) {
        WildCropConfiguration config = (WildCropConfiguration)context.config();
        BlockPos origin = context.origin();
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        int i = 0;
        int tries = config.tries();
        int xzSpread = config.xzSpread() + 1;
        int ySpread = config.ySpread() + 1;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        Holder<PlacedFeature> floorFeature = config.floorFeature();
        if (floorFeature != null) {
            for (int j = 0; j < tries; ++j) {
                mutablePos.setWithOffset((Vec3i)origin, random.nextInt(xzSpread) - random.nextInt(xzSpread), random.nextInt(ySpread) - random.nextInt(ySpread), random.nextInt(xzSpread) - random.nextInt(xzSpread));
                if (!((PlacedFeature)config.floorFeature().value()).place(level, context.chunkGenerator(), random, (BlockPos)mutablePos)) continue;
                ++i;
            }
        }
        for (int k = 0; k < tries; ++k) {
            int shorterXZ = xzSpread - 2;
            mutablePos.setWithOffset((Vec3i)origin, random.nextInt(shorterXZ) - random.nextInt(shorterXZ), random.nextInt(ySpread) - random.nextInt(ySpread), random.nextInt(shorterXZ) - random.nextInt(shorterXZ));
            if (!((PlacedFeature)config.primaryFeature().value()).place(level, context.chunkGenerator(), random, (BlockPos)mutablePos)) continue;
            ++i;
        }
        for (int l = 0; l < tries; ++l) {
            mutablePos.setWithOffset((Vec3i)origin, random.nextInt(xzSpread) - random.nextInt(xzSpread), random.nextInt(ySpread) - random.nextInt(ySpread), random.nextInt(xzSpread) - random.nextInt(xzSpread));
            if (!((PlacedFeature)config.secondaryFeature().value()).place(level, context.chunkGenerator(), random, (BlockPos)mutablePos)) continue;
            ++i;
        }
        return i > 0;
    }
}

