/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.neoforge;

import java.util.function.Consumer;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.Sounds;
import net.conczin.immersive_furniture.block.Blocks;
import net.conczin.immersive_furniture.block.entity.BlockEntityTypes;
import net.conczin.immersive_furniture.data.FurnitureDataManager;
import net.conczin.immersive_furniture.entity.Entities;
import net.conczin.immersive_furniture.item.Items;
import net.conczin.immersive_furniture.network.ImmersivePayload;
import net.conczin.immersive_furniture.network.Network;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="immersive_furniture")
@EventBusSubscriber(modid="immersive_furniture")
public final class CommonNeoForge {
    private static <T> void registerHelper(RegisterEvent event, Registry<T> register, Consumer<Common.RegisterHelper<T>> consumer) {
        event.register(register.key(), registry -> consumer.accept((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)registry).register(arg_0, arg_1)));
    }

    @SubscribeEvent
    public static void register(RegisterEvent event) {
        CommonNeoForge.registerHelper(event, BuiltInRegistries.ITEM, Items::registerItems);
        CommonNeoForge.registerHelper(event, BuiltInRegistries.BLOCK, Blocks::registerBlocks);
        CommonNeoForge.registerHelper(event, BuiltInRegistries.SOUND_EVENT, Sounds::registerSounds);
        CommonNeoForge.registerHelper(event, BuiltInRegistries.ENTITY_TYPE, Entities::registerEntities);
        if (event.getRegistryKey() == Registries.BLOCK_ENTITY_TYPE) {
            event.register(Registries.BLOCK_ENTITY_TYPE, helper -> BlockEntityTypes.register((ResourceLocation name, BlockEntityTypes.BlockEntitySupplier<E> factory, Block block) -> {
                BlockEntityType build = BlockEntityType.Builder.of(factory::create, (Block[])new Block[]{block}).build(null);
                helper.register(name, (Object)build);
                return build;
            }));
        }
    }

    @SubscribeEvent
    public static void registerNetwork(RegisterPayloadHandlersEvent event) {
        Network.register(new NeoForgeRegistrar(event.registrar("1")));
        Network.registerSender((x$0, x$1) -> PacketDistributor.sendToPlayer((ServerPlayer)x$0, (CustomPacketPayload)x$1, (CustomPacketPayload[])new CustomPacketPayload[0]));
        Network.registerClientSender(x$0 -> PacketDistributor.sendToServer((CustomPacketPayload)x$0, (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    @SubscribeEvent
    public static void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            event.accept((ItemLike)Items.ARTISANS_WORKSTATION);
        } else if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.accept((ItemLike)Items.CRAFTING_MATERIAL);
        }
    }

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        FurnitureDataManager.setWorldRoot(event.getServer().getWorldPath(LevelResource.ROOT));
    }

    static class NeoForgeRegistrar
    implements Network.Registrar {
        PayloadRegistrar registrar;

        public NeoForgeRegistrar(PayloadRegistrar registrar) {
            this.registrar = registrar;
        }

        @Override
        public <T extends ImmersivePayload> void register(CustomPacketPayload.Type<T> type, StreamCodec<FriendlyByteBuf, T> codec, boolean isServer) {
            if (isServer) {
                this.registrar.playToServer(type, codec, (payload, ctx) -> ctx.enqueueWork(() -> payload.handle(ctx.player())));
            } else {
                this.registrar.playToClient(type, codec, (payload, ctx) -> ctx.enqueueWork(() -> payload.handle(ctx.player())));
            }
        }
    }
}

