/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.item;

import java.util.List;
import java.util.Objects;
import net.conczin.immersive_furniture.block.BaseFurnitureBlock;
import net.conczin.immersive_furniture.block.Blocks;
import net.conczin.immersive_furniture.block.EntityFurnitureBlock;
import net.conczin.immersive_furniture.block.FurnitureBlock;
import net.conczin.immersive_furniture.block.FurnitureProxyBlock;
import net.conczin.immersive_furniture.block.LightFurnitureBlock;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.FurnitureDataManager;
import net.conczin.immersive_furniture.data.ServerFurnitureRegistry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class FurnitureItem
extends BlockItem {
    public static final DataComponentType<FurnitureData> FURNITURE = (DataComponentType)Registry.register((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"immersive_furniture:furniture", (Object)DataComponentType.builder().persistent(FurnitureData.CODEC).networkSynchronized(FurnitureData.STREAM_CODEC).build());

    public FurnitureItem(Item.Properties settings) {
        super(Blocks.FURNITURE, settings);
    }

    public Component getName(ItemStack stack) {
        return Component.literal((String)FurnitureItem.getData((ItemStack)stack).name);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        FurnitureData data = FurnitureItem.getData(stack);
        tooltip.addAll(data.getTooltip(Screen.hasShiftDown()));
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }

    public static FurnitureData getData(ItemStack stack) {
        return (FurnitureData)stack.getOrDefault(FURNITURE, (Object)FurnitureData.EMPTY);
    }

    public static void setData(ItemStack stack, FurnitureData data) {
        stack.set(FURNITURE, (Object)data);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        if (!super.canPlace(context, state)) {
            return false;
        }
        FurnitureData data = FurnitureItem.getData(context.getItemInHand());
        Level level = context.getLevel();
        BlockPos basePos = context.getClickedPos();
        Direction facing = (Direction)state.getValue((Property)FurnitureBlock.FACING);
        for (int x = 0; x < data.size.x; ++x) {
            for (int y = 0; y < data.size.y; ++y) {
                for (int z = 0; z < data.size.z; ++z) {
                    BlockPos proxyPos;
                    if (x == 0 && y == 0 && z == 0 || level.getBlockState(proxyPos = BaseFurnitureBlock.getProxyPosition(basePos, facing, x, y, z)).canBeReplaced(context)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        if (!super.placeBlock(context, state)) {
            return false;
        }
        FurnitureData data = FurnitureItem.getData(context.getItemInHand());
        Level level = context.getLevel();
        BlockPos basePos = context.getClickedPos();
        Direction facing = (Direction)state.getValue((Property)FurnitureBlock.FACING);
        for (int x = 0; x < data.size.x; ++x) {
            for (int y = 0; y < data.size.y; ++y) {
                for (int z = 0; z < data.size.z; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockPos proxyPos = BaseFurnitureBlock.getProxyPosition(basePos, facing, x, y, z);
                    FluidState fluidstate = context.getLevel().getFluidState(proxyPos);
                    boolean waterlogged = fluidstate.getType() == Fluids.WATER;
                    BlockState proxyState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.FURNITURE_PROXY.defaultBlockState().setValue((Property)FurnitureProxyBlock.OFFSET_X, (Comparable)Integer.valueOf(x))).setValue((Property)FurnitureProxyBlock.OFFSET_Y, (Comparable)Integer.valueOf(y))).setValue((Property)FurnitureProxyBlock.OFFSET_Z, (Comparable)Integer.valueOf(z))).setValue((Property)FurnitureProxyBlock.FACING, (Comparable)facing)).setValue((Property)FurnitureProxyBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
                    level.setBlock(proxyPos, proxyState, 3);
                }
            }
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerFurnitureRegistry.increase(serverLevel, FurnitureItem.getData(context.getItemInHand()));
        }
        FurnitureDataManager.saveHashData(data);
        return true;
    }

    protected BlockState getPlacementState(BlockPlaceContext context) {
        Level level;
        int identifier = -1;
        ItemStack stack = context.getItemInHand();
        FurnitureData data = FurnitureItem.getData(stack);
        if (!data.requiresBlockEntity() && (level = context.getLevel()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            int from = data.lightLevel > 0 ? 65536 : 0;
            int size = data.lightLevel > 0 ? 256 : 1024;
            identifier = ServerFurnitureRegistry.registerIdentifier(level2, data, from, from + size - 1);
        }
        BlockState state = identifier < 0 ? (BlockState)Objects.requireNonNull(Blocks.FURNITURE_ENTITY.getStateForPlacement(context)).setValue((Property)EntityFurnitureBlock.LIGHT, (Comparable)Integer.valueOf(data.lightLevel)) : (data.lightLevel > 0 ? (BlockState)((BlockState)Objects.requireNonNull(Blocks.FURNITURE_LIGHT.getStateForPlacement(context)).setValue((Property)LightFurnitureBlock.IDENTIFIER, (Comparable)Integer.valueOf(identifier - 65536))).setValue((Property)LightFurnitureBlock.LIGHT, (Comparable)Integer.valueOf((int)Math.ceil((float)data.lightLevel / 3.0f))) : (BlockState)Objects.requireNonNull(Blocks.FURNITURE.getStateForPlacement(context)).setValue((Property)FurnitureBlock.IDENTIFIER, (Comparable)Integer.valueOf(identifier)));
        return this.canPlace(context, state) ? state : null;
    }
}

