/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.entity;

import java.util.ArrayList;
import java.util.Comparator;
import net.conczin.immersive_furniture.block.BaseFurnitureBlock;
import net.conczin.immersive_furniture.entity.Entities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3i;

public class SittingEntity
extends Entity {
    private Vec3 dismountPosition;
    private BlockPos blockPos;
    private Vector3i size;
    private Direction direction;

    public SittingEntity(EntityType<SittingEntity> type, Level level) {
        super(type, level);
    }

    public SittingEntity(Level level, Vec3 pos, BlockPos blockPos, Vector3i size, Direction direction, Vec3 dismountPosition) {
        super(Entities.SITTING, level);
        this.setPos(pos.x, pos.y, pos.z);
        this.dismountPosition = dismountPosition;
        this.blockPos = blockPos;
        this.size = size;
        this.direction = direction;
        this.noPhysics = true;
    }

    public Vec3 tryDismountAt(LivingEntity passenger, BlockPos targetPos, int height) {
        BlockPos.MutableBlockPos pos = targetPos.mutable();
        double maxY = pos.getY() + height;
        block0: for (Pose pose : passenger.getDismountPoses()) {
            pos.set((Vec3i)targetPos);
            while ((double)pos.getY() < maxY) {
                double floorHeight = this.level().getBlockFloorHeight((BlockPos)pos);
                if ((double)pos.getY() + floorHeight > maxY) continue block0;
                if (DismountHelper.isBlockFloorValid((double)floorHeight)) {
                    AABB bounds = passenger.getLocalBoundsForPose(pose);
                    Vec3 candidate = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + floorHeight, (double)pos.getZ() + 0.5);
                    if (DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)passenger, (AABB)bounds.move(candidate))) {
                        passenger.setPose(pose);
                        return candidate;
                    }
                }
                pos.move(Direction.UP);
            }
        }
        return null;
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        if (this.blockPos == null || this.size == null || this.dismountPosition == null || this.direction == null) {
            return super.getDismountLocationForPassenger(passenger);
        }
        double radius = (float)(Math.abs(this.size.x) + Math.abs(this.size.z)) / 2.0f;
        Vec3 center = new Vec3(this.getX() - Math.sin(Math.toRadians(passenger.getYRot())) * radius, this.getY(), this.getZ() + Math.cos(Math.toRadians(passenger.getYRot())) * radius);
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        int y = (int)Math.floor(center.y);
        for (int x = -1; x <= this.size.x(); ++x) {
            candidates.add(BaseFurnitureBlock.getProxyPosition(this.blockPos, this.direction, x, 0, -1));
            candidates.add(BaseFurnitureBlock.getProxyPosition(this.blockPos, this.direction, x, 0, this.size.z()));
        }
        for (int z = -1; z <= this.size.z(); ++z) {
            candidates.add(BaseFurnitureBlock.getProxyPosition(this.blockPos, this.direction, -1, 0, z));
            candidates.add(BaseFurnitureBlock.getProxyPosition(this.blockPos, this.direction, this.size.x(), 0, z));
        }
        candidates.sort(Comparator.comparingDouble(pos -> pos.distToCenterSqr(center.x, center.y, center.z)));
        for (BlockPos pos2 : candidates) {
            Vec3 result = this.tryDismountAt(passenger, pos2, this.size.y);
            if (result == null) continue;
            return result;
        }
        return this.dismountPosition;
    }

    public void tick() {
        super.tick();
        if (!(this.level().isClientSide || this.isVehicle() && this.dismountPosition != null || this.isRemoved())) {
            this.discard();
        }
    }

    public void onPassengerTurned(Entity passenger) {
        super.onPassengerTurned(passenger);
        this.clampRotation(passenger);
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction callback) {
        super.positionRider(passenger, callback);
        this.clampRotation(passenger);
    }

    public void clampRotation(Entity passenger) {
        float delta = Mth.wrapDegrees((float)(passenger.getYRot() - this.getYRot()));
        float clampedDelta = Mth.clamp((float)delta, (float)-105.0f, (float)105.0f);
        passenger.yRotO += clampedDelta - delta;
        passenger.setYBodyRot(this.getYRot());
        passenger.setYRot(passenger.getYRot() + clampedDelta - delta);
        passenger.setYHeadRot(passenger.getYRot());
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return super.getPassengerRidingPosition(entity);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }

    public boolean shouldBeSaved() {
        return false;
    }
}

