/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.data.api;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.config.Config;
import net.minecraft.Util;

public class Auth {
    static final SecureRandom random = new SecureRandom();
    static final String FILE_NAME = "./immersiveLibraryTokenFurniture";
    static String currentToken;

    private static String newToken() {
        byte[] bytes = new byte[64];
        random.nextBytes(bytes);
        return Auth.sha256(new String(bytes));
    }

    private static Path getTokenPath() {
        return Paths.get(FILE_NAME, new String[0]);
    }

    public static String loadToken() {
        try {
            return Files.readString(Auth.getTokenPath());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getToken() {
        if (currentToken == null) {
            currentToken = Auth.loadToken();
        }
        return currentToken;
    }

    public static boolean hasToken() {
        return Auth.getToken() != null;
    }

    public static void saveToken() {
        try {
            Files.writeString(Paths.get(FILE_NAME, new String[0]), (CharSequence)currentToken, new OpenOption[0]);
        }
        catch (IOException e) {
            Common.logger.error("Failed to save token!", (Throwable)e);
        }
    }

    public static void clearToken() {
        Auth.getTokenPath().toFile().delete();
    }

    public static String sha256(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String createDataState(String username, String token) {
        JsonObject json = new JsonObject();
        json.addProperty("username", Base64.getEncoder().encodeToString(username.getBytes()));
        json.addProperty("token", Base64.getEncoder().encodeToString(Auth.sha256(token).getBytes()));
        return Base64.getEncoder().encodeToString(json.toString().getBytes());
    }

    public static void authenticate(String username) {
        currentToken = Auth.newToken();
        String url = Config.getInstance().immersiveLibraryUrl + "/v1/login?state=" + Auth.createDataState(username, currentToken);
        Util.getPlatform().openUri(url);
    }
}

