/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.data;

import java.util.HashMap;
import java.util.Map;
import net.conczin.immersive_furniture.config.Config;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.FurnitureRegistry;
import net.conczin.immersive_furniture.network.Network;
import net.conczin.immersive_furniture.network.s2c.FurnitureRegistryMessage;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;

public class ServerFurnitureRegistry {
    public static FurnitureRegistrySavedData getData(ServerLevel level) {
        return (FurnitureRegistrySavedData)level.getServer().overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(FurnitureRegistrySavedData::new, FurnitureRegistrySavedData::new, null), "immersive_furniture");
    }

    public static void increase(ServerLevel level, FurnitureData data) {
        String hash = data.getHash();
        FurnitureRegistrySavedData registry = ServerFurnitureRegistry.getData(level);
        registry.usageCount.put(hash, registry.usageCount.getOrDefault(hash, 0) + 1);
        registry.setDirty();
    }

    public static int registerIdentifier(ServerLevel level, FurnitureData data, int from, int to) {
        String hash = data.getHash();
        FurnitureRegistrySavedData saveData = ServerFurnitureRegistry.getData(level);
        if (saveData.registry.hashToIdentifier.containsKey(hash)) {
            return saveData.registry.hashToIdentifier.get(hash);
        }
        int count = saveData.usageCount.getOrDefault(hash, 0);
        if (count < Config.getInstance().lowMemoryModeThreshold) {
            return -1;
        }
        for (int identifier = from; identifier <= to; ++identifier) {
            if (saveData.registry.identifierToHash.containsKey(identifier)) continue;
            saveData.registry.hashToIdentifier.put(hash, identifier);
            saveData.registry.identifierToHash.put(identifier, hash);
            saveData.setDirty();
            FurnitureRegistryMessage message = new FurnitureRegistryMessage(Map.of(identifier, hash));
            for (ServerPlayer player : level.players()) {
                Network.sendToPlayer(message, player);
            }
            return identifier;
        }
        return -1;
    }

    public static void syncWithPlayer(ServerPlayer player) {
        int chunkSize = 128;
        FurnitureRegistrySavedData savedData = ServerFurnitureRegistry.getData(player.serverLevel());
        HashMap<Integer, String> subMap = new HashMap<Integer, String>();
        for (String hash : savedData.registry.hashToIdentifier.keySet()) {
            int identifier = savedData.registry.hashToIdentifier.get(hash);
            subMap.put(identifier, hash);
            if (subMap.size() < chunkSize) continue;
            FurnitureRegistryMessage message = new FurnitureRegistryMessage(subMap);
            Network.sendToPlayer(message, player);
            subMap.clear();
        }
        if (!subMap.isEmpty()) {
            FurnitureRegistryMessage message = new FurnitureRegistryMessage(subMap);
            Network.sendToPlayer(message, player);
        }
    }

    public static class FurnitureRegistrySavedData
    extends SavedData {
        final Map<String, Integer> usageCount = new HashMap<String, Integer>();
        final FurnitureRegistry registry = FurnitureRegistry.INSTANCE;

        public FurnitureRegistrySavedData() {
        }

        public FurnitureRegistrySavedData(CompoundTag nbt, HolderLookup.Provider provider) {
            CompoundTag usageCountTag = nbt.getCompound("usageCount");
            usageCountTag.getAllKeys().forEach(key -> this.usageCount.put((String)key, usageCountTag.getInt(key)));
            CompoundTag hashToIdentifierTag = nbt.getCompound("hashToIdentifier");
            hashToIdentifierTag.getAllKeys().forEach(key -> {
                this.registry.hashToIdentifier.put((String)key, hashToIdentifierTag.getInt(key));
                this.registry.identifierToHash.put(hashToIdentifierTag.getInt(key), (String)key);
            });
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
            CompoundTag usageCountTag = new CompoundTag();
            this.usageCount.forEach((arg_0, arg_1) -> ((CompoundTag)usageCountTag).putInt(arg_0, arg_1));
            nbt.put("usageCount", (Tag)usageCountTag);
            CompoundTag hashToIdentifierTag = new CompoundTag();
            this.registry.hashToIdentifier.forEach((arg_0, arg_1) -> ((CompoundTag)hashToIdentifierTag).putInt(arg_0, arg_1));
            nbt.put("hashToIdentifier", (Tag)hashToIdentifierTag);
            return nbt;
        }
    }
}

