/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.data;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.client.model.DynamicAtlas;
import net.conczin.immersive_furniture.config.Config;
import net.conczin.immersive_furniture.data.ElementRotation;
import net.conczin.immersive_furniture.data.ModelUtils;
import net.conczin.immersive_furniture.data.TransparencyType;
import net.conczin.immersive_furniture.utils.NBTHelper;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;

public class FurnitureData {
    public static final Codec<FurnitureData> CODEC = CompoundTag.CODEC.xmap(FurnitureData::new, FurnitureData::toTag);
    public static final StreamCodec<FriendlyByteBuf, FurnitureData> STREAM_CODEC = StreamCodec.ofMember((data, buf) -> buf.writeNbt((Tag)data.toTag()), buf -> new FurnitureData(buf.readNbt()));
    public static final FurnitureData EMPTY = new FurnitureData();
    public String name = "Empty";
    public String tag = "miscellaneous";
    public int lightLevel;
    public int inventorySize;
    public boolean toggleWithRightClick;
    public boolean toggleLight;
    public int contentid = -1;
    public String author = "Unknown";
    public String originalAuthor = "";
    public Set<String> sources = new HashSet<String>();
    public Set<String> dependencies = new HashSet<String>();
    public final List<Element> elements = new LinkedList<Element>();
    public Vector3i size = new Vector3i(1, 1, 1);
    private String hash;
    private final Map<Integer, VoxelShape> cachedFullShapes = new ConcurrentHashMap<Integer, VoxelShape>();
    private final Map<Integer, VoxelShape> cachedSubShapes = new ConcurrentHashMap<Integer, VoxelShape>();
    private final Set<Integer> requestedFullShapes = new ConcurrentSkipListSet<Integer>();
    private final Set<Integer> requestedSubShapes = new ConcurrentSkipListSet<Integer>();
    public long lastTick = 0L;

    public FurnitureData() {
        this.elements.add(new Element());
    }

    public FurnitureData(CompoundTag tag) {
        this.name = NBTHelper.getString(tag, "Name", this.name);
        this.tag = NBTHelper.getString(tag, "Tag", this.tag);
        this.lightLevel = NBTHelper.getInt(tag, "LightLevel", this.lightLevel);
        this.inventorySize = NBTHelper.getInt(tag, "InventorySize", this.inventorySize);
        this.toggleWithRightClick = NBTHelper.getBoolean(tag, "ToggleWithRightClick", this.toggleWithRightClick);
        this.toggleLight = NBTHelper.getBoolean(tag, "ToggleLight", this.toggleLight);
        this.contentid = NBTHelper.getInt(tag, "ContentID", this.contentid);
        this.author = NBTHelper.getString(tag, "Author", this.author);
        this.originalAuthor = NBTHelper.getString(tag, "OriginalAuthor", this.originalAuthor);
        this.sources = NBTHelper.getStringSet(tag.getList("Sources", 8));
        this.dependencies = NBTHelper.getStringSet(tag.getList("Dependencies", 8));
        this.size = new Vector3i(NBTHelper.getInt(tag, "SizeX", 1), NBTHelper.getInt(tag, "SizeY", 1), NBTHelper.getInt(tag, "SizeZ", 1));
        ListTag elementsTag = tag.getList("Elements", 10);
        for (int i = 0; i < elementsTag.size(); ++i) {
            this.elements.add(new Element(elementsTag.getCompound(i)));
        }
    }

    public FurnitureData(FurnitureData data) {
        this.name = data.name;
        this.tag = data.tag;
        this.lightLevel = data.lightLevel;
        this.inventorySize = data.inventorySize;
        this.toggleWithRightClick = data.toggleWithRightClick;
        this.toggleLight = data.toggleLight;
        this.author = data.author;
        this.originalAuthor = data.originalAuthor.isEmpty() ? data.author : data.originalAuthor;
        this.sources.addAll(data.sources);
        this.dependencies.addAll(data.dependencies);
        this.hash = null;
        this.lastTick = 0L;
        for (Element element : data.elements) {
            this.elements.add(new Element(element));
        }
        this.size = new Vector3i(data.size.x, data.size.y, data.size.z);
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.putString("Name", this.name);
        tag.putString("Tag", this.tag);
        tag.putInt("LightLevel", this.lightLevel);
        tag.putInt("InventorySize", this.inventorySize);
        tag.putBoolean("ToggleWithRightClick", this.toggleWithRightClick);
        tag.putBoolean("ToggleLight", this.toggleLight);
        tag.putInt("ContentID", this.contentid);
        tag.putString("Author", this.author);
        tag.putString("OriginalAuthor", this.originalAuthor);
        tag.put("Sources", (Tag)NBTHelper.getStringList(this.sources));
        tag.put("Dependencies", (Tag)NBTHelper.getStringList(this.dependencies));
        tag.putInt("SizeX", this.size.x);
        tag.putInt("SizeY", this.size.y);
        tag.putInt("SizeZ", this.size.z);
        ListTag elementsTag = new ListTag();
        for (Element element : this.elements) {
            elementsTag.add((Object)element.toTag());
        }
        tag.put("Elements", (Tag)elementsTag);
        return tag;
    }

    public int getCost() {
        double volume = Math.sqrt(this.getVolume()) / 32.0;
        double cost = volume + (double)this.inventorySize * 0.5 + (double)this.lightLevel / 15.0 + (double)this.elements.size() / 4.0;
        return (int)Math.ceil(cost * (double)Config.getInstance().costMultiplier);
    }

    public AABB boundingBox() {
        if (this.elements.isEmpty()) {
            return new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float minZ = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        float maxZ = Float.MIN_VALUE;
        for (Element element : this.elements) {
            if (element.type != ElementType.ELEMENT && element.type != ElementType.SPRITE) continue;
            Vector3f from = element.from;
            Vector3f to = element.to;
            minX = Math.min(minX, from.x);
            minY = Math.min(minY, from.y);
            minZ = Math.min(minZ, from.z);
            maxX = Math.max(maxX, to.x);
            maxY = Math.max(maxY, to.y);
            maxZ = Math.max(maxZ, to.z);
        }
        return new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public int getVolume() {
        int volume = 0;
        for (Element element : this.elements) {
            if (element.type != ElementType.ELEMENT) continue;
            Vector3i size = element.getSize();
            volume += size.x * size.y * size.z;
        }
        return volume;
    }

    public double getSize() {
        AABB boundingBox = this.boundingBox();
        return Math.max(Math.max(Math.abs(boundingBox.minX - 8.0), Math.abs(boundingBox.minY - 8.0)), Math.max(Math.max(Math.abs(boundingBox.minZ - 8.0), Math.abs(boundingBox.maxX - 8.0)), Math.max(Math.abs(boundingBox.maxY - 8.0), Math.abs(boundingBox.maxZ - 8.0))));
    }

    public boolean requiresBlockEntity() {
        return this.inventorySize > 0;
    }

    public String getHash() {
        if (this.hash == null) {
            this.hash = this.computeHash();
        }
        return this.hash;
    }

    public String computeHash() {
        return Utils.hashNbt(new FurnitureData(this).toTag());
    }

    public void dirty() {
        this.hash = null;
        this.cachedFullShapes.clear();
        this.cachedSubShapes.clear();
        this.requestedFullShapes.clear();
        this.requestedSubShapes.clear();
        for (Element element : this.elements) {
            element.rotationAxes = null;
            element.bakedTextures.clear();
        }
    }

    public void playInteractSound(Level level, BlockPos pos, int state, Player player) {
        for (Element element : this.elements) {
            if (!element.isMasked(state) || element.type != ElementType.SOUND_EMITTER || !element.soundEmitter.onInteract) continue;
            FurnitureData.playSound(level, pos, player.getRandom(), element);
        }
    }

    public void emitInteractParticles(BlockPos pos, Direction direction, int state, Player player, ParticleConsumer particleConsumer, boolean inScreen) {
        for (Element element : this.elements) {
            if (!element.isMasked(state) || element.type != ElementType.PARTICLE_EMITTER || !element.particleEmitter.onInteract) continue;
            this.emitParticles(pos, direction, player.getRandom(), element, particleConsumer, inScreen, 10.0f);
        }
    }

    public boolean hasParticles() {
        return this.elements.stream().anyMatch(e -> e.type == ElementType.PARTICLE_EMITTER);
    }

    public boolean hasSounds() {
        return this.elements.stream().anyMatch(e -> e.type == ElementType.SOUND_EMITTER);
    }

    public boolean canSit() {
        return this.elements.stream().anyMatch(e -> e.type == ElementType.PLAYER_POSE && e.playerPose.pose == Pose.SITTING);
    }

    public boolean canSleep() {
        return this.elements.stream().anyMatch(e -> e.type == ElementType.PLAYER_POSE && e.playerPose.pose == Pose.SLEEPING);
    }

    public boolean hasDisplayItems() {
        return this.elements.stream().anyMatch(e -> e.type == ElementType.SPRITE && e.sprite.item);
    }

    public Set<Integer> getUniqueSolidStates() {
        Map<Integer, Long> maskCounts = this.elements.stream().filter(e -> e.type == ElementType.ELEMENT || e.type == ElementType.SPRITE).collect(Collectors.groupingBy(e -> e.mask, Collectors.counting()));
        HashSet<Integer> states = new HashSet<Integer>();
        long firstHash = -1L;
        for (int state = 0; state < 2; ++state) {
            long hash = 0L;
            for (Map.Entry<Integer, Long> entry : maskCounts.entrySet()) {
                if ((entry.getKey() & 1 << state) == 0) continue;
                hash += 1024L * (long)entry.getKey().intValue() + entry.getValue();
            }
            if (hash != firstHash) {
                states.add(state);
            }
            if (state != 0) continue;
            firstHash = hash;
        }
        return states;
    }

    public List<Component> getTooltip(boolean advanced) {
        LinkedList<Component> tooltip = new LinkedList<Component>();
        tooltip.add((Component)Component.translatable((String)"gui.immersive_furniture.author", (Object[])new Object[]{this.author}).withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
        if (!this.originalAuthor.isEmpty() && !this.originalAuthor.equals(this.author)) {
            tooltip.add((Component)Component.translatable((String)"gui.immersive_furniture.original_author", (Object[])new Object[]{this.originalAuthor}).withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.translatable((String)("gui.immersive_furniture.tag." + this.tag.toLowerCase(Locale.ROOT))).withStyle(ChatFormatting.GOLD).append(this.getPrefixedSizeTooltip()));
        if (this.lightLevel > 0) {
            tooltip.add((Component)Component.translatable((String)"gui.immersive_furniture.light_level", (Object[])new Object[]{this.lightLevel}).withStyle(ChatFormatting.YELLOW));
        }
        if (this.inventorySize > 0) {
            tooltip.add((Component)Component.translatable((String)"gui.immersive_furniture.inventory", (Object[])new Object[]{this.inventorySize}).withStyle(ChatFormatting.YELLOW));
        }
        if (this.hasParticles()) {
            tooltip.add((Component)Component.translatable((String)"gui.immersive_furniture.has_particles").withStyle(ChatFormatting.YELLOW));
        }
        if (this.hasSounds()) {
            tooltip.add((Component)Component.translatable((String)"gui.immersive_furniture.has_sounds").withStyle(ChatFormatting.YELLOW));
        }
        if (this.canSit()) {
            tooltip.add((Component)Component.translatable((String)"gui.immersive_furniture.can_sit").withStyle(ChatFormatting.YELLOW));
        }
        if (this.canSleep()) {
            tooltip.add((Component)Component.translatable((String)"gui.immersive_furniture.can_sleep").withStyle(ChatFormatting.YELLOW));
        }
        if (this.hasDisplayItems()) {
            tooltip.add((Component)Component.translatable((String)"gui.immersive_furniture.has_display_items").withStyle(ChatFormatting.YELLOW));
        }
        if (this.getUniqueSolidStates().size() > 1) {
            tooltip.add((Component)Component.translatable((String)"gui.immersive_furniture.has_states").withStyle(ChatFormatting.YELLOW));
        }
        boolean hasAdvanced = false;
        if (!this.sources.isEmpty()) {
            hasAdvanced = true;
            if (advanced) {
                tooltip.add((Component)Component.translatable((String)"gui.immersive_furniture.sources").withStyle(ChatFormatting.GRAY));
                for (String string : this.sources) {
                    tooltip.add((Component)Component.literal((String)("- " + string)).withStyle(ChatFormatting.GRAY));
                }
            }
        }
        if (!this.dependencies.isEmpty()) {
            hasAdvanced = true;
            if (advanced) {
                tooltip.add((Component)Component.translatable((String)"gui.immersive_furniture.dependencies").withStyle(ChatFormatting.GRAY));
                for (String string : this.dependencies) {
                    tooltip.add((Component)Component.literal((String)("- " + string)).withStyle(ChatFormatting.GRAY));
                }
            }
        }
        if (advanced) {
            int pixels = 0;
            for (Element element : this.elements) {
                for (Map<Integer, int[]> texture : element.bakedTextures.textures.values()) {
                    for (Map.Entry<Integer, int[]> states : texture.entrySet()) {
                        pixels += states.getValue().length;
                    }
                }
            }
            double d = (double)pixels / Math.pow(DynamicAtlas.BAKED.getSize(), 2.0);
            tooltip.add((Component)Component.translatable((String)"gui.immersive_furniture.atlas_usage", (Object[])new Object[]{String.format("%.1f%%", d * 100.0)}).withStyle(ChatFormatting.DARK_GRAY));
        }
        if (hasAdvanced && !advanced) {
            tooltip.add((Component)Component.translatable((String)"gui.immersive_furniture.tooltip").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
        return tooltip;
    }

    private Component getPrefixedSizeTooltip() {
        Component sizeTooltip = this.getSizeTooltip();
        if (sizeTooltip == null) {
            return Component.literal((String)"");
        }
        return Component.literal((String)" - ").append(sizeTooltip).withStyle(ChatFormatting.GRAY);
    }

    private Component getSizeTooltip() {
        if (this.size.x == 1 && this.size.y == 1 && this.size.z == 1) {
            return null;
        }
        if (this.size.x == 1 && this.size.y == 1) {
            return Component.translatable((String)"gui.immersive_furniture.n_deep", (Object[])new Object[]{this.size.z});
        }
        if (this.size.x == 1 && this.size.z == 1) {
            return Component.translatable((String)"gui.immersive_furniture.n_tall", (Object[])new Object[]{this.size.y});
        }
        if (this.size.y == 1 && this.size.z == 1) {
            return Component.translatable((String)"gui.immersive_furniture.n_wide", (Object[])new Object[]{this.size.x});
        }
        return Component.literal((String)String.format("%sx%sx%s", this.size.x, this.size.y, this.size.z));
    }

    public PoseOffset getClosestPose(Vec3 location, Direction direction) {
        float bestDistance = Float.MAX_VALUE;
        PoseOffset found = null;
        for (Element element : this.elements) {
            if (element.type != ElementType.PLAYER_POSE) continue;
            Vector3f center = FurnitureData.rotate(element.getRotationAxes().center(), direction).mul(0.0625f);
            double distance = location.distanceToSqr((double)center.x, (double)center.y, (double)center.z);
            if (found != null && !(distance < (double)bestDistance)) continue;
            bestDistance = (float)distance;
            Vector3f forward = FurnitureData.rotateVector(element.getRotationAxes().forward(), direction).normalize();
            Vector3f up = FurnitureData.rotateVector(element.getRotationAxes().up(), direction).normalize();
            if (element.playerPose.pose == Pose.SLEEPING) {
                center.add((Vector3fc)forward.mul(0.5625f));
                center.sub((Vector3fc)up.mul(-0.0625f));
            } else {
                center.add((Vector3fc)forward.mul(0.125f));
                center.sub((Vector3fc)up.mul(0.03125f));
            }
            found = new PoseOffset(center, element.playerPose.pose, -element.rotation + direction.toYRot() % 360.0f);
        }
        return found;
    }

    private void emitParticles(BlockPos pos, Direction direction, RandomSource random, Element element, ParticleConsumer particleConsumer, boolean inScreen, float amountMultiplier) {
        SimpleParticleType particle = element.particleEmitter.getParticle();
        if (particle == null) {
            return;
        }
        for (float c = element.particleEmitter.amount * amountMultiplier - random.nextFloat(); c > 0.0f; c -= 1.0f) {
            Vector3f sampledPos = element.sampleRandomPosition(random, direction).mul(0.0625f);
            Vector3f up = new Vector3f((Vector3fc)element.getRotationAxes().up()).div(Math.abs(element.to.y - element.from.y) + 0.001f);
            float vr = element.particleEmitter.velocityRandom / 16.0f;
            float vd = element.particleEmitter.velocityDirectional / 16.0f;
            particleConsumer.addParticle(particle, sampledPos.x() + (inScreen ? 0.0f : (float)pos.getX()), sampledPos.y() + (inScreen ? 1024.0f : (float)pos.getY()), sampledPos.z() + (inScreen ? 0.0f : (float)pos.getZ()), (random.nextFloat() - 0.5f) * vr + up.x() * vd, (random.nextFloat() - 0.5f) * vr + up.y() * vd, (random.nextFloat() - 0.5f) * vr + up.z() * vd);
        }
    }

    public void tick(Level level, BlockPos pos, int state, Direction direction, RandomSource random, ParticleConsumer particleConsumer, boolean inScreen, boolean inEditor) {
        for (Element element : this.elements) {
            if (!element.isMasked(state)) continue;
            if (element.type == ElementType.PARTICLE_EMITTER && !element.particleEmitter.onInteract) {
                this.emitParticles(pos, direction, random, element, particleConsumer, inScreen, 1.0f);
                continue;
            }
            if (element.type != ElementType.SOUND_EMITTER || inScreen && !inEditor || !(element.soundEmitter.frequency > 0.0f) || !(random.nextFloat() < element.soundEmitter.frequency)) continue;
            FurnitureData.playSound(level, pos, random, element);
        }
    }

    private static void playSound(Level level, BlockPos pos, RandomSource random, Element element) {
        SoundEvent soundEvent = element.soundEmitter.getSoundEvent();
        if (soundEvent == null) {
            return;
        }
        level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, soundEvent, SoundSource.BLOCKS, (0.75f + random.nextFloat()) * element.soundEmitter.volume, (0.75f + random.nextFloat()) * element.soundEmitter.pitch, false);
    }

    public VoxelShape getShape(Direction rotation, int state) {
        return this.cachedFullShapes.computeIfAbsent(rotation.ordinal() * 31 + state, key -> this.computeShape(rotation, state));
    }

    public VoxelShape getShape(Direction rotation, int state, int offsetX, int offsetY, int offsetZ) {
        return this.cachedSubShapes.computeIfAbsent((((rotation.ordinal() * 31 + offsetX) * 31 + offsetY) * 31 + offsetZ) * 31 + state, key -> this.computeShape(rotation, state, offsetX, offsetY, offsetZ));
    }

    public VoxelShape getShapeLazy(Direction rotation) {
        int id = rotation.ordinal() * 31;
        if (this.cachedFullShapes.containsKey(id)) {
            return this.cachedFullShapes.get(id);
        }
        if (!this.requestedFullShapes.contains(id)) {
            this.requestedFullShapes.add(id);
            Common.EXECUTOR.execute(() -> this.getShape(rotation, 0));
        }
        return null;
    }

    public VoxelShape getShapeLazy(Direction rotation, int state, int offsetX, int offsetY, int offsetZ) {
        int id = (((rotation.ordinal() * 31 + offsetX) * 31 + offsetY) * 31 + offsetZ) * 31 + state;
        if (this.cachedSubShapes.containsKey(id)) {
            return this.cachedSubShapes.get(id);
        }
        if (!this.requestedSubShapes.contains(id)) {
            this.requestedSubShapes.add(id);
            Common.EXECUTOR.execute(() -> this.getShape(rotation, state, offsetX, offsetY, offsetZ));
        }
        return null;
    }

    private VoxelShape computeShape(Direction rotation, int state) {
        return this.elements.stream().filter(e -> e.type == ElementType.ELEMENT && !e.isFlat() && e.isMasked(state)).map(element -> this.getBox((Element)element, rotation)).reduce((a, b) -> Shapes.joinUnoptimized((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.OR)).map(VoxelShape::optimize).orElse(Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0));
    }

    public int getRotatedX(Direction facing, int x, int z) {
        return switch (facing) {
            case Direction.SOUTH -> -x;
            case Direction.EAST -> -z;
            case Direction.WEST -> z;
            default -> x;
        };
    }

    public int getRotatedZ(Direction facing, int x, int z) {
        return switch (facing) {
            case Direction.SOUTH -> -z;
            case Direction.EAST -> x;
            case Direction.WEST -> -x;
            default -> z;
        };
    }

    public VoxelShape computeShape(Direction rotation, int state, int offsetX, int offsetY, int offsetZ) {
        Vector3f start = FurnitureData.rotate(new Vector3f(offsetX == 0 ? -8.0f : 0.0f, offsetY == 0 ? -8.0f : 0.0f, offsetZ == 0 ? -8.0f : 0.0f), rotation);
        Vector3f stop = FurnitureData.rotate(new Vector3f(offsetX == this.size.x - 1 ? 24.0f : 16.0f, offsetY == this.size.y - 1 ? 24.0f : 16.0f, offsetZ == this.size.z - 1 ? 24.0f : 16.0f), rotation);
        return Shapes.join((VoxelShape)this.getShape(rotation, state).move((double)(-this.getRotatedX(rotation, offsetX, offsetZ)), (double)(-offsetY), (double)(-this.getRotatedZ(rotation, offsetX, offsetZ))), (VoxelShape)Block.box((double)Math.min(start.x, stop.x), (double)Math.min(start.y, stop.y), (double)Math.min(start.z, stop.z), (double)Math.max(start.x, stop.x), (double)Math.max(start.y, stop.y), (double)Math.max(start.z, stop.z)), (BooleanOp)BooleanOp.AND);
    }

    private static Vector3f rotate(Vector3f vec, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> new Vector3f(16.0f - vec.x, vec.y, 16.0f - vec.z);
            case Direction.EAST -> new Vector3f(16.0f - vec.z, vec.y, vec.x);
            case Direction.WEST -> new Vector3f(vec.z, vec.y, 16.0f - vec.x);
            default -> new Vector3f((Vector3fc)vec);
        };
    }

    private static Vector3f rotateVector(Vector3f vec, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> new Vector3f(-vec.x, vec.y, -vec.z);
            case Direction.EAST -> new Vector3f(-vec.z, vec.y, vec.x);
            case Direction.WEST -> new Vector3f(vec.z, vec.y, -vec.x);
            default -> new Vector3f((Vector3fc)vec);
        };
    }

    private VoxelShape getBox(Element element, Direction rotation) {
        float mid;
        Vector3f[] corners;
        Vector3f from = new Vector3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        Vector3f to = new Vector3f(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        for (Vector3f corner : corners = ModelUtils.getCorners(element)) {
            from.x = Math.min(from.x, corner.x);
            from.y = Math.min(from.y, corner.y);
            from.z = Math.min(from.z, corner.z);
            to.x = Math.max(to.x, corner.x);
            to.y = Math.max(to.y, corner.y);
            to.z = Math.max(to.z, corner.z);
        }
        double volume = element.getVolume();
        double newVolume = (to.x - from.x) * (to.y - from.y) * (to.z - from.z);
        float fraction = (float)Math.sqrt(volume / newVolume);
        if (element.axis != Direction.Axis.X) {
            mid = 0.5f * (from.x + to.x);
            from.x = from.x * fraction + mid * (1.0f - fraction);
            to.x = to.x * fraction + mid * (1.0f - fraction);
        }
        if (element.axis != Direction.Axis.Y) {
            mid = 0.5f * (from.y + to.y);
            from.y = from.y * fraction + mid * (1.0f - fraction);
            to.y = to.y * fraction + mid * (1.0f - fraction);
        }
        if (element.axis != Direction.Axis.Z) {
            mid = 0.5f * (from.z + to.z);
            from.z = from.z * fraction + mid * (1.0f - fraction);
            to.z = to.z * fraction + mid * (1.0f - fraction);
        }
        Vector3f rotatedFrom = FurnitureData.rotate(from, rotation);
        Vector3f rotatedTo = FurnitureData.rotate(to, rotation);
        float resolution = this.elements.size() > 96 ? 1.0f : (this.elements.size() > 48 ? 2.0f : 4.0f);
        return Block.box((double)((float)Math.round(Math.min(rotatedFrom.x, rotatedTo.x) * resolution) / resolution), (double)((float)Math.round(Math.min(rotatedFrom.y, rotatedTo.y) * resolution) / resolution), (double)((float)Math.round(Math.min(rotatedFrom.z, rotatedTo.z) * resolution) / resolution), (double)((float)Math.round(Math.max(rotatedFrom.x, rotatedTo.x) * resolution) / resolution), (double)((float)Math.round(Math.max(rotatedFrom.y, rotatedTo.y) * resolution) / resolution), (double)((float)Math.round(Math.max(rotatedFrom.z, rotatedTo.z) * resolution) / resolution));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof FurnitureData)) return false;
        FurnitureData data = (FurnitureData)obj;
        if (!Objects.equals(this.getHash(), data.getHash())) return false;
        return true;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public static class Element {
        public Vector3f from;
        public Vector3f to;
        public Direction.Axis axis = Direction.Axis.Y;
        public float rotation = 0.0f;
        public ElementType type = ElementType.ELEMENT;
        public int color = -1;
        public int emission = 0;
        public int mask = 3;
        public Material material;
        public ParticleEmitter particleEmitter;
        public SoundEmitter soundEmitter;
        public PlayerPose playerPose;
        public Sprite sprite;
        public ElementBakedTextures bakedTextures = new ElementBakedTextures();
        public ElementRotationAxes rotationAxes;

        public Element() {
            this.from = new Vector3f(2.0f, 0.0f, 2.0f);
            this.to = new Vector3f(14.0f, 12.0f, 14.0f);
            this.material = new Material();
            this.particleEmitter = new ParticleEmitter();
            this.soundEmitter = new SoundEmitter();
            this.playerPose = new PlayerPose();
            this.sprite = new Sprite();
        }

        public Element(CompoundTag tag) {
            this.from = NBTHelper.getVector3f(tag.getList("From", 5));
            this.to = NBTHelper.getVector3f(tag.getList("To", 5));
            this.axis = NBTHelper.getEnum(tag, Direction.Axis.class, "Axis", this.axis);
            this.rotation = NBTHelper.getFloat(tag, "Rotation", this.rotation);
            this.type = NBTHelper.getEnum(tag, ElementType.class, "Type", this.type);
            this.color = NBTHelper.getInt(tag, "Color", this.color);
            this.emission = NBTHelper.getInt(tag, "Emission", 0);
            this.material = new Material(tag.getCompound("Material"));
            this.particleEmitter = new ParticleEmitter(tag.getCompound("ParticleEmitter"));
            this.soundEmitter = new SoundEmitter(tag.getCompound("SoundEmitter"));
            this.playerPose = new PlayerPose(tag.getCompound("PlayerPose"));
            this.sprite = new Sprite(tag.getCompound("Sprite"));
            this.mask = NBTHelper.getInt(tag, "Mask", this.mask);
            this.bakedTextures = new ElementBakedTextures(tag.getCompound("BakedTexture"), tag.getCompound("BakedTextures"));
        }

        public Element(Element element) {
            this.from = new Vector3f((Vector3fc)element.from);
            this.to = new Vector3f((Vector3fc)element.to);
            this.axis = element.axis;
            this.rotation = element.rotation;
            this.type = element.type;
            this.color = element.color;
            this.emission = element.emission;
            this.mask = element.mask;
            this.material = new Material(element.material);
            this.particleEmitter = new ParticleEmitter(element.particleEmitter);
            this.soundEmitter = new SoundEmitter(element.soundEmitter);
            this.playerPose = new PlayerPose(element.playerPose);
            this.sprite = new Sprite(element.sprite);
            this.bakedTextures = new ElementBakedTextures();
            this.rotationAxes = null;
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.put("From", (Tag)NBTHelper.getFloatList(this.from));
            tag.put("To", (Tag)NBTHelper.getFloatList(this.to));
            tag.putString("Axis", this.axis.getSerializedName());
            tag.putFloat("Rotation", this.rotation);
            tag.putString("Type", this.type.name().toLowerCase());
            tag.putInt("Color", this.color);
            tag.putInt("Emission", this.emission);
            tag.putInt("Mask", this.mask);
            if (this.type == ElementType.ELEMENT) {
                tag.put("Material", (Tag)this.material.toTag());
                this.bakedTextures.save(tag);
            } else if (this.type == ElementType.PARTICLE_EMITTER) {
                tag.put("ParticleEmitter", (Tag)this.particleEmitter.toTag());
            } else if (this.type == ElementType.SOUND_EMITTER) {
                tag.put("SoundEmitter", (Tag)this.soundEmitter.toTag());
            } else if (this.type == ElementType.PLAYER_POSE) {
                tag.put("PlayerPose", (Tag)this.playerPose.toTag());
            } else if (this.type == ElementType.SPRITE) {
                tag.put("Sprite", (Tag)this.sprite.toTag());
            }
            return tag;
        }

        public Vector3i getSize() {
            return new Vector3i(Math.abs((int)(this.to.x - this.from.x)), Math.abs((int)(this.to.y - this.from.y)), Math.abs((int)(this.to.z - this.from.z)));
        }

        public float getVolume() {
            Vector3i size = this.getSize();
            return size.x * size.y * size.z;
        }

        public Vector3f getCenter() {
            return new Vector3f((this.from.x + this.to.x) / 2.0f, (this.from.y + this.to.y) / 2.0f, (this.from.z + this.to.z) / 2.0f);
        }

        public ElementRotation getRotation() {
            return new ElementRotation(this.getOrigin(), this.axis, this.rotation, false);
        }

        public Vector3f getOrigin() {
            return new Vector3f((this.from.x + this.to.x) / 32.0f, (this.from.y + this.to.y) / 32.0f, (this.from.z + this.to.z) / 32.0f);
        }

        public void sanityCheck() {
            if (this.sprite.item) {
                this.sprite.tiled = false;
                this.sprite.sprite = ResourceLocation.withDefaultNamespace((String)"item/bread");
            }
            if (this.type == ElementType.PLAYER_POSE) {
                Vector3f center = this.getCenter();
                this.from.x = center.x - 4.0f;
                this.from.y = center.y - 1.0f;
                this.from.z = center.z - (this.playerPose.pose == Pose.SLEEPING ? 14.0f : 4.0f);
                this.to.x = center.x + 4.0f;
                this.to.y = center.y + 1.0f;
                this.to.z = center.z + (this.playerPose.pose == Pose.SLEEPING ? 14.0f : 4.0f);
                this.axis = Direction.Axis.Y;
            } else if (this.type == ElementType.SPRITE) {
                Vector3f center = this.getCenter();
                if (!this.sprite.tiled) {
                    this.from.x = center.x - 8.0f * this.sprite.size;
                    this.from.y = center.y - 8.0f * this.sprite.size;
                    this.to.x = center.x + 8.0f * this.sprite.size;
                    this.to.y = center.y + 8.0f * this.sprite.size;
                }
                this.to.z = this.from.z;
            } else if (this.type == ElementType.ELEMENT) {
                this.color = -1;
            }
            this.from.x = (float)Math.round(this.from.x * 64.0f) / 64.0f;
            this.from.y = (float)Math.round(this.from.y * 64.0f) / 64.0f;
            this.from.z = (float)Math.round(this.from.z * 64.0f) / 64.0f;
            this.to.x = (float)Math.round(this.to.x - this.from.x) + this.from.x;
            this.to.y = (float)Math.round(this.to.y - this.from.y) + this.from.y;
            this.to.z = (float)Math.round(this.to.z - this.from.z) + this.from.z;
        }

        public boolean contains(Vector3f pos) {
            return this.contains(pos, 1.0E-4f);
        }

        public boolean contains(Vector3f pos, float margin) {
            return pos.x >= this.from.x - margin && pos.x <= this.to.x + margin && pos.y >= this.from.y - margin && pos.y <= this.to.y + margin && pos.z >= this.from.z - margin && pos.z <= this.to.z + margin;
        }

        public void move(float x, float y, float z) {
            this.from.add(x, y, z);
            this.to.add(x, y, z);
        }

        public ElementRotationAxes getRotationAxes() {
            if (this.rotationAxes == null) {
                this.rotationAxes = new ElementRotationAxes(this.getCenter(), this.getSize());
                ElementRotation elementRotation = this.getRotation();
                Quaternionf quaternion = ModelUtils.getElementRotation(elementRotation);
                quaternion.transform(this.rotationAxes.up);
                quaternion.transform(this.rotationAxes.right);
                quaternion.transform(this.rotationAxes.forward);
                ModelUtils.applyElementRotation(this.rotationAxes.center, elementRotation);
            }
            return this.rotationAxes;
        }

        public Vector3f sampleRandomPosition(RandomSource random, Direction direction) {
            ElementRotationAxes axes = this.getRotationAxes();
            float x = random.nextFloat() - 0.5f;
            float y = random.nextFloat() - 0.5f;
            float z = random.nextFloat() - 0.5f;
            Vector3f pos = new Vector3f(axes.center.x + x * axes.right.x + y * axes.up.x + z * axes.forward.x, axes.center.y + x * axes.right.y + y * axes.up.y + z * axes.forward.y, axes.center.z + x * axes.right.z + y * axes.up.z + z * axes.forward.z);
            if (direction != null) {
                return FurnitureData.rotate(pos, direction);
            }
            return pos;
        }

        public Vector3f getGlobalDirectionNormal(Direction direction) {
            return ModelUtils.rotate(direction.step(), this.axis, this.rotation);
        }

        public boolean isFlat() {
            return this.from.x == this.to.x || this.from.y == this.to.y || this.from.z == this.to.z;
        }

        public boolean isMasked(int state) {
            return (this.mask & 1 << state) != 0;
        }
    }

    public static enum ElementType {
        ELEMENT,
        PARTICLE_EMITTER,
        SOUND_EMITTER,
        PLAYER_POSE,
        SPRITE;

    }

    public record ElementRotationAxes(Vector3f center, Vector3f right, Vector3f up, Vector3f forward) {
        public ElementRotationAxes(Vector3f center, Vector3i size) {
            this(center, new Vector3f((float)size.x(), 0.0f, 0.0f), new Vector3f(0.0f, (float)size.y(), 0.0f), new Vector3f(0.0f, 0.0f, (float)size.z()));
        }
    }

    public static class ElementBakedTextures {
        public Map<Direction, Map<Integer, int[]>> textures = new ConcurrentHashMap<Direction, Map<Integer, int[]>>();

        public ElementBakedTextures() {
        }

        public ElementBakedTextures(CompoundTag primary, CompoundTag secondary) {
            this.loadTextures(primary);
            this.loadTextures(secondary);
        }

        private void loadTextures(CompoundTag secondary) {
            for (String key : secondary.getAllKeys()) {
                String[] split = key.split(":");
                Direction direction = (Direction)Direction.CODEC.byName(split[0]);
                int state = split.length == 1 ? 0 : Integer.parseInt(split[1]);
                this.put(direction, state, secondary.getIntArray(key));
            }
        }

        public void save(CompoundTag tag) {
            CompoundTag primary = new CompoundTag();
            CompoundTag secondary = new CompoundTag();
            for (Map.Entry<Direction, Map<Integer, int[]>> directionMapEntry : this.textures.entrySet()) {
                Direction direction = directionMapEntry.getKey();
                Map<Integer, int[]> stateMap = directionMapEntry.getValue();
                for (Map.Entry<Integer, int[]> stateEntry : stateMap.entrySet()) {
                    int state = stateEntry.getKey();
                    int[] texture = stateEntry.getValue();
                    if (state == 0) {
                        primary.putIntArray(direction.getSerializedName(), texture);
                        continue;
                    }
                    secondary.putIntArray(direction.getSerializedName() + ":" + state, texture);
                }
            }
            tag.put("BakedTexture", (Tag)primary);
            tag.put("BakedTextures", (Tag)secondary);
        }

        public void clear() {
            this.textures.clear();
        }

        public int[] get(Direction direction, int state) {
            Map<Integer, int[]> states = this.textures.get(direction);
            return states == null ? null : states.getOrDefault(state, states.get(0));
        }

        public void put(Direction direction, int state, int[] baked) {
            Map states = this.textures.computeIfAbsent(direction, k -> new HashMap());
            if (state == 0 || !states.containsKey(0) || !Arrays.equals((int[])states.get(0), baked)) {
                states.put(state, baked);
            }
        }
    }

    public static class SoundEmitter {
        public ResourceLocation sound = ResourceLocation.withDefaultNamespace((String)"entity.item.pickup");
        public float volume = 1.0f;
        public float pitch = 1.0f;
        public float frequency = 0.1f;
        public boolean onInteract = false;

        public SoundEmitter() {
        }

        public SoundEmitter(CompoundTag tag) {
            this.sound = NBTHelper.getResourceLocation(tag, "Sound", this.sound);
            this.volume = NBTHelper.getFloat(tag, "Volume", this.volume);
            this.pitch = NBTHelper.getFloat(tag, "Pitch", this.pitch);
            this.frequency = NBTHelper.getFloat(tag, "Frequency", this.frequency);
            this.onInteract = NBTHelper.getBoolean(tag, "OnInteract", this.onInteract);
        }

        public SoundEmitter(SoundEmitter soundEmitter) {
            this.sound = soundEmitter.sound;
            this.volume = soundEmitter.volume;
            this.pitch = soundEmitter.pitch;
            this.frequency = soundEmitter.frequency;
            this.onInteract = soundEmitter.onInteract;
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.putString("Sound", this.sound.toString());
            tag.putFloat("Volume", this.volume);
            tag.putFloat("Pitch", this.pitch);
            tag.putFloat("Frequency", this.frequency);
            tag.putBoolean("OnInteract", this.onInteract);
            return tag;
        }

        public SoundEvent getSoundEvent() {
            return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(this.sound);
        }
    }

    public static class ParticleEmitter {
        public ResourceLocation particle = ResourceLocation.withDefaultNamespace((String)"smoke");
        public float velocityDirectional = 0.0f;
        public float velocityRandom = 0.1f;
        public float amount = 0.5f;
        public boolean onInteract = false;

        public ParticleEmitter() {
        }

        public ParticleEmitter(CompoundTag tag) {
            this.particle = NBTHelper.getResourceLocation(tag, "Particle", this.particle);
            this.velocityDirectional = NBTHelper.getFloat(tag, "VelocityDirectional", this.velocityDirectional);
            this.velocityRandom = NBTHelper.getFloat(tag, "VelocityRandom", this.velocityRandom);
            this.amount = NBTHelper.getFloat(tag, "Amount", this.amount);
            this.onInteract = NBTHelper.getBoolean(tag, "OnInteract", this.onInteract);
        }

        public ParticleEmitter(ParticleEmitter particleEmitter) {
            this.particle = particleEmitter.particle;
            this.velocityDirectional = particleEmitter.velocityDirectional;
            this.velocityRandom = particleEmitter.velocityRandom;
            this.amount = particleEmitter.amount;
            this.onInteract = particleEmitter.onInteract;
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.putString("Particle", this.particle.toString());
            tag.putFloat("VelocityDirectional", this.velocityDirectional);
            tag.putFloat("VelocityRandom", this.velocityRandom);
            tag.putFloat("Amount", this.amount);
            tag.putBoolean("OnInteract", this.onInteract);
            return tag;
        }

        public SimpleParticleType getParticle() {
            Object object = BuiltInRegistries.PARTICLE_TYPE.get(this.particle);
            if (object instanceof SimpleParticleType) {
                SimpleParticleType simpleParticleType = (SimpleParticleType)object;
                return simpleParticleType;
            }
            return null;
        }
    }

    public static interface ParticleConsumer {
        public void addParticle(SimpleParticleType var1, float var2, float var3, float var4, float var5, float var6, float var7);
    }

    public static class PlayerPose {
        public Pose pose = Pose.SITTING;

        public PlayerPose() {
        }

        public PlayerPose(CompoundTag tag) {
            this.pose = NBTHelper.getEnum(tag, Pose.class, "Pose", this.pose);
        }

        public PlayerPose(PlayerPose playerPose) {
            this.pose = playerPose.pose;
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.putString("Pose", this.pose.name());
            return tag;
        }
    }

    public record PoseOffset(Vector3f offset, Pose pose, float rotation) {
    }

    public static class Sprite {
        public ResourceLocation sprite = ResourceLocation.withDefaultNamespace((String)"block/soul_fire_1");
        public int rotation = 0;
        public float size = 1.0f;
        public boolean tiled = false;
        public boolean item = false;
        public boolean align = false;

        public Sprite() {
        }

        public Sprite(CompoundTag tag) {
            this.sprite = NBTHelper.getResourceLocation(tag, "Sprite", this.sprite);
            this.rotation = NBTHelper.getInt(tag, "Rotation", this.rotation);
            this.size = NBTHelper.getFloat(tag, "Size", this.size);
            this.tiled = NBTHelper.getBoolean(tag, "Tiled", this.tiled);
            this.item = NBTHelper.getBoolean(tag, "Item", this.item);
            this.align = NBTHelper.getBoolean(tag, "Align", this.align);
        }

        public Sprite(Sprite sprite) {
            this.sprite = sprite.sprite;
            this.rotation = sprite.rotation;
            this.size = sprite.size;
            this.tiled = sprite.tiled;
            this.item = sprite.item;
            this.align = sprite.align;
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.putString("Sprite", this.sprite.toString());
            tag.putInt("Rotation", this.rotation);
            tag.putFloat("Size", this.size);
            tag.putBoolean("Tiled", this.tiled);
            tag.putBoolean("Item", this.item);
            tag.putBoolean("Align", this.align);
            return tag;
        }
    }

    public static class LightMaterialEffect {
        public float roundness = 0.0f;
        public float brightness = 0.0f;
        public float contrast = 0.0f;
        public float hue = 0.0f;
        public float saturation = 0.0f;
        public float value = 0.0f;

        public LightMaterialEffect() {
        }

        public LightMaterialEffect(LightMaterialEffect lightEffect) {
            this.roundness = lightEffect.roundness;
            this.brightness = lightEffect.brightness;
            this.contrast = lightEffect.contrast;
            this.hue = lightEffect.hue;
            this.saturation = lightEffect.saturation;
            this.value = lightEffect.value;
        }

        public void load(CompoundTag tag) {
            this.roundness = NBTHelper.getFloat(tag, "Roundness", this.roundness);
            this.brightness = NBTHelper.getFloat(tag, "Brightness", this.brightness);
            this.contrast = NBTHelper.getFloat(tag, "Contrast", this.contrast);
            this.hue = NBTHelper.getFloat(tag, "Hue", this.hue);
            this.saturation = NBTHelper.getFloat(tag, "Saturation", this.saturation);
            this.value = NBTHelper.getFloat(tag, "Value", this.value);
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.putFloat("Roundness", this.roundness);
            tag.putFloat("Brightness", this.brightness);
            tag.putFloat("Contrast", this.contrast);
            tag.putFloat("Hue", this.hue);
            tag.putFloat("Saturation", this.saturation);
            tag.putFloat("Value", this.value);
            return tag;
        }
    }

    public static class Material {
        public ResourceLocation source = ResourceLocation.withDefaultNamespace((String)"oak_log");
        public int margin = 4;
        public WrapMode wrap = WrapMode.EXPAND;
        public MaterialAxis axis = MaterialAxis.X;
        public TransparencyType transparency = TransparencyType.SOLID;
        public LightMaterialEffect lightEffect = new LightMaterialEffect();

        public Material() {
        }

        public Material(CompoundTag tag) {
            this.source = NBTHelper.getResourceLocation(tag, "Source", this.source);
            this.margin = NBTHelper.getInt(tag, "Margin", this.margin);
            this.wrap = NBTHelper.getEnum(tag, WrapMode.class, "Wrap", this.wrap);
            this.axis = NBTHelper.getEnum(tag, MaterialAxis.class, "Axis", this.axis);
            this.transparency = NBTHelper.getEnum(tag, TransparencyType.class, "Transparency", this.transparency);
            this.lightEffect.load(tag.getCompound("LightEffect"));
        }

        public Material(Material material) {
            this.source = material.source;
            this.margin = material.margin;
            this.wrap = material.wrap;
            this.axis = material.axis;
            this.transparency = material.transparency;
            this.lightEffect = new LightMaterialEffect(material.lightEffect);
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.putString("Source", this.source.toString());
            tag.putInt("Margin", this.margin);
            tag.putString("Wrap", this.wrap.name());
            tag.putString("Axis", this.axis.name());
            tag.putString("Transparency", this.transparency.name());
            tag.put("LightEffect", (Tag)this.lightEffect.save());
            return tag;
        }
    }

    public static enum MaterialAxis {
        X,
        Y,
        Z;

    }

    public static enum WrapMode {
        EXPAND,
        REPEAT;

    }
}

