/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.model;

import java.util.List;
import net.conczin.immersive_furniture.block.BaseFurnitureBlock;
import net.conczin.immersive_furniture.client.DelayedFurnitureRenderer;
import net.conczin.immersive_furniture.client.model.CompositeBakedModel;
import net.conczin.immersive_furniture.client.model.DynamicAtlas;
import net.conczin.immersive_furniture.client.model.FurnitureModelBaker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FurnitureBakedModelWrapper
implements BakedModel {
    public static BakedModel model = new FurnitureBakedModelWrapper();

    protected static CompositeBakedModel getBakedModel(BlockPos pos, BlockState state) {
        DelayedFurnitureRenderer.Status status = DelayedFurnitureRenderer.INSTANCE.getLoadedStatus(pos);
        if (status.data() != null) {
            int yRot = (int)((Direction)state.getValue((Property)BaseFurnitureBlock.FACING)).getOpposite().toYRot();
            boolean active = (Boolean)state.getValue((Property)BaseFurnitureBlock.ACTIVE);
            return FurnitureModelBaker.getModel(status.data(), status.data().getHash(), DynamicAtlas.BAKED, yRot, active ? 1 : 0, false);
        }
        if (!status.done()) {
            DelayedFurnitureRenderer.INSTANCE.delayRendering(pos);
        }
        return null;
    }

    public List<BakedQuad> getQuads(BlockState blockState, Direction direction, RandomSource randomSource) {
        return List.of();
    }

    public boolean useAmbientOcclusion() {
        return false;
    }

    public boolean isGui3d() {
        return true;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(ResourceLocation.withDefaultNamespace((String)"block/oak_planks"));
    }

    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }
}

