/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui.components;

import java.util.LinkedList;
import java.util.List;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationEditorScreen;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationScreen;
import net.conczin.immersive_furniture.client.gui.components.ListComponent;
import net.conczin.immersive_furniture.client.gui.widgets.LegacyImageButton;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class SoundsComponent
extends ListComponent {
    static final int PAGE_SIZE = 7;
    List<ResourceLocation> allLocations = new LinkedList<ResourceLocation>();
    List<ResourceLocation> locations = new LinkedList<ResourceLocation>();
    List<Button> buttons = new LinkedList<Button>();

    public SoundsComponent(ArtisansWorkstationEditorScreen screen) {
        super(screen);
    }

    @Override
    public void init(int leftPos, int topPos, int width, int height) {
        if (this.screen.selectedElements.isEmpty()) {
            return;
        }
        this.buttons.clear();
        int y = topPos + 23;
        int i = 0;
        while (i < 7) {
            int finalI = i++;
            Button button = Button.builder((Component)Component.literal((String)""), b -> {
                if (finalI >= this.locations.size()) {
                    return;
                }
                this.screen.selectedElements.forEach(e -> {
                    e.soundEmitter.sound = this.locations.get(finalI);
                });
            }).bounds(leftPos + 5, y, width - 29, 18).build();
            this.screen.addRenderableWidget(button);
            this.buttons.add(button);
            this.screen.addRenderableWidget(new LegacyImageButton(leftPos + width - 23, y, 18, 18, 238, 0, 18, ArtisansWorkstationScreen.TEXTURE, 256, 256, b -> {
                if (finalI >= this.locations.size()) {
                    return;
                }
                SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(this.locations.get(finalI));
                if (soundEvent == null) {
                    return;
                }
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)soundEvent, (float)1.0f, (float)1.0f));
            }, (Component)Component.translatable((String)"gui.immersive_furniture.play_sound")));
            y += 19;
        }
        super.init(leftPos, topPos, width, height);
    }

    @Override
    int getPages() {
        return Math.max(0, (this.allLocations.size() - 1) / 7 + 1);
    }

    @Override
    void updateSearch() {
        this.allLocations = BuiltInRegistries.SOUND_EVENT.keySet().stream().filter(p -> Utils.search(this.searchBox.getValue(), p.toString())).sorted(ResourceLocation::compareTo).toList();
        this.page = Math.min(this.page, this.getPages() - 1);
        this.locations = this.allLocations.subList(this.page * 7, Math.min(this.page * 7 + 7, this.allLocations.size()));
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (i < this.locations.size()) {
                ResourceLocation location = this.locations.get(i);
                MutableComponent message = Component.translatableWithFallback((String)("subtitles." + location.getPath()), (String)Utils.capitalize(location));
                this.buttons.get(i).setMessage((Component)message);
                MutableComponent namespaceTooltip = Component.literal((String)Utils.capitalize(location.getNamespace())).withStyle(ChatFormatting.GRAY);
                this.buttons.get(i).setTooltip(Tooltip.create((Component)message.copy().append("\n").append((Component)namespaceTooltip)));
                this.buttons.get((int)i).active = true;
                continue;
            }
            this.buttons.get(i).setMessage((Component)Component.literal((String)""));
            this.buttons.get(i).setTooltip(Tooltip.create((Component)Component.literal((String)"")));
            this.buttons.get((int)i).active = false;
        }
    }
}

