/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui.components;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationEditorScreen;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationLibraryScreen;
import net.conczin.immersive_furniture.client.gui.components.ScreenComponent;
import net.conczin.immersive_furniture.client.gui.widgets.BoundedIntSliderButton;
import net.conczin.immersive_furniture.client.gui.widgets.StateImageButton;
import net.conczin.immersive_furniture.client.model.DynamicAtlas;
import net.conczin.immersive_furniture.client.model.FurnitureModelFactory;
import net.conczin.immersive_furniture.client.model.MaterialRegistry;
import net.conczin.immersive_furniture.client.model.MaterialSource;
import net.conczin.immersive_furniture.client.model.TransparencyManager;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.FurnitureDataManager;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SettingsComponent
extends ScreenComponent {
    static final Component SEARCH_TITLE = Component.translatable((String)"gui.immersive_furniture.name");
    static final Component SEARCH_HINT = Component.translatable((String)"gui.immersive_furniture.name.hint").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
    public static final List<String> TAGS = List.of("living_room", "bed_room", "kitchen", "bath_room", "office", "storage", "outdoor", "communal", "workshop", "miscellaneous");
    private boolean localFileExists;

    public SettingsComponent(ArtisansWorkstationEditorScreen screen) {
        super(screen);
    }

    @Override
    public void init(int leftPos, int topPos, int width, int height) {
        super.init(leftPos, topPos, width, height);
        this.localFileExists = FurnitureDataManager.localFileExists(this.screen.data);
        Font font = this.minecraft.font;
        Objects.requireNonNull(this.minecraft.font);
        EditBox nameBox = new EditBox(font, leftPos + 6, topPos + 6, width - 12, 9 + 3, SEARCH_TITLE);
        nameBox.setMaxLength(50);
        nameBox.setVisible(true);
        nameBox.setValue(this.screen.data.name);
        nameBox.setHint(SEARCH_HINT);
        nameBox.setResponder(s -> {
            this.screen.data.name = s;
            this.localFileExists = FurnitureDataManager.localFileExists(this.screen.data);
        });
        this.screen.addRenderableWidget(nameBox);
        int i = 0;
        int x = leftPos + 6;
        int y = topPos + 22;
        for (String tag : TAGS) {
            this.addToggleButton(x, y, 16, i * 16, 224, "gui.immersive_furniture.tag." + tag.toLowerCase(Locale.ROOT), () -> {
                this.screen.data.tag = tag;
                this.screen.init();
            }).setEnabled(tag.equals(this.screen.data.tag));
            ++i;
            if ((x += 18) <= leftPos + width - 6) continue;
            x = leftPos + 6;
            y += 18;
        }
        BoundedIntSliderButton lightLevelSlider = new BoundedIntSliderButton(leftPos + 6, topPos + 60, width - 12, 20, "gui.immersive_furniture.light_level", this.screen.data.lightLevel, 0, 15);
        lightLevelSlider.setCallback(c -> {
            this.screen.data.lightLevel = c;
        });
        this.screen.addRenderableWidget(lightLevelSlider);
        BoundedIntSliderButton inventorySlider = new BoundedIntSliderButton(leftPos + 6, topPos + 82, width - 12, 20, "gui.immersive_furniture.inventory", this.screen.data.inventorySize, 0, 6);
        inventorySlider.setCallback(c -> {
            this.screen.data.inventorySize = c;
        });
        this.screen.addRenderableWidget(inventorySlider);
        int togglesY = topPos + 106;
        StateImageButton rightClickToggle = this.addToggleButton(leftPos + 6, togglesY, 16, 192, 160, "gui.immersive_furniture.toggle_with_right_click", () -> {
            this.screen.data.toggleWithRightClick = !this.screen.data.toggleWithRightClick;
            this.screen.init();
        });
        rightClickToggle.setEnabled(!this.screen.data.toggleWithRightClick);
        StateImageButton lightToggle = this.addToggleButton(leftPos + 24, togglesY, 16, 208, 160, "gui.immersive_furniture.toggle_light", () -> {
            this.screen.data.toggleLight = !this.screen.data.toggleLight;
            this.screen.init();
        });
        lightToggle.setEnabled(!this.screen.data.toggleLight);
        this.addButton("gui.immersive_furniture.save", b -> {
            this.finish(this.screen.data);
            FurnitureDataManager.saveLocalFile(this.screen.data);
            FurnitureDataManager.deleteLocalFile(ResourceLocation.fromNamespaceAndPath((String)"local", (String)"autosave"));
            ArtisansWorkstationLibraryScreen libraryScreen = new ArtisansWorkstationLibraryScreen();
            libraryScreen.setSelected(FurnitureDataManager.getSafeLocalLocation(this.screen.data));
            libraryScreen.setTab(ArtisansWorkstationLibraryScreen.Tab.LOCAL);
            Minecraft.getInstance().setScreen((Screen)libraryScreen);
        }, leftPos + 6, topPos + 154, width - 12);
    }

    public void render(GuiGraphics graphics) {
        if (this.localFileExists) {
            graphics.drawCenteredString(this.minecraft.font, (Component)Component.translatable((String)"gui.immersive_furniture.overwrite_file"), this.leftPos + this.width + (280 - this.width) / 2, this.topPos + this.height - 16, 0xFFFFFF);
        }
    }

    private void addButton(String message, Button.OnPress onPress, int x, int y, int w) {
        this.screen.addRenderableWidget(Button.builder((Component)Component.translatable((String)message), (Button.OnPress)onPress).bounds(x, y, w, 20).build());
    }

    public void finish(FurnitureData data) {
        TransparencyManager.prepare(data);
        DynamicAtlas.SCRATCH.clear();
        FurnitureModelFactory.getModel(data, DynamicAtlas.SCRATCH);
        data.author = Minecraft.getInstance().getUser().getName();
        if (data.hasDisplayItems()) {
            data.inventorySize = Math.max(1, data.inventorySize);
        }
        data.sources.clear();
        for (FurnitureData.Element element : data.elements) {
            if (element.type != FurnitureData.ElementType.ELEMENT) continue;
            MaterialSource source = MaterialRegistry.INSTANCE.materials.getOrDefault(element.material.source, MaterialSource.DEFAULT);
            for (Direction value : Direction.values()) {
                ResourceLocation location = source.getMaterial(value).sprite().contents().name();
                data.sources.add(location.getNamespace());
                ResourceLocation textureLocation = ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("textures/" + location.getPath() + ".png"));
                Minecraft.getInstance().getResourceManager().getResource(textureLocation).ifPresent(resource -> data.sources.add(Utils.beatifyPackID(resource.sourcePackId())));
            }
        }
        data.sources.remove("vanilla");
        data.sources.remove("minecraft");
        data.sources.remove("mod_resources");
        data.sources.remove("mod resources");
        data.dependencies.clear();
        for (FurnitureData.Element element : data.elements) {
            if (element.type == FurnitureData.ElementType.PARTICLE_EMITTER) {
                data.dependencies.add(element.particleEmitter.particle.getNamespace());
                continue;
            }
            if (element.type == FurnitureData.ElementType.SOUND_EMITTER) {
                data.dependencies.add(element.soundEmitter.sound.getNamespace());
                continue;
            }
            if (element.type != FurnitureData.ElementType.SPRITE) continue;
            data.dependencies.add(element.sprite.sprite.getNamespace());
        }
        data.dependencies.remove("minecraft");
        data.dependencies.remove("mod resources");
    }
}

