/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationEditorScreen;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationScreen;
import net.conczin.immersive_furniture.client.gui.components.ScreenComponent;
import net.conczin.immersive_furniture.client.gui.widgets.BoundedDoubleSlider;
import net.conczin.immersive_furniture.client.gui.widgets.StateImageButton;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.ModelUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;

public class ModelComponent
extends ScreenComponent {
    static final Component SELECT_TITLE = Component.translatable((String)"gui.immersive_furniture.select");
    static final Component POSITION_TITLE = Component.translatable((String)"gui.immersive_furniture.position");
    static final Component SIZE_TITLE = Component.translatable((String)"gui.immersive_furniture.size");
    static final Component ROTATION_TITLE = Component.translatable((String)"gui.immersive_furniture.rotation");
    static final Component MOVE_FURNITURE_TITLE = Component.translatable((String)"gui.immersive_furniture.move_furniture");
    static final Component FURNITURE_DIMENSION_TITLE = Component.translatable((String)"gui.immersive_furniture.furniture_dimension");
    static final Component FIELD_TITLE = Component.literal((String)"");
    private EditBox px;
    private EditBox py;
    private EditBox pz;
    private EditBox sx;
    private EditBox sy;
    private EditBox sz;
    private StateImageButton rx;
    private StateImageButton ry;
    private StateImageButton rz;

    public ModelComponent(ArtisansWorkstationEditorScreen screen) {
        super(screen);
    }

    @Override
    public void init(int leftPos, int topPos, int width, int height) {
        FurnitureData.Element firstElement;
        super.init(leftPos, topPos, width, height);
        this.addButton(leftPos + 6, topPos + height - 22, 16, 64, 192, "gui.immersive_furniture.new_element", () -> {
            FurnitureData.Element element = new FurnitureData.Element();
            this.screen.data.elements.add(element);
            this.screen.selectElement(element, false);
            this.screen.init();
        });
        if (this.screen.selectedElements.isEmpty()) {
            int x = leftPos + 6 + 12;
            int y = topPos + 108;
            int spacing = 24;
            this.addButton(x, y, 16, 96, 160, "gui.immersive_furniture.move_furniture_east", () -> this.moveFurniture(1.0f, 0.0f, 0.0f));
            this.addButton(x, y + 29, 16, 128, 160, "gui.immersive_furniture.move_furniture_west", () -> this.moveFurniture(-1.0f, 0.0f, 0.0f));
            this.addButton(x + spacing, y, 16, 96, 160, "gui.immersive_furniture.move_furniture_up", () -> this.moveFurniture(0.0f, 1.0f, 0.0f));
            this.addButton(x + spacing, y + 29, 16, 128, 160, "gui.immersive_furniture.move_furniture_down", () -> this.moveFurniture(0.0f, -1.0f, 0.0f));
            this.addButton(x + spacing * 2, y, 16, 96, 160, "gui.immersive_furniture.move_furniture_south", () -> this.moveFurniture(0.0f, 0.0f, 1.0f));
            this.addButton(x + spacing * 2, y + 29, 16, 128, 160, "gui.immersive_furniture.move_furniture_north", () -> this.moveFurniture(0.0f, 0.0f, -1.0f));
            int dimY = topPos + 45;
            int maxDimension = 4;
            this.addButton(x, dimY, 16, 96, 160, "", () -> {
                this.screen.data.size.x = Math.min(maxDimension, this.screen.data.size.x + 1);
            });
            this.addButton(x, dimY + 29, 16, 128, 160, "", () -> {
                this.screen.data.size.x = Math.max(1, this.screen.data.size.x - 1);
            });
            this.addButton(x + spacing, dimY, 16, 96, 160, "", () -> {
                this.screen.data.size.y = Math.min(maxDimension, this.screen.data.size.y + 1);
            });
            this.addButton(x + spacing, dimY + 29, 16, 128, 160, "", () -> {
                this.screen.data.size.y = Math.max(1, this.screen.data.size.y - 1);
            });
            this.addButton(x + spacing * 2, dimY, 16, 96, 160, "", () -> {
                this.screen.data.size.z = Math.min(maxDimension, this.screen.data.size.z + 1);
            });
            this.addButton(x + spacing * 2, dimY + 29, 16, 128, 160, "", () -> {
                this.screen.data.size.z = Math.max(1, this.screen.data.size.z - 1);
            });
        }
        if ((firstElement = (FurnitureData.Element)this.screen.getFirstElement().orElse(null)) == null) {
            return;
        }
        this.addButton(leftPos + 24, topPos + height - 22, 16, 80, 192, "gui.immersive_furniture.delete_element", () -> {
            this.screen.data.elements.removeAll(this.screen.selectedElements);
            this.screen.selectedElements.clear();
            this.screen.init();
        });
        this.addButton(leftPos + 42, topPos + height - 22, 16, 160, 192, "gui.immersive_furniture.duplicate_element", this::duplicateElements);
        int u = 208 + (firstElement.mask - 1) * 16;
        this.addToggleButton(leftPos + 78, topPos + height - 22, 16, u, 224, "gui.immersive_furniture.mask." + firstElement.mask, () -> {
            this.screen.selectedElements.forEach(e -> {
                e.mask = e.mask % 3 + 1;
            });
            this.screen.init();
        }).setEnabled(false);
        int y = topPos + 17;
        this.px = this.addNewFloatBox(leftPos + 6, y, 28);
        this.px.setValue(Float.toString(firstElement.from.x));
        this.px.setResponder(b -> this.screen.getFirstElement().ifPresent(currentFirstElement -> {
            float offset = this.parse(this.px.getValue(), currentFirstElement.from.x) - currentFirstElement.from.x;
            if ((double)Math.abs(offset) < 0.001) {
                return;
            }
            currentFirstElement.from.x += offset;
            currentFirstElement.to.x += offset;
            for (FurnitureData.Element element : this.screen.selectedElements) {
                element.from.x = currentFirstElement.from.x;
                element.to.x = currentFirstElement.to.x;
                element.sanityCheck();
            }
        }));
        this.py = this.addNewFloatBox(leftPos + 6 + 30, y, 28);
        this.py.setValue(Float.toString(firstElement.from.y));
        this.py.setResponder(b -> this.screen.getFirstElement().ifPresent(currentFirstElement -> {
            float offset = this.parse(this.py.getValue(), currentFirstElement.from.y) - currentFirstElement.from.y;
            if ((double)Math.abs(offset) < 0.001) {
                return;
            }
            currentFirstElement.from.y += offset;
            currentFirstElement.to.y += offset;
            for (FurnitureData.Element element : this.screen.selectedElements) {
                element.from.y = currentFirstElement.from.y;
                element.to.y = currentFirstElement.to.y;
                element.sanityCheck();
            }
        }));
        this.pz = this.addNewFloatBox(leftPos + 6 + 60, y, 28);
        this.pz.setValue(Float.toString(firstElement.from.z));
        this.pz.setResponder(b -> this.screen.getFirstElement().ifPresent(currentFirstElement -> {
            float offset = this.parse(this.pz.getValue(), currentFirstElement.from.z) - currentFirstElement.from.z;
            if ((double)Math.abs(offset) < 0.001) {
                return;
            }
            currentFirstElement.from.z += offset;
            currentFirstElement.to.z += offset;
            for (FurnitureData.Element element : this.screen.selectedElements) {
                element.from.z = currentFirstElement.from.z;
                element.to.z = currentFirstElement.to.z;
                element.sanityCheck();
            }
        }));
        if (this.isResizable(firstElement)) {
            y = topPos + 45;
            Vector3i size = firstElement.getSize();
            this.sx = this.addNewFloatBox(leftPos + 6, y, 28);
            this.sx.setValue(String.valueOf(size.x));
            this.sx.setResponder(b -> this.screen.getFirstElement().ifPresent(currentFirstElement -> {
                int oldSize = currentFirstElement.getSize().x;
                int newSize = Math.max(0, this.parse(this.sx.getValue(), oldSize));
                if ((double)Math.abs(newSize - oldSize) < 0.001) {
                    return;
                }
                currentFirstElement.from.x -= (float)(newSize - oldSize) / 2.0f;
                currentFirstElement.to.x += (float)(newSize - oldSize) / 2.0f;
                for (FurnitureData.Element element : this.screen.selectedElements) {
                    element.from.x = currentFirstElement.from.x;
                    element.to.x = currentFirstElement.to.x;
                    element.sanityCheck();
                }
            }));
            this.sy = this.addNewFloatBox(leftPos + 6 + 30, y, 28);
            this.sy.setValue(String.valueOf(size.y));
            this.sy.setResponder(b -> this.screen.getFirstElement().ifPresent(currentFirstElement -> {
                int oldSize = currentFirstElement.getSize().y;
                int newSize = Math.max(0, this.parse(this.sy.getValue(), oldSize));
                if ((double)Math.abs(newSize - oldSize) < 0.001) {
                    return;
                }
                currentFirstElement.from.y -= (float)(newSize - oldSize) / 2.0f;
                currentFirstElement.to.y += (float)(newSize - oldSize) / 2.0f;
                for (FurnitureData.Element element : this.screen.selectedElements) {
                    element.from.y = currentFirstElement.from.y;
                    element.to.y = currentFirstElement.to.y;
                    element.sanityCheck();
                }
            }));
            this.sz = this.addNewFloatBox(leftPos + 6 + 60, y, 28);
            this.sz.setValue(String.valueOf(size.z));
            this.sz.setResponder(b -> this.screen.getFirstElement().ifPresent(currentFirstElement -> {
                int oldSize = currentFirstElement.getSize().z;
                int newSize = Math.max(0, this.parse(this.sz.getValue(), oldSize));
                if ((double)Math.abs(newSize - oldSize) < 0.001) {
                    return;
                }
                currentFirstElement.from.z -= (float)(newSize - oldSize) / 2.0f;
                currentFirstElement.to.z += (float)(newSize - oldSize) / 2.0f;
                for (FurnitureData.Element element : this.screen.selectedElements) {
                    element.from.z = currentFirstElement.from.z;
                    element.to.z = currentFirstElement.to.z;
                    element.sanityCheck();
                }
            }));
        }
        y = topPos + 73;
        this.rx = this.addToggleButton(leftPos + 6, y, 16, 16, 192, null, () -> {
            this.screen.selectedElements.forEach(e -> {
                e.axis = Direction.Axis.X;
            });
            this.rx.setEnabled(false);
            this.ry.setEnabled(true);
            this.rz.setEnabled(true);
        });
        this.rx.setEnabled(firstElement.axis != Direction.Axis.X);
        this.ry = this.addToggleButton(leftPos + 24, y, 16, 32, 192, null, () -> {
            this.screen.selectedElements.forEach(e -> {
                e.axis = Direction.Axis.Y;
            });
            this.rx.setEnabled(true);
            this.ry.setEnabled(false);
            this.rz.setEnabled(true);
        });
        this.ry.setEnabled(firstElement.axis != Direction.Axis.Y);
        this.rz = this.addToggleButton(leftPos + 42, y, 16, 48, 192, null, () -> {
            this.screen.selectedElements.forEach(e -> {
                e.axis = Direction.Axis.Z;
            });
            this.rx.setEnabled(true);
            this.ry.setEnabled(true);
            this.rz.setEnabled(false);
        });
        this.rz.setEnabled(firstElement.axis != Direction.Axis.Z);
        this.addButton(leftPos + 62, y + 1, 14, 222, 2, null, () -> this.rotate(22.5f));
        this.addButton(leftPos + 78, y + 1, 14, 206, 2, null, () -> this.rotate(-22.5f));
        for (FurnitureData.ElementType type : FurnitureData.ElementType.values()) {
            this.addToggleButton(leftPos + 6 + type.ordinal() * 18, topPos + 94, 16, 176 + type.ordinal() * 16, 192, "gui.immersive_furniture.element_type." + type.name().toLowerCase(), () -> {
                this.screen.selectedElements.forEach(e -> {
                    e.type = type;
                    e.sanityCheck();
                });
                this.screen.init();
            }).setEnabled(firstElement.type != type);
        }
        if (firstElement.type == FurnitureData.ElementType.PARTICLE_EMITTER) {
            BoundedDoubleSlider directionalVelocitySlider = new BoundedDoubleSlider(leftPos + 6, topPos + 112, (width - 14) / 2, 20, "gui.immersive_furniture.directional_velocity", firstElement.particleEmitter.velocityDirectional, 0.0, 5.0);
            directionalVelocitySlider.setCallback(v -> this.screen.selectedElements.forEach(e -> {
                e.particleEmitter.velocityDirectional = v.floatValue();
            }));
            this.screen.addRenderableWidget(directionalVelocitySlider);
            BoundedDoubleSlider velocityRandomSlider = new BoundedDoubleSlider(leftPos + 8 + (width - 14) / 2, topPos + 112, (width - 14) / 2, 20, "gui.immersive_furniture.random_velocity", firstElement.particleEmitter.velocityRandom, 0.0, 5.0);
            velocityRandomSlider.setCallback(v -> this.screen.selectedElements.forEach(e -> {
                e.particleEmitter.velocityRandom = v.floatValue();
            }));
            this.screen.addRenderableWidget(velocityRandomSlider);
            BoundedDoubleSlider amountSlider = new BoundedDoubleSlider(leftPos + 6, topPos + 134, width - 32, 20, "gui.immersive_furniture.particle_amount", firstElement.particleEmitter.amount, 0.0, 4.0);
            amountSlider.setCallback(v -> this.screen.selectedElements.forEach(e -> {
                e.particleEmitter.amount = v.floatValue();
            }));
            this.screen.addRenderableWidget(amountSlider);
            this.addToggleButton(leftPos + width - 23, topPos + 136, 16, 192, 160, "gui.immersive_furniture.on_interact", () -> {
                this.screen.selectedElements.forEach(e -> {
                    e.particleEmitter.onInteract = !e.particleEmitter.onInteract;
                });
                this.screen.init();
                ClientLevel level = Minecraft.getInstance().level;
                LocalPlayer player = Minecraft.getInstance().player;
                if (level != null && player != null && firstElement.particleEmitter.onInteract) {
                    this.screen.data.emitInteractParticles(player.getOnPos(), null, this.screen.currentState, (Player)player, ArtisansWorkstationScreen.getParticleEngine(this.screen.data)::addParticle, true);
                }
            }).setEnabled(!firstElement.particleEmitter.onInteract);
        } else if (firstElement.type == FurnitureData.ElementType.SOUND_EMITTER) {
            BoundedDoubleSlider volumeSlider = new BoundedDoubleSlider(leftPos + 6, topPos + 112, (width - 14) / 2, 20, "gui.immersive_furniture.volume", firstElement.soundEmitter.volume, 0.0, 2.0);
            volumeSlider.setCallback(v -> this.screen.selectedElements.forEach(e -> {
                e.soundEmitter.volume = v.floatValue();
            }));
            this.screen.addRenderableWidget(volumeSlider);
            BoundedDoubleSlider velocityRandomSlider = new BoundedDoubleSlider(leftPos + 8 + (width - 14) / 2, topPos + 112, (width - 14) / 2, 20, "gui.immersive_furniture.pitch", firstElement.soundEmitter.pitch, 0.5, 2.0);
            velocityRandomSlider.setCallback(v -> this.screen.selectedElements.forEach(e -> {
                e.soundEmitter.pitch = v.floatValue();
            }));
            this.screen.addRenderableWidget(velocityRandomSlider);
            if (!firstElement.soundEmitter.onInteract) {
                BoundedDoubleSlider frequencySlider = new BoundedDoubleSlider(leftPos + 6, topPos + 134, width - 32, 20, "gui.immersive_furniture.frequency", firstElement.soundEmitter.frequency, 0.0, 1.0);
                frequencySlider.setCallback(v -> this.screen.selectedElements.forEach(e -> {
                    e.soundEmitter.frequency = v.floatValue();
                }));
                this.screen.addRenderableWidget(frequencySlider);
            }
            this.addToggleButton(leftPos + width - 23, topPos + 136, 16, 192, 160, "gui.immersive_furniture.on_interact", () -> {
                this.screen.selectedElements.forEach(e -> {
                    e.soundEmitter.onInteract = !e.soundEmitter.onInteract;
                    e.soundEmitter.frequency = e.soundEmitter.onInteract ? 0.0f : 0.1f;
                });
                this.screen.init();
                ClientLevel level = Minecraft.getInstance().level;
                LocalPlayer player = Minecraft.getInstance().player;
                if (level != null && player != null && firstElement.soundEmitter.onInteract) {
                    this.screen.data.playInteractSound((Level)level, player.getOnPos(), this.screen.currentState, (Player)player);
                }
            }).setEnabled(!firstElement.soundEmitter.onInteract);
        } else if (firstElement.type == FurnitureData.ElementType.PLAYER_POSE) {
            List<Pose> poses = List.of(Pose.SITTING, Pose.SLEEPING);
            for (int i = 0; i < poses.size(); ++i) {
                Pose pose = poses.get(i);
                this.addToggleButton(leftPos + 6 + i * 18, topPos + 114, 16, 160 + i * 16, 160, "gui.immersive_furniture.player_pose." + pose.name().toLowerCase(), () -> {
                    this.screen.selectedElements.forEach(e -> {
                        e.playerPose.pose = pose;
                        e.sanityCheck();
                    });
                    this.screen.init();
                }).setEnabled(firstElement.playerPose.pose != pose);
            }
        } else if (firstElement.type == FurnitureData.ElementType.SPRITE) {
            for (int i = 0; i < 360; i += 90) {
                int rotation = i;
                this.addToggleButton(leftPos + 6 + i / 90 * 18, topPos + 114, 16, 96 + i / 90 * 16, 160, "gui.immersive_furniture.rotation." + i, () -> {
                    this.screen.selectedElements.forEach(e -> {
                        e.sprite.rotation = rotation;
                    });
                    this.screen.init();
                }).setEnabled(firstElement.sprite.rotation != rotation);
            }
            this.addButton(leftPos + 6, topPos + 132, 16, 112, 192, "gui.immersive_furniture.decrease_size", () -> {
                this.screen.selectedElements.forEach(e -> {
                    e.sprite.size = Math.max(0.25f, e.sprite.size / 2.0f);
                    e.sanityCheck();
                });
                this.screen.init();
            });
            this.addButton(leftPos + 24, topPos + 132, 16, 96, 192, "gui.immersive_furniture.increase_size", () -> {
                this.screen.selectedElements.forEach(e -> {
                    e.sprite.size = Math.min(2.0f, e.sprite.size * 2.0f);
                    e.sanityCheck();
                });
                this.screen.init();
            });
            if (firstElement.sprite.item) {
                this.addToggleButton(leftPos + 78, topPos + 114, 16, 240, 160, "gui.immersive_furniture.align", () -> {
                    this.screen.selectedElements.forEach(e -> {
                        e.sprite.align = !e.sprite.align;
                        e.sanityCheck();
                    });
                    this.screen.init();
                }).setEnabled(!firstElement.sprite.align);
            }
            this.addToggleButton(leftPos + 60, topPos + 132, 16, 0, 160, "gui.immersive_furniture.item", () -> {
                this.screen.selectedElements.forEach(e -> {
                    e.sprite.item = !e.sprite.item;
                    e.sanityCheck();
                });
                this.screen.init();
            }).setEnabled(!firstElement.sprite.item);
            this.addToggleButton(leftPos + 78, topPos + 132, 16, 144, 192, "gui.immersive_furniture.tiled", () -> {
                this.screen.selectedElements.forEach(e -> {
                    e.sprite.tiled = !e.sprite.tiled;
                    e.sanityCheck();
                });
                this.screen.init();
            }).setEnabled(!firstElement.sprite.tiled);
        }
    }

    private void rotate(float rotation) {
        if (this.screen.selectedElements.size() > 1) {
            Vector3f center = new Vector3f();
            this.screen.selectedElements.stream().map(FurnitureData.Element::getCenter).forEach(arg_0 -> ((Vector3f)center).add(arg_0));
            center.div((float)this.screen.selectedElements.size());
            for (FurnitureData.Element element : this.screen.selectedElements) {
                Vector3f offset = element.getCenter().sub((Vector3fc)center);
                Vector3f newOffset = ModelUtils.rotate(new Vector3f((Vector3fc)offset), element.axis, rotation);
                newOffset.sub((Vector3fc)offset);
                element.move((float)Math.round(newOffset.x * 4.0f) / 4.0f, (float)Math.round(newOffset.y * 4.0f) / 4.0f, (float)Math.round(newOffset.z * 4.0f) / 4.0f);
            }
        }
        for (FurnitureData.Element element : this.screen.selectedElements) {
            element.rotation = (element.rotation + rotation) % 360.0f;
        }
    }

    public void duplicateElements() {
        ArrayList<FurnitureData.Element> duplicatedElements = new ArrayList<FurnitureData.Element>(this.screen.selectedElements);
        if (duplicatedElements.isEmpty()) {
            return;
        }
        this.screen.selectedElements.clear();
        for (FurnitureData.Element element : duplicatedElements) {
            FurnitureData.Element newElement = new FurnitureData.Element(element);
            this.screen.data.elements.add(newElement);
            this.screen.selectedElements.add(newElement);
        }
        this.screen.init();
    }

    private boolean isResizable(FurnitureData.Element element) {
        return (element.type != FurnitureData.ElementType.SPRITE || element.sprite.tiled) && element.type != FurnitureData.ElementType.PLAYER_POSE;
    }

    private void moveFurniture(float xOffset, float yOffset, float zOffset) {
        for (FurnitureData.Element element : this.screen.data.elements) {
            element.from.x += xOffset;
            element.to.x += xOffset;
            element.from.y += yOffset;
            element.to.y += yOffset;
            element.from.z += zOffset;
            element.to.z += zOffset;
            element.sanityCheck();
        }
    }

    public void update() {
        FurnitureData.Element firstElement = this.screen.getFirstElement().orElse(null);
        if (firstElement == null) {
            return;
        }
        this.px.setValue(Float.toString(firstElement.from.x));
        this.py.setValue(Float.toString(firstElement.from.y));
        this.pz.setValue(Float.toString(firstElement.from.z));
        if (this.sx != null) {
            Vector3i size = firstElement.getSize();
            this.sx.setValue(String.valueOf(size.x));
            this.sy.setValue(String.valueOf(size.y));
            this.sz.setValue(String.valueOf(size.z));
        }
        if (this.rx != null) {
            this.rx.setEnabled(firstElement.axis == Direction.Axis.X);
            this.ry.setEnabled(firstElement.axis == Direction.Axis.Y);
            this.rz.setEnabled(firstElement.axis == Direction.Axis.Z);
        }
    }

    private EditBox addNewFloatBox(int x, int y, int width) {
        Font font = this.minecraft.font;
        Objects.requireNonNull(this.minecraft.font);
        EditBox searchBox = new EditBox(font, x, y, width, 9 + 3, FIELD_TITLE);
        searchBox.setMaxLength(8);
        this.screen.addRenderableWidget(searchBox);
        return searchBox;
    }

    public float parse(String value, float defaultValue) {
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public int parse(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void render(GuiGraphics graphics) {
        FurnitureData.Element firstElement = this.screen.getFirstElement().orElse(null);
        if (firstElement == null) {
            graphics.drawString(this.minecraft.font, SELECT_TITLE, this.leftPos + 6, this.topPos + 6, 0xFFFFFF);
            int x = this.leftPos + 6 + 12;
            int y = this.topPos + 108;
            int spacing = 24;
            int dimY = this.topPos + 45;
            graphics.drawCenteredString(this.minecraft.font, FURNITURE_DIMENSION_TITLE, this.leftPos + 50, dimY - 12, 0xFFFFFF);
            graphics.drawCenteredString(this.minecraft.font, "X: " + this.screen.data.size.x, x + 8, dimY + 19, 0xFFFFFF);
            graphics.drawCenteredString(this.minecraft.font, "Y: " + this.screen.data.size.y, x + 8 + spacing, dimY + 19, 0xFFFFFF);
            graphics.drawCenteredString(this.minecraft.font, "Z: " + this.screen.data.size.z, x + 8 + spacing * 2, dimY + 19, 0xFFFFFF);
            graphics.drawCenteredString(this.minecraft.font, MOVE_FURNITURE_TITLE, this.leftPos + 50, y - 12, 0xFFFFFF);
            graphics.drawString(this.minecraft.font, "X", x + 5, y + 19, 0xFFFFFF);
            graphics.drawString(this.minecraft.font, "Y", x + 5 + spacing, y + 19, 0xFFFFFF);
            graphics.drawString(this.minecraft.font, "Z", x + 5 + spacing * 2, y + 19, 0xFFFFFF);
            this.renderSmoothOutline(graphics, this.leftPos + 4, dimY - 15, this.width - 8, 62, 0x44000000);
            this.renderSmoothOutline(graphics, this.leftPos + 4, y - 15, this.width - 8, 62, 0x44000000);
        } else {
            graphics.drawString(this.minecraft.font, POSITION_TITLE, this.leftPos + 6, this.topPos + 6, 0xFFFFFF);
            if (this.isResizable(firstElement)) {
                graphics.drawString(this.minecraft.font, SIZE_TITLE, this.leftPos + 6, this.topPos + 34, 0xFFFFFF);
            }
            if (firstElement.type != FurnitureData.ElementType.PLAYER_POSE) {
                graphics.drawString(this.minecraft.font, ROTATION_TITLE, this.leftPos + 6, this.topPos + 62, 0xFFFFFF);
            }
            this.renderSmoothOutline(graphics, this.leftPos + 4, this.topPos + 4, this.width - 8, 87, 0x44000000);
            this.renderSmoothOutline(graphics, this.leftPos + 4, this.topPos + 92, this.width - 8, this.height - 117, 0x44000000);
        }
        this.renderSmoothOutline(graphics, this.leftPos + 4, this.topPos + 156, this.width - 8, 20, 0x44000000);
    }

    public void renderSmoothOutline(GuiGraphics graphics, int x, int y, int width, int height, int color) {
        graphics.fill(x + 1, y, x + width - 1, y + 1, color);
        graphics.fill(x + 1, y + height - 1, x + width - 1, y + height, color);
        graphics.fill(x, y + 1, x + 1, y + height - 1, color);
        graphics.fill(x + width - 1, y + 1, x + width, y + height - 1, color);
    }
}

