/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui.components;

import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationEditorScreen;
import net.conczin.immersive_furniture.client.gui.components.ScreenComponent;
import net.conczin.immersive_furniture.client.gui.widgets.BoundedIntSliderButton;
import net.conczin.immersive_furniture.client.gui.widgets.HSVColorPicker;
import net.conczin.immersive_furniture.data.FurnitureData;

public class EffectsComponent
extends ScreenComponent {
    public EffectsComponent(ArtisansWorkstationEditorScreen screen) {
        super(screen);
    }

    @Override
    public void init(int leftPos, int topPos, int width, int height) {
        super.init(leftPos, topPos, width, height);
        FurnitureData.Element firstElement = this.screen.getFirstElement().orElse(null);
        if (firstElement == null) {
            return;
        }
        int y = topPos + 6;
        y = this.initLightGUI(this.screen, leftPos, y, width);
        if (firstElement.type == FurnitureData.ElementType.SPRITE) {
            HSVColorPicker colorSelector = new HSVColorPicker(leftPos + 6, y, width - 12, 60, firstElement.color, c -> this.screen.selectedElements.forEach(e -> {
                e.color = c;
            }));
            colorSelector.getWidgets().forEach(this.screen::addRenderableWidget);
            y += 66;
        }
        BoundedIntSliderButton emissionSlider = new BoundedIntSliderButton(leftPos + 6, y, width - 12, 20, "gui.immersive_furniture.emission", firstElement.emission, 0, 15);
        emissionSlider.setCallback(i -> this.screen.selectedElements.forEach(e -> {
            e.emission = i;
        }));
        this.screen.addRenderableWidget(emissionSlider);
    }

    public int initLightGUI(ArtisansWorkstationEditorScreen screen, int x, int y, int width) {
        FurnitureData.Element firstElement = screen.getFirstElement().orElse(null);
        if (firstElement == null) {
            return y;
        }
        if (firstElement.type != FurnitureData.ElementType.ELEMENT) {
            return y;
        }
        BoundedIntSliderButton lightLevelSlider = new BoundedIntSliderButton(x + 6, y, width - 12, 20, "gui.immersive_furniture.roundness", (int)firstElement.material.lightEffect.roundness, -100, 100);
        lightLevelSlider.setCallback(i -> screen.selectedElements.forEach(e -> {
            e.material.lightEffect.roundness = i.intValue();
        }));
        screen.addRenderableWidget(lightLevelSlider);
        BoundedIntSliderButton brightnessSlider = new BoundedIntSliderButton(x + 6, y += 22, width - 12, 20, "gui.immersive_furniture.brightness", (int)firstElement.material.lightEffect.brightness, -100, 100);
        brightnessSlider.setCallback(i -> screen.selectedElements.forEach(e -> {
            e.material.lightEffect.brightness = i.intValue();
        }));
        screen.addRenderableWidget(brightnessSlider);
        BoundedIntSliderButton contrastSlider = new BoundedIntSliderButton(x + 6, y += 22, width - 12, 20, "gui.immersive_furniture.contrast", (int)firstElement.material.lightEffect.contrast, -100, 100);
        contrastSlider.setCallback(i -> screen.selectedElements.forEach(e -> {
            e.material.lightEffect.contrast = i.intValue();
        }));
        screen.addRenderableWidget(contrastSlider);
        BoundedIntSliderButton hueSlider = new BoundedIntSliderButton(x + 6, y += 22, width - 12, 20, "gui.immersive_furniture.hue", (int)firstElement.material.lightEffect.hue, -100, 100);
        hueSlider.setCallback(i -> screen.selectedElements.forEach(e -> {
            e.material.lightEffect.hue = i.intValue();
        }));
        screen.addRenderableWidget(hueSlider);
        BoundedIntSliderButton saturationSlider = new BoundedIntSliderButton(x + 6, y += 22, width - 12, 20, "gui.immersive_furniture.saturation", (int)firstElement.material.lightEffect.saturation, -100, 100);
        saturationSlider.setCallback(i -> screen.selectedElements.forEach(e -> {
            e.material.lightEffect.saturation = i.intValue();
        }));
        screen.addRenderableWidget(saturationSlider);
        BoundedIntSliderButton valueSlider = new BoundedIntSliderButton(x + 6, y += 22, width - 12, 20, "gui.immersive_furniture.value", (int)firstElement.material.lightEffect.value, -100, 100);
        valueSlider.setCallback(i -> screen.selectedElements.forEach(e -> {
            e.material.lightEffect.value = i.intValue();
        }));
        screen.addRenderableWidget(valueSlider);
        return y += 22;
    }
}

