/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.block.BaseFurnitureBlock;
import net.conczin.immersive_furniture.client.model.DynamicAtlas;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class DelayedFurnitureRenderer {
    public static final DelayedFurnitureRenderer INSTANCE = new DelayedFurnitureRenderer();
    private boolean quickCheck = false;
    private final Map<Long, Integer> attempts = new ConcurrentHashMap<Long, Integer>();
    private final Map<Long, Function<BlockPos, Status>> delayedRendering = new ConcurrentHashMap<Long, Function<BlockPos, Status>>();

    public void delayRendering(BlockPos pos) {
        this.delayedRendering.put(pos.asLong(), this::getLoadedStatus);
        this.quickCheck = true;
    }

    public void tick() {
        if (DynamicAtlas.SCRATCH.isFull() || DynamicAtlas.SCRATCH.getUsage() > 0.9f) {
            DynamicAtlas.SCRATCH.clear();
        }
        if (DynamicAtlas.ENTITY.isFull() || DynamicAtlas.ENTITY.getUsage() > 0.9f) {
            DynamicAtlas.ENTITY.clear();
        }
        Minecraft client = Minecraft.getInstance();
        if (client.level != null && (client.level.getDayTime() % 20L == 0L || this.quickCheck) && !this.delayedRendering.isEmpty()) {
            this.quickCheck = false;
            Iterator<Map.Entry<Long, Function<BlockPos, Status>>> it = this.delayedRendering.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, Function<BlockPos, Status>> entry = it.next();
                BlockPos pos = BlockPos.of((long)entry.getKey());
                Status status = entry.getValue().apply(pos);
                int a = this.attempts.getOrDefault(entry.getKey(), 0);
                ++Common.delayedRendersChecks;
                if (status.data() != null) {
                    ++Common.delayedRenders;
                    client.levelRenderer.setSectionDirty(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getY()), SectionPos.blockToSectionCoord((int)pos.getZ()));
                }
                if (status.done() || a >= 10) {
                    it.remove();
                    continue;
                }
                this.attempts.put(entry.getKey(), a + 1);
            }
        }
    }

    public void clear() {
        this.attempts.clear();
        this.delayedRendering.clear();
    }

    public Status getLoadedStatus(BlockPos pos) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return new Status(true, null);
        }
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof BaseFurnitureBlock) {
            BaseFurnitureBlock furnitureBlock = (BaseFurnitureBlock)block;
            FurnitureData data = furnitureBlock.getData(state, (BlockGetter)level, pos);
            return new Status(data != null, data);
        }
        return new Status(true, null);
    }

    public record Status(boolean done, FurnitureData data) {
    }
}

