/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.block.entity;

import net.conczin.immersive_furniture.block.entity.BlockEntityTypes;
import net.conczin.immersive_furniture.config.Config;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.FurnitureDataManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FurnitureBlockEntity
extends BlockEntity
implements Container,
MenuProvider {
    public static final String FURNITURE = "Furniture";
    public static final String FURNITURE_HASH = "FurnitureHash";
    private String hash;
    private FurnitureData data;
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)81, (Object)ItemStack.EMPTY);

    public FurnitureBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntityTypes.FURNITURE, pos, blockState);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items.clear();
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        if (tag.contains(FURNITURE)) {
            this.data = new FurnitureData(tag.getCompound(FURNITURE));
        } else if (tag.contains(FURNITURE_HASH)) {
            this.hash = tag.getString(FURNITURE_HASH);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        if (this.data != null) {
            if (Config.getInstance().saveAsHash) {
                FurnitureDataManager.saveHashData(this.data);
                tag.putString(FURNITURE_HASH, this.data.getHash());
            } else {
                tag.put(FURNITURE, (Tag)this.data.toTag());
            }
        } else if (this.hash != null) {
            tag.putString(FURNITURE_HASH, this.hash);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public FurnitureData getData() {
        if (this.hash != null) {
            this.data = this.level != null && this.level.isClientSide ? FurnitureDataManager.getCachedData(this.hash) : FurnitureDataManager.getData(this.hash);
            if (this.data != null) {
                this.hash = null;
            }
        }
        return this.data;
    }

    public int getContainerSize() {
        FurnitureData furnitureData = this.getData();
        if (furnitureData == null) {
            return 0;
        }
        return furnitureData.inventorySize * 9;
    }

    public void clearContent() {
        this.getItems().clear();
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.getItems()) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    public void setChanged() {
        FurnitureData data;
        super.setChanged();
        if (this.level != null && (data = this.getData()) != null && data.hasDisplayItems()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public ItemStack removeItem(int slot, int amount) {
        return ContainerHelper.removeItem(this.getItems(), (int)slot, (int)amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.getItems(), (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public Component getDisplayName() {
        FurnitureData d = this.getData();
        return d == null ? Component.translatable((String)"gui.immersive_furniture.furniture") : Component.literal((String)d.name);
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        FurnitureData data = this.getData();
        if (data == null) {
            return null;
        }
        int rows = data.inventorySize;
        if (rows == 0) {
            return null;
        }
        MenuType menuType = switch (rows) {
            case 6 -> MenuType.GENERIC_9x6;
            case 5 -> MenuType.GENERIC_9x5;
            case 4 -> MenuType.GENERIC_9x4;
            case 3 -> MenuType.GENERIC_9x3;
            case 2 -> MenuType.GENERIC_9x2;
            default -> MenuType.GENERIC_9x1;
        };
        return new ChestMenu(menuType, containerId, inventory, (Container)this, rows);
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.playSound(SoundEvents.BARREL_OPEN);
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.playSound(SoundEvents.BARREL_CLOSE);
        }
    }

    void playSound(SoundEvent sound) {
        if (this.level == null) {
            return;
        }
        double d = (double)this.worldPosition.getX() + 0.5;
        double e = (double)this.worldPosition.getY() + 0.5;
        double f = (double)this.worldPosition.getZ() + 0.5;
        this.level.playSound(null, d, e, f, sound, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public void setData(FurnitureData data) {
        this.data = data;
    }
}

