/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.block;

import net.conczin.immersive_furniture.block.BaseFurnitureBlock;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FurnitureProxyBlock
extends Block {
    public static final IntegerProperty OFFSET_X = IntegerProperty.create((String)"offset_x", (int)0, (int)3);
    public static final IntegerProperty OFFSET_Y = IntegerProperty.create((String)"offset_y", (int)0, (int)3);
    public static final IntegerProperty OFFSET_Z = IntegerProperty.create((String)"offset_z", (int)0, (int)3);
    public static final DirectionProperty FACING = BaseFurnitureBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BaseFurnitureBlock.WATERLOGGED;

    public FurnitureProxyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)OFFSET_X, (Comparable)Integer.valueOf(0))).setValue((Property)OFFSET_Y, (Comparable)Integer.valueOf(0))).setValue((Property)OFFSET_Z, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{OFFSET_X, OFFSET_Y, OFFSET_Z, FACING, WATERLOGGED});
    }

    public BlockPos getBasePos(BlockState state, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        int offsetX = (Integer)state.getValue((Property)OFFSET_X);
        int offsetY = (Integer)state.getValue((Property)OFFSET_Y);
        int offsetZ = (Integer)state.getValue((Property)OFFSET_Z);
        return BaseFurnitureBlock.getProxyPosition(pos, direction, -offsetX, -offsetY, -offsetZ);
    }

    @Nullable
    protected BlockState getLoadedBlockState(LevelReader level, BlockPos pos) {
        ChunkAccess chunk = level.getChunk(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()), ChunkStatus.FULL, false);
        if (chunk == null) {
            return null;
        }
        return chunk.getBlockState(pos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        VoxelShape shape;
        BaseFurnitureBlock baseBlock;
        FurnitureData data;
        Block block;
        BlockPos basePos;
        LevelReader level;
        BlockState baseState;
        if (blockGetter instanceof LevelReader && (baseState = this.getLoadedBlockState(level = (LevelReader)blockGetter, basePos = this.getBasePos(state, pos))) != null && (block = baseState.getBlock()) instanceof BaseFurnitureBlock && (data = (baseBlock = (BaseFurnitureBlock)block).getData(baseState, (BlockGetter)level, basePos)) != null && (shape = data.getShapeLazy((Direction)state.getValue((Property)FACING), (Boolean)baseState.getValue((Property)BaseFurnitureBlock.ACTIVE) != false ? 1 : 0, (Integer)state.getValue((Property)OFFSET_X), (Integer)state.getValue((Property)OFFSET_Y), (Integer)state.getValue((Property)OFFSET_Z))) != null) {
            return shape;
        }
        return Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    }

    protected int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return 0;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockPos basePos = this.getBasePos(state, pos);
        BlockState baseState = this.getLoadedBlockState((LevelReader)level, basePos);
        if (baseState != null) {
            BlockHitResult adjustedHit = new BlockHitResult(hit.getLocation(), hit.getDirection(), basePos, hit.isInside());
            baseState.useWithoutItem(level, player, adjustedHit);
        }
        return InteractionResult.PASS;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        Block block;
        BlockPos basePos;
        BlockState baseState;
        if (!level.isClientSide && (baseState = this.getLoadedBlockState((LevelReader)level, basePos = this.getBasePos(state, pos))) != null && (block = baseState.getBlock()) instanceof BaseFurnitureBlock) {
            BaseFurnitureBlock furnitureBlock = (BaseFurnitureBlock)block;
            furnitureBlock.playerWillDestroy(level, basePos, baseState, player);
            level.destroyBlock(basePos, !player.isCreative());
        }
        super.playerWillDestroy(level, pos, state, player);
        return state;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockPos basePos = this.getBasePos(state, currentPos);
        BlockState baseState = this.getLoadedBlockState((LevelReader)level, basePos);
        if (baseState != null && !(baseState.getBlock() instanceof BaseFurnitureBlock)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        Block block;
        BlockPos basePos = this.getBasePos(state, pos);
        BlockState baseState = this.getLoadedBlockState(level, basePos);
        if (baseState != null && (block = baseState.getBlock()) instanceof BaseFurnitureBlock) {
            BaseFurnitureBlock baseBlock = (BaseFurnitureBlock)block;
            return baseBlock.getCloneItemStack(level, basePos, baseState);
        }
        return ItemStack.EMPTY;
    }
}

