/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.block;

import net.conczin.immersive_furniture.block.BaseFurnitureBlock;
import net.conczin.immersive_furniture.block.entity.FurnitureBlockEntity;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.item.FurnitureItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class EntityFurnitureBlock
extends BaseFurnitureBlock
implements EntityBlock {
    public static final IntegerProperty LIGHT = IntegerProperty.create((String)"light", (int)0, (int)15);

    public EntityFurnitureBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)LIGHT, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        FurnitureBlockEntity blockEntity;
        BlockEntity blockEntity2;
        if (!player.isCrouching() && (blockEntity2 = level.getBlockEntity(pos)) instanceof FurnitureBlockEntity && (blockEntity = (FurnitureBlockEntity)blockEntity2).getContainerSize() > 0) {
            player.openMenu((MenuProvider)blockEntity);
            return InteractionResult.CONSUME;
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockPos = context.getClickedPos();
        Level levelAccessor = context.getLevel();
        boolean waterlogged = levelAccessor.getFluidState(blockPos).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIGHT, WATERLOGGED, FACING, ACTIVE});
    }

    @Override
    public FurnitureData getData(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FurnitureBlockEntity) {
            FurnitureBlockEntity blockEntity2 = (FurnitureBlockEntity)blockEntity;
            return blockEntity2.getData();
        }
        return null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FurnitureBlockEntity(pos, state);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FurnitureBlockEntity) {
            Containers.dropContents((Level)level, (BlockPos)pos, ((FurnitureBlockEntity)blockEntity).getItems());
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Override
    public BlockState toggleLight(FurnitureData data, BlockState state, Level level, BlockPos pos) {
        return (BlockState)state.setValue((Property)LIGHT, (Comparable)Integer.valueOf(data.toggleLight && (Boolean)state.getValue((Property)ACTIVE) != false ? 0 : data.lightLevel));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof FurnitureBlockEntity) {
            FurnitureBlockEntity furnitureBlockEntity = (FurnitureBlockEntity)blockEntity;
            furnitureBlockEntity.setData(FurnitureItem.getData(stack));
        }
    }
}

