/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.block;

import java.util.List;
import net.conczin.immersive_furniture.InteractionManager;
import net.conczin.immersive_furniture.block.FurnitureProxyBlock;
import net.conczin.immersive_furniture.config.Config;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.entity.SittingEntity;
import net.conczin.immersive_furniture.item.FurnitureItem;
import net.conczin.immersive_furniture.item.Items;
import net.conczin.immersive_furniture.network.Network;
import net.conczin.immersive_furniture.network.s2c.FurnitureInteractMessage;
import net.conczin.immersive_furniture.network.s2c.PoseOffsetMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BaseFurnitureBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public BaseFurnitureBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        FurnitureData data = this.getData(state, (BlockGetter)level, pos);
        if (data != null) {
            Vec3 click = new Vec3(hit.getLocation().x - (double)pos.getX(), hit.getLocation().y - (double)pos.getY(), hit.getLocation().z - (double)pos.getZ());
            FurnitureData.PoseOffset offset = data.getClosestPose(click, (Direction)state.getValue((Property)FACING));
            boolean consume = false;
            if (offset != null) {
                InteractionManager.INSTANCE.addInteraction((Entity)player, pos, offset);
                if (offset.pose() == Pose.SLEEPING) {
                    BaseFurnitureBlock.startSleeping(pos, player, offset);
                } else if (offset.pose() == Pose.SITTING) {
                    BaseFurnitureBlock.startSitting(data, level, pos, (Direction)state.getValue((Property)FACING), player, offset);
                }
                consume = true;
            }
            consume = this.trigger(data, state, level, pos, data.toggleWithRightClick) || consume;
            return consume ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public boolean trigger(FurnitureData data, BlockState state, Level level, BlockPos pos, boolean toggle) {
        boolean consume = false;
        if (toggle) {
            state = (BlockState)state.cycle((Property)ACTIVE);
            state = this.toggleLight(data, state, level, pos);
            level.setBlock(pos, state, data.getUniqueSolidStates().size() > 1 ? 3 : 7);
            consume = true;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (data.hasSounds() || data.hasParticles()) {
                Boolean active = (Boolean)state.getValue((Property)ACTIVE);
                FurnitureInteractMessage message = new FurnitureInteractMessage(pos, active);
                int maxDist = Config.getInstance().maximumInteractDistance;
                serverLevel.getServer().getPlayerList().getPlayers().forEach(p -> {
                    double dist = pos.distToCenterSqr(p.getX(), p.getY(), p.getZ());
                    if (maxDist <= 0 || dist < (double)(maxDist * maxDist)) {
                        Network.sendToPlayer(message, p);
                    }
                });
                consume = true;
            }
        }
        return consume;
    }

    public BlockState toggleLight(FurnitureData data, BlockState state, Level level, BlockPos pos) {
        return state;
    }

    public void onInteract(Level level, BlockState blockState, BlockPos pos, boolean active, Player player) {
        FurnitureData data = this.getData(blockState, (BlockGetter)level, pos);
        if (data != null) {
            Direction facing = (Direction)blockState.getValue((Property)FACING);
            int state = active ? 1 : 0;
            data.playInteractSound(level, pos, state, player);
            data.emitInteractParticles(pos, facing, state, player, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((Level)level).addParticle(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), false);
        }
    }

    private static void startSleeping(BlockPos pos, Player player, FurnitureData.PoseOffset offset) {
        ServerPlayer serverPlayer;
        if (player.level().isClientSide) {
            return;
        }
        if (player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            PoseOffsetMessage message = new PoseOffsetMessage(pos, offset, (Entity)serverPlayer);
            Network.sendToAllPlayers(serverPlayer.serverLevel().getServer(), message);
        }
        player.startSleepInBed(pos).ifLeft(problem -> {
            if (problem.getMessage() != null) {
                player.displayClientMessage(problem.getMessage(), true);
            }
        });
        if (player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            serverPlayer.setRespawnPosition(player.level().dimension(), pos, player.getYRot(), true, true);
        }
    }

    private static void startSitting(FurnitureData data, Level level, BlockPos pos, Direction direction, Player player, FurnitureData.PoseOffset offset) {
        if (!level.isClientSide) {
            Vec3 position = new Vec3((double)((float)pos.getX() + offset.offset().x), (double)((float)pos.getY() + offset.offset().y), (double)((float)pos.getZ() + offset.offset().z));
            SittingEntity sittingEntity = new SittingEntity(level, position, pos, data.size, direction, new Vec3(player.getX(), player.getY(), player.getZ()));
            sittingEntity.setYRot(offset.rotation());
            player.startRiding((Entity)sittingEntity);
            sittingEntity.clampRotation((Entity)player);
            level.addFreshEntity((Entity)sittingEntity);
        }
        player.hasImpulse = true;
    }

    public abstract FurnitureData getData(BlockState var1, BlockGetter var2, BlockPos var3);

    public void animateTick(BlockState blockState, Level level, BlockPos pos, RandomSource random) {
        FurnitureData data = this.getData(blockState, (BlockGetter)level, pos);
        if (data != null) {
            Direction facing = (Direction)blockState.getValue((Property)FACING);
            int state = (Boolean)blockState.getValue((Property)ACTIVE) != false ? 1 : 0;
            data.tick(level, pos, state, facing, random, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((Level)level).addParticle(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), false, false);
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape;
        FurnitureData data = this.getData(state, level, pos);
        if (data != null && (shape = data.getShapeLazy((Direction)state.getValue((Property)FACING), (Boolean)state.getValue((Property)ACTIVE) != false ? 1 : 0, 0, 0, 0)) != null) {
            return shape;
        }
        return Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && fluidState.getType() == Fluids.WATER) {
            level.setBlock(pos, (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            level.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)level));
            return true;
        }
        return false;
    }

    public FluidState getFluidState(BlockState state) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(state);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public Item asItem() {
        return Items.FURNITURE;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        ItemStack itemStack = new ItemStack((ItemLike)this.asItem());
        FurnitureData data = this.getData(state, (BlockGetter)level, pos);
        if (data != null) {
            FurnitureItem.setData(itemStack, data);
        }
        return itemStack;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        return List.of();
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide) {
            FurnitureData data = this.getData(state, (BlockGetter)level, pos);
            if (data != null) {
                Direction facing = (Direction)state.getValue((Property)FACING);
                for (int x = 0; x < data.size.x; ++x) {
                    for (int y = 0; y < data.size.y; ++y) {
                        for (int z = 0; z < data.size.z; ++z) {
                            BlockPos proxyPos;
                            BlockState proxyState;
                            if (x == 0 && y == 0 && z == 0 || !((proxyState = level.getBlockState(proxyPos = BaseFurnitureBlock.getProxyPosition(pos, facing, x, y, z))).getBlock() instanceof FurnitureProxyBlock)) continue;
                            level.removeBlock(proxyPos, false);
                        }
                    }
                }
                AABB aabb = new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + data.size.x), (double)(pos.getY() + data.size.y), (double)(pos.getZ() + data.size.z)).inflate(1.0);
                level.getEntitiesOfClass(SittingEntity.class, aabb).forEach(Entity::ejectPassengers);
            }
            if (!player.isCreative()) {
                ItemStack itemStack = this.getCloneItemStack((LevelReader)level, pos, state);
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)itemStack);
            }
        }
        super.playerWillDestroy(level, pos, state, player);
        return state;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        FurnitureData data;
        boolean flag;
        if (!level.isClientSide && (flag = ((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) != level.hasNeighborSignal(pos) && (data = this.getData(state, (BlockGetter)level, pos)) != null) {
            this.trigger(data, state, level, pos, true);
        }
    }

    public static BlockPos getProxyPosition(BlockPos basePos, Direction facing, int offsetX, int offsetY, int offsetZ) {
        int dx = 0;
        int dz = 0;
        switch (facing) {
            case NORTH: {
                dz = offsetZ;
                dx = offsetX;
                break;
            }
            case SOUTH: {
                dz = -offsetZ;
                dx = -offsetX;
                break;
            }
            case EAST: {
                dx = -offsetZ;
                dz = offsetX;
                break;
            }
            case WEST: {
                dx = offsetZ;
                dz = -offsetX;
                break;
            }
        }
        return basePos.offset(dx, offsetY, dz);
    }
}

