/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat.multistate;

import com.copycatsplus.copycats.CCKeys;
import com.copycatsplus.copycats.compat.AthenaCompat;
import com.copycatsplus.copycats.compat.Mods;
import com.copycatsplus.copycats.foundation.copycat.CopycatExternalContext;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.IStateType;
import com.copycatsplus.copycats.foundation.copycat.StateType;
import com.copycatsplus.copycats.foundation.copycat.model.ScaledBlockAndTintGetter;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.MaterialItemStorage;
import com.copycatsplus.copycats.network.CCPackets;
import com.copycatsplus.copycats.network.FillCopycatPacket;
import com.copycatsplus.copycats.utility.BlockEntityUtils;
import com.copycatsplus.copycats.utility.BlockFaceUtils;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface IMultiStateCopycatBlock
extends ICopycatBlock,
IStateType {
    @Override
    default public StateType stateType() {
        return StateType.MULTI;
    }

    @Override
    @Nullable
    default public IMultiStateCopycatBlockEntity getCopycatBlockEntity(BlockGetter worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity == null) {
            return null;
        }
        if (!(blockEntity instanceof IMultiStateCopycatBlockEntity)) {
            return null;
        }
        IMultiStateCopycatBlockEntity copycatBE = (IMultiStateCopycatBlockEntity)blockEntity;
        return copycatBE;
    }

    public String defaultProperty();

    public Vec3i vectorScale(BlockState var1);

    public Set<String> storageProperties();

    public int getColorIndex(String var1);

    public boolean partExists(BlockState var1, String var2);

    public Vec3i getVectorFromProperty(BlockState var1, String var2);

    public String getPropertyFromInteraction(BlockState var1, BlockGetter var2, Vec3i var3, BlockPos var4, Direction var5, Vec3 var6);

    default public String getPropertyFromInteraction(BlockState state, BlockGetter level, BlockPos pos, Vec3 hitVec, Direction face, boolean targetingSolid) {
        hitVec = targetingSolid ? hitVec.subtract(Vec3.atLowerCornerOf((Vec3i)face.getNormal()).scale(0.05)) : hitVec.add(Vec3.atLowerCornerOf((Vec3i)face.getNormal()).scale(0.05));
        Vec3 unscaledHit = hitVec = hitVec.add((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()));
        Vec3i scale = this.vectorScale(state);
        hitVec = hitVec.multiply((double)scale.getX(), (double)scale.getY(), (double)scale.getZ());
        BlockPos location = new BlockPos((int)hitVec.x(), (int)hitVec.y(), (int)hitVec.z());
        return this.getPropertyFromInteraction(state, level, (Vec3i)location, pos, face, unscaledHit);
    }

    default public String getPropertyFromInteraction(BlockState state, BlockGetter level, BlockPos pos, BlockHitResult hit, boolean targetingSolid) {
        Vec3 hitVec = hit.getLocation();
        return this.getPropertyFromInteraction(state, level, pos, hitVec, hit.getDirection(), targetingSolid);
    }

    default public String getPropertyFromRender(String renderingProperty, BlockState state, BlockGetter level, Vec3i vector, BlockPos blockPos) {
        Vec3i scale = this.vectorScale(state);
        return this.getPropertyFromInteraction(state, level, vector, blockPos, Direction.UP, Vec3.atLowerCornerOf((Vec3i)vector).multiply(1.0 / (double)scale.getX(), 1.0 / (double)scale.getY(), 1.0 / (double)scale.getZ()));
    }

    @Override
    default public InteractionResult toggleCT(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.isShiftKeyDown()) {
            if (!this.canToggleCT(state, (BlockAndTintGetter)level, pos)) {
                return InteractionResult.PASS;
            }
            String property = this.getPropertyFromInteraction(state, (BlockGetter)level, pos, hitResult, true);
            IMultiStateCopycatBlockEntity be = this.getCopycatBlockEntity((BlockGetter)level, pos);
            if (be == null) {
                return InteractionResult.PASS;
            }
            be.setEnableCT(property, !be.getMaterialItemStorage().getMaterialItem(property).enableCT());
            BlockEntityUtils.redraw((BlockEntity)be);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    default public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        IMultiStateCopycatBlockEntity copycatBE = this.getCopycatBlockEntity((BlockGetter)context.getLevel(), context.getClickedPos());
        if (copycatBE == null) {
            return InteractionResult.PASS;
        }
        String property = this.getPropertyFromInteraction(state, (BlockGetter)context.getLevel(), context.getClickedPos(), context.getClickLocation(), context.getClickedFace(), true);
        if (!this.partExists(state, property)) {
            return InteractionResult.PASS;
        }
        MaterialItemStorage.MaterialItem material = copycatBE.getMaterialItemStorage().getMaterialItem(property);
        ItemStack consumedItem = material.consumedItem();
        if (!consumedItem.isEmpty()) {
            for (String prop : copycatBE.getMaterialItemStorage().getAllProperties()) {
                MaterialItemStorage.MaterialItem materialItem;
                if (prop.equals(property) || !(materialItem = copycatBE.getMaterialItemStorage().getMaterialItem(prop)).material().getBlock().equals(material.material().getBlock()) || !materialItem.consumedItem().isEmpty()) continue;
                copycatBE.setConsumedItem(prop, consumedItem);
                consumedItem = ItemStack.EMPTY;
                break;
            }
        }
        if (!copycatBE.getMaterialItemStorage().hasCustomMaterial(property)) {
            return InteractionResult.PASS;
        }
        Player player = context.getPlayer();
        if (!player.isCreative()) {
            player.getInventory().placeItemBackInInventory(consumedItem);
        }
        context.getLevel().levelEvent(2001, context.getClickedPos(), Block.getId((BlockState)material.material()));
        copycatBE.setMaterial(property, AllBlocks.COPYCAT_BASE.getDefaultState());
        copycatBE.setConsumedItem(property, ItemStack.EMPTY);
        return InteractionResult.SUCCESS;
    }

    @Nullable
    default public BlockState getAcceptedBlockState(String property, Level pLevel, BlockPos pPos, ItemStack item, Direction face) {
        return this.getAcceptedBlockState(pLevel, pPos, item, face);
    }

    @Override
    default public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Direction face;
        if (stack.is(Tags.Items.TOOLS_WRENCH)) {
            InteractionResult result = ((WrenchItem)AllItems.WRENCH.get()).useOn(new UseOnContext(player, hand, hitResult));
            if (result.indicateItemUse()) {
                player.swing(hand);
            }
            if (result.consumesAction()) {
                return ItemInteractionResult.CONSUME;
            }
        }
        if (player == null || !player.mayBuild()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        String property = this.getPropertyFromInteraction(state, (BlockGetter)level, pos, hitResult, true);
        BlockState material = this.getAcceptedBlockState(property, level, pos, stack, face = hitResult.getDirection());
        if (material != null) {
            material = this.prepareMaterial(level, pos, state, player, hand, hitResult, material);
        }
        if (material == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        IMultiStateCopycatBlockEntity copycatBE = this.getCopycatBlockEntity((BlockGetter)level, pos);
        if (copycatBE == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!this.partExists(state, property)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (copycatBE.getMaterialItemStorage().getMaterialItem(property).material().is(material.getBlock())) {
            if (!copycatBE.cycleMaterial(property)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            copycatBE.getLevel().playSound(null, copycatBE.getBlockPos(), SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.75f, 0.95f);
            return ItemInteractionResult.SUCCESS;
        }
        if (copycatBE.getMaterialItemStorage().hasCustomMaterial(property)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level.isClientSide()) {
            if (CCKeys.FILL_COPYCAT.isPressed()) {
                this.fillEmptyParts(level, pos, state, material);
                CCPackets.network().sendToServer((CustomPacketPayload)new FillCopycatPacket(pos, material, property));
            }
            return ItemInteractionResult.SUCCESS;
        }
        boolean freeToApply = copycatBE.getMaterialItemStorage().getAllConsumedItems().stream().anyMatch(s -> s.getItem() == stack.getItem());
        copycatBE.setMaterial(property, material);
        if (!freeToApply) {
            copycatBE.setConsumedItem(property, stack);
        }
        copycatBE.getLevel().playSound(null, copycatBE.getBlockPos(), material.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 0.75f);
        if (player.isCreative()) {
            return ItemInteractionResult.SUCCESS;
        }
        if (!freeToApply) {
            stack.shrink(1);
        }
        if (stack.isEmpty()) {
            player.setItemInHand(hand, ItemStack.EMPTY);
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    default public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer == null) {
            return;
        }
        ItemStack offhandItem = placer.getItemInHand(InteractionHand.OFF_HAND);
        BlockState appliedState = this.getAcceptedBlockState(level, pos, offhandItem, Direction.orderedByNearest((Entity)placer)[0]);
        if (appliedState == null) {
            return;
        }
        IMultiStateCopycatBlockEntity copycatBE = this.getCopycatBlockEntity((BlockGetter)level, pos);
        if (copycatBE == null) {
            return;
        }
        for (String property : this.storageProperties()) {
            Player player;
            if (!this.partExists(state, property) || copycatBE.getMaterialItemStorage().hasCustomMaterial(property)) continue;
            boolean freeToApply = copycatBE.getMaterialItemStorage().getAllConsumedItems().stream().anyMatch(s -> s.getItem() == offhandItem.getItem());
            copycatBE.setMaterial(property, appliedState);
            if (!freeToApply) {
                copycatBE.setConsumedItem(property, offhandItem);
            }
            if (placer instanceof Player && (player = (Player)placer).isCreative()) continue;
            if (!freeToApply) {
                offhandItem.shrink(1);
            }
            if (!offhandItem.isEmpty()) continue;
            placer.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
            break;
        }
        BlockEntityUtils.redraw((BlockEntity)copycatBE);
    }

    @Override
    default public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving, ICopycatBlock.OnRemoveHandler handler) {
        IMultiStateCopycatBlockEntity copycatBE;
        if (!state.hasBlockEntity() || state.getBlock() == newState.getBlock()) {
            return;
        }
        if (!isMoving && (copycatBE = this.getCopycatBlockEntity((BlockGetter)level, pos)) != null) {
            copycatBE.getMaterialItemStorage().getAllConsumedItems().forEach(stack -> Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack));
        }
        handler.handle(state, level, pos, newState, isMoving);
        level.removeBlockEntity(pos);
    }

    @Override
    default public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        IMultiStateCopycatBlockEntity copycatBE;
        if (player.isCreative() && (copycatBE = this.getCopycatBlockEntity((BlockGetter)level, pos)) != null) {
            copycatBE.getMaterialItemStorage().getAllProperties().forEach(key -> copycatBE.getMaterialItemStorage().getMaterialItem((String)key).setConsumedItem(ItemStack.EMPTY));
        }
        return state;
    }

    default public void fillEmptyParts(Level level, BlockPos pos, BlockState state, BlockState material) {
        IMultiStateCopycatBlockEntity copycatBE = this.getCopycatBlockEntity((BlockGetter)level, pos);
        if (copycatBE == null) {
            return;
        }
        for (String property : copycatBE.getMaterialItemStorage().getAllProperties()) {
            if (copycatBE.getMaterialItemStorage().hasCustomMaterial(property) || !this.partExists(state, property)) continue;
            copycatBE.setMaterial(property, material);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static BlockState getAppearance(IMultiStateCopycatBlock block, BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        reader = Mods.ATHENA.runIfInstalled((Supplier<Supplier<T>>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getAppearance$5(net.minecraft.world.level.BlockAndTintGetter ), ()Ljava/util/function/Supplier;)((BlockAndTintGetter)level)).orElse(level);
        if (!(reader instanceof ScaledBlockAndTintGetter)) ** GOTO lbl-1000
        scaledLevel = (ScaledBlockAndTintGetter)reader;
        if (state.getBlock() instanceof IMultiStateCopycatBlock) {
            CopycatExternalContext.setPropertyForAppearance(scaledLevel.getPropertyForRender(state, pos));
        } else lbl-1000:
        // 2 sources

        {
            CopycatExternalContext.setPropertyForAppearance(block.defaultProperty());
        }
        if (block.isIgnoredConnectivitySide(reader, state, side, pos, queryPos, queryState)) {
            return state;
        }
        property = CopycatExternalContext.getPropertyForAppearance();
        if (property == null) {
            property = block.defaultProperty();
        }
        return (material = IMultiStateCopycatBlock.getMaterial((BlockGetter)reader, pos, property)).is(Blocks.AIR) != false ? AllBlocks.COPYCAT_BASE.getDefaultState() : material;
    }

    public VoxelShape getPartialFaceShape(BlockGetter var1, BlockState var2, String var3, Direction var4);

    public static BlockState getMaterial(BlockGetter reader, BlockPos targetPos, String property) {
        IMultiStateCopycatBlockEntity cbe;
        BlockEntity blockEntity = reader.getBlockEntity(targetPos);
        if (blockEntity instanceof IMultiStateCopycatBlockEntity && (cbe = (IMultiStateCopycatBlockEntity)blockEntity).getMaterialItemStorage().getMaterialItem(property) != null) {
            return cbe.getMaterialItemStorage().getMaterialItem(property).material();
        }
        return Blocks.AIR.defaultBlockState();
    }

    public void transformStorage(BlockState var1, IMultiStateCopycatBlockEntity var2, StructureTransform var3);

    public static ItemRequirement getRequiredItemsForParts(BlockState state, BooleanProperty ... property) {
        int count = 0;
        for (BooleanProperty part : property) {
            if (!((Boolean)state.getValue((Property)part)).booleanValue()) continue;
            ++count;
        }
        if (count == 0) {
            return ItemRequirement.NONE;
        }
        return new ItemRequirement(IntStream.range(0, count).mapToObj($ -> new ItemRequirement.StackRequirement(new ItemStack((ItemLike)state.getBlock().asItem()), ItemRequirement.ItemUseType.CONSUME)).toList());
    }

    default public boolean canConnectTexturesToward(String property, BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        return this.canConnectTexturesToward(reader, fromPos, toPos, state);
    }

    @Override
    default public boolean canOcclude(BlockGetter level, BlockState state, BlockPos pos) {
        if (level instanceof ScaledBlockAndTintGetter) {
            ScaledBlockAndTintGetter scaledWorld = (ScaledBlockAndTintGetter)level;
            return this.canOcclude(scaledWorld.getPropertyForRender(state, pos), level, state, pos);
        }
        return false;
    }

    default public boolean canOcclude(String property, BlockGetter level, BlockState state, BlockPos pos) {
        BlockState material = IMultiStateCopycatBlock.getMaterial(level, pos, property);
        if (AllBlocks.COPYCAT_BASE.has(material)) {
            return false;
        }
        return material.canOcclude();
    }

    @Override
    default public Optional<Boolean> shapeCanOccludeNeighbor(BlockGetter level, BlockPos pos, BlockState state, BlockPos neighborPos, Direction dir) {
        BlockState neighborState = level.getBlockState(neighborPos);
        return Optional.of(BlockFaceUtils.canOcclude(level, neighborState, neighborPos, state, pos, dir.getOpposite()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlockColor wrappedColor() {
        return new WrappedBlockColor();
    }

    private static /* synthetic */ Supplier lambda$getAppearance$5(BlockAndTintGetter level) {
        return () -> AthenaCompat.unwrapAthenaGetter(level);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WrappedBlockColor
    implements BlockColor {
        public int getColor(BlockState pState, @Nullable BlockAndTintGetter pLevel, @Nullable BlockPos pPos, int pTintIndex) {
            if (pLevel == null || pPos == null) {
                return GrassColor.get((double)0.5, (double)1.0);
            }
            String renderingProperty = CopycatExternalContext.getPropertyForBlockColor();
            if (renderingProperty != null) {
                return Minecraft.getInstance().getBlockColors().getColor(IMultiStateCopycatBlock.getMaterial((BlockGetter)pLevel, pPos, renderingProperty), pLevel, pPos, pTintIndex);
            }
            int tint = Minecraft.getInstance().getBlockColors().getColor(ICopycatBlock.getMaterial((BlockGetter)pLevel, pPos), pLevel, pPos, pTintIndex);
            BlockEntity be = pLevel.getBlockEntity(pPos);
            if (tint == -1 && be instanceof IMultiStateCopycatBlockEntity) {
                IMultiStateCopycatBlockEntity mscb = (IMultiStateCopycatBlockEntity)be;
                for (String property : mscb.getMaterialItemStorage().getAllProperties()) {
                    int anyTint = Minecraft.getInstance().getBlockColors().getColor(IMultiStateCopycatBlock.getMaterial((BlockGetter)pLevel, pPos, property), pLevel, pPos, pTintIndex);
                    if (anyTint == -1) continue;
                    return anyTint;
                }
            }
            return tint;
        }
    }
}

