/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat;

import com.copycatsplus.copycats.CCBlockEntityTypes;
import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.config.CCConfigs;
import com.copycatsplus.copycats.foundation.copycat.CCCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.CCCopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.MultiStateCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.multistate.MultiStateCopycatBlockEntity;
import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.content.decoration.copycat.CopycatBlockEntity;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.neoforge.registries.DeferredHolder;

public class MigrationManager {
    public static boolean migrationDisabled() {
        return CCConfigs.safeGetter(() -> (Boolean)CCConfigs.common().disableMigration.get(), false).get();
    }

    public static StructureTemplate.StructureBlockInfo migrateStructure(StructureTemplate.StructureBlockInfo info) {
        if (MigrationManager.migrationDisabled()) {
            return info;
        }
        BlockState state = info.state();
        CompoundTag nbt = info.nbt();
        if (state.getBlock() instanceof MultiStateCopycatBlock && nbt != null && nbt.contains("Material")) {
            BlockPos pos = info.pos();
            CopycatBlockEntity be = (CopycatBlockEntity)AllBlockEntityTypes.COPYCAT.create(pos, state);
            be.loadWithComponents(nbt, (HolderLookup.Provider)be.getLevel().registryAccess());
            MultiStateCopycatBlockEntity multiBe = (MultiStateCopycatBlockEntity)CCBlockEntityTypes.MULTI_STATE_COPYCAT.create(pos, state);
            multiBe.migrateData((ICopycatBlockEntity)be);
            nbt = multiBe.saveWithId((HolderLookup.Provider)be.getLevel().registryAccess());
            return new StructureTemplate.StructureBlockInfo(pos, state, nbt);
        }
        if (state.getBlock() instanceof CCCopycatBlock && nbt != null && nbt.contains("id") && nbt.getString("id").equals(AllBlockEntityTypes.COPYCAT.getId().toString())) {
            BlockPos pos = info.pos();
            CCCopycatBlockEntity be = (CCCopycatBlockEntity)CCBlockEntityTypes.COPYCAT.create(pos, state);
            be.loadWithComponents(nbt, (HolderLookup.Provider)be.getLevel().registryAccess());
            nbt = be.saveWithId((HolderLookup.Provider)be.getLevel().registryAccess());
            return new StructureTemplate.StructureBlockInfo(pos, state, nbt);
        }
        return info;
    }

    public static BlockEntity migrateBlockEntity(LevelChunk chunk, BlockEntity blockEntity) {
        if (MigrationManager.migrationDisabled()) {
            return blockEntity;
        }
        BlockPos pos = blockEntity.getBlockPos();
        BlockState state = chunk.getBlockState(pos);
        if (MigrationManager.isCopycatAndNeedingConversion(state, blockEntity)) {
            if (CCBlocks.getAllRegisteredMultiStateBlocks().stream().map(DeferredHolder::get).collect(Collectors.toSet()).contains(state.getBlock())) {
                CompoundTag oldTag = blockEntity.saveWithFullMetadata((HolderLookup.Provider)blockEntity.getLevel().registryAccess());
                MultiStateCopycatBlockEntity newBlockEntity = (MultiStateCopycatBlockEntity)CCBlockEntityTypes.MULTI_STATE_COPYCAT.create(pos, state);
                newBlockEntity.loadWithComponents(oldTag, (HolderLookup.Provider)blockEntity.getLevel().registryAccess());
                newBlockEntity.migrateData((ICopycatBlockEntity)blockEntity);
                return newBlockEntity;
            }
            CompoundTag oldTag = blockEntity.saveWithFullMetadata((HolderLookup.Provider)blockEntity.getLevel().registryAccess());
            CCCopycatBlockEntity newBlockEntity = (CCCopycatBlockEntity)CCBlockEntityTypes.COPYCAT.create(pos, state);
            newBlockEntity.loadWithComponents(oldTag, (HolderLookup.Provider)blockEntity.getLevel().registryAccess());
            return newBlockEntity;
        }
        return blockEntity;
    }

    private static boolean isCopycatAndNeedingConversion(BlockState state, BlockEntity blockEntity) {
        ResourceLocation id = BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)blockEntity.getType());
        if (id == null) {
            return false;
        }
        ResourceKey resourceKey = state.getBlock().builtInRegistryHolder().key();
        return id.toString().equalsIgnoreCase("create:copycat") && resourceKey.location().getNamespace().equalsIgnoreCase("copycats");
    }
}

