/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.biomespawnpoint_common_fabric.events;

import com.natamus.biomespawnpoint_common_fabric.data.Constants;
import com.natamus.biomespawnpoint_common_fabric.util.Util;
import com.natamus.collective_common_fabric.functions.BlockPosFunctions;
import com.natamus.collective_common_fabric.functions.FeatureFunctions;
import com.natamus.collective_common_fabric.services.Services;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import net.minecraft.class_5268;
import net.minecraft.class_5285;
import net.minecraft.class_7924;

public class BiomeSpawnEvent {
    public static boolean onWorldLoad(class_3218 serverLevel, class_5268 serverLevelData) {
        class_2338 spawnPos = null;
        try {
            class_2378 biomeRegistry = serverLevel.method_30349().method_30530(class_7924.field_41236);
            Util.loadSpawnBiomeConfig((class_2378<class_1959>)biomeRegistry);
            if (Util.spawnBiomeListSize() == 0) {
                Constants.logger.info("[Biome Spawn Point] No spawn biome specified in the spawnbiomes.txt config.");
            } else {
                String spawnBiome = Util.getSpawnBiome();
                if (spawnBiome.strip().equals("")) {
                    Constants.logger.info("[Biome Spawn Point] Received spawn point biome name is empty.");
                } else {
                    Constants.logger.info("[Biome Spawn Point] Finding the nearest '" + spawnBiome + "' biome. This might take a few seconds.");
                    spawnPos = BlockPosFunctions.getCenterNearbyBiome((class_3218)serverLevel, (String)spawnBiome);
                    if (spawnPos != null) {
                        Constants.logger.info("[Biome Spawn Point] Biome found!");
                    }
                }
            }
        }
        catch (Exception ex) {
            Constants.logger.info("[Biome Spawn Point] Unable to access Biome Registry on level load.");
        }
        class_5285 generatorsettings = serverLevel.method_8503().method_27728().method_28057();
        if (Services.MODLOADER.isModLoaded("villagespawnpoint") && generatorsettings.method_28029()) {
            if (spawnPos == null) {
                spawnPos = new class_2338(0, 0, 0);
                Constants.logger.info("[Biome Spawn Point] Unable to find biome, but Village Spawn Point installed, finding village near x=0, z=0.");
            } else {
                Constants.logger.info("[Biome Spawn Point] Village Spawn Point installed, finding village near biome. This might take a few seconds.");
            }
            class_2338 villagePos = BlockPosFunctions.getNearbyVillage((class_3218)serverLevel, (class_2338)spawnPos);
            if (villagePos != null) {
                Constants.logger.info("[Biome Spawn Point] Nearby village found.");
                spawnPos = villagePos.method_10062();
            }
        }
        if (spawnPos == null) {
            Constants.logger.info("[Biome Spawn Point] Unable to find custom spawn point.");
            return false;
        }
        Constants.logger.info("[Biome Spawn Point] The world will now generate.");
        serverLevel.method_8554(spawnPos, 1.0f);
        if (generatorsettings.method_28030()) {
            FeatureFunctions.placeBonusChest((class_1937)serverLevel, (class_2338)spawnPos);
        }
        return true;
    }
}

