/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.reg;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.common.CakeRegistry;
import net.mehvahdjukaar.amendments.common.LecternEditMenu;
import net.mehvahdjukaar.amendments.common.block.CarpetSlabBlock;
import net.mehvahdjukaar.amendments.common.block.CarpetStairBlock;
import net.mehvahdjukaar.amendments.common.block.CeilingBannerBlock;
import net.mehvahdjukaar.amendments.common.block.DirectionalCakeBlock;
import net.mehvahdjukaar.amendments.common.block.DoubleCakeBlock;
import net.mehvahdjukaar.amendments.common.block.DoubleSkullBlock;
import net.mehvahdjukaar.amendments.common.block.DyeCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.FloorCandleSkullBlock;
import net.mehvahdjukaar.amendments.common.block.HangingFlowerPotBlock;
import net.mehvahdjukaar.amendments.common.block.LiquidCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.ToolHookBlock;
import net.mehvahdjukaar.amendments.common.block.WallCandleSkullBlock;
import net.mehvahdjukaar.amendments.common.block.WallLanternBlock;
import net.mehvahdjukaar.amendments.common.block.WaterloggedLilyBlock;
import net.mehvahdjukaar.amendments.common.entity.FallingLanternEntity;
import net.mehvahdjukaar.amendments.common.entity.MediumDragonFireball;
import net.mehvahdjukaar.amendments.common.entity.MediumFireball;
import net.mehvahdjukaar.amendments.common.item.DragonChargeItem;
import net.mehvahdjukaar.amendments.common.item.DyeBottleItem;
import net.mehvahdjukaar.amendments.common.item.placement.WallLanternPlacement;
import net.mehvahdjukaar.amendments.common.recipe.CauldronRecipe;
import net.mehvahdjukaar.amendments.common.recipe.DyeBottleRecipe;
import net.mehvahdjukaar.amendments.common.tile.CandleSkullBlockTile;
import net.mehvahdjukaar.amendments.common.tile.CarpetedBlockTile;
import net.mehvahdjukaar.amendments.common.tile.CeilingBannerBlockTile;
import net.mehvahdjukaar.amendments.common.tile.DoubleSkullBlockTile;
import net.mehvahdjukaar.amendments.common.tile.HangingFlowerPotBlockTile;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.common.tile.ToolHookBlockTile;
import net.mehvahdjukaar.amendments.common.tile.WallLanternBlockTile;
import net.mehvahdjukaar.amendments.common.tile.WaterloggedLilyBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacement;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.misc.HolderRef;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.PushReaction;

public class ModRegistry {
    public static final HolderRef<DamageType> BOILING_DAMAGE = HolderRef.of((ResourceLocation)Amendments.res("boiling"), (ResourceKey)Registries.DAMAGE_TYPE);
    public static final HolderRef<SoftFluid> DYE_SOFT_FLUID = HolderRef.of((ResourceLocation)Amendments.res("dye"), (ResourceKey)SoftFluidRegistry.KEY);
    public static final RegSupplier<RecipeSerializer<DyeBottleRecipe>> DYE_BOTTLE_RECIPE = RegHelper.registerSpecialRecipe((ResourceLocation)Amendments.res("dye_bottle"), DyeBottleRecipe::new);
    public static final Supplier<MenuType<LecternEditMenu>> LECTERN_EDIT_MENU = RegHelper.registerMenuType((ResourceLocation)Amendments.res("lectern_edit"), LecternEditMenu::of);
    public static final RegSupplier<SimpleParticleType> BOILING_PARTICLE = RegHelper.registerParticle((ResourceLocation)Amendments.res("boiling_bubble"));
    public static final RegSupplier<SimpleParticleType> SPLASH_PARTICLE = RegHelper.registerParticle((ResourceLocation)Amendments.res("fluid_splash"));
    public static final Supplier<SimpleParticleType> DRAGON_FIREBALL_TRAIL_PARTICLE = RegHelper.registerParticle((ResourceLocation)Amendments.res("dragon_fireball_trail"));
    public static final Supplier<SimpleParticleType> FIREBALL_TRAIL_PARTICLE = RegHelper.registerParticle((ResourceLocation)Amendments.res("fireball_trail"));
    public static final Supplier<SimpleParticleType> FIREBALL_EMITTER_PARTICLE = RegHelper.registerParticle((ResourceLocation)Amendments.res("fireball_explosion_emitter"));
    public static final Supplier<SimpleParticleType> FIREBALL_EXPLOSION_PARTICLE = RegHelper.registerParticle((ResourceLocation)Amendments.res("fireball_explosion"));
    public static final RegSupplier<SoundEvent> FIREBALL_EXPLOSION_SOUND = RegHelper.registerSound((ResourceLocation)Amendments.res("explosion.fireball"));
    public static final Supplier<RecipeType<CauldronRecipe>> CAULDRON_RECIPE_TYPE = RegHelper.registerRecipeType((ResourceLocation)Amendments.res("cauldron_crafting"));
    public static final Supplier<RecipeSerializer<CauldronRecipe>> CAULDRON_RECIPE_SERIALIZER = RegHelper.registerRecipeSerializer((ResourceLocation)Amendments.res("cauldron_crafting"), CauldronRecipe.Serializer::new);
    public static final Supplier<EntityType<MediumDragonFireball>> MEDIUM_DRAGON_FIREBALL = ModRegistry.regEntity("medium_dragon_fireball", EntityType.Builder.of(MediumDragonFireball::new, (MobCategory)MobCategory.MISC).sized(0.3125f, 0.3125f).clientTrackingRange(16).updateInterval(5));
    public static final Supplier<EntityType<MediumFireball>> MEDIUM_FIREBALL = ModRegistry.regEntity("medium_fireball", EntityType.Builder.of(MediumFireball::new, (MobCategory)MobCategory.MISC).sized(0.3125f, 0.3125f).clientTrackingRange(16).updateInterval(5));
    public static final Supplier<Item> DRAGON_CHARGE = ModRegistry.regItem("dragon_charge", () -> new DragonChargeItem(new Item.Properties()));
    public static final Supplier<Item> DYE_BOTTLE_ITEM = ModRegistry.regItem("dye_bottle", () -> new DyeBottleItem(new Item.Properties().component(DataComponents.DYED_COLOR, (Object)DyeBottleItem.RED_COLOR).stacksTo(1).craftRemainder(Items.GLASS_BOTTLE)));
    public static final Supplier<Block> WATERLILY_BLOCK = ModRegistry.regBlock("water_lily_pad", () -> new WaterloggedLilyBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LILY_PAD).instabreak().sound(SoundType.LILY_PAD).noOcclusion()));
    public static final Supplier<BlockEntityType<WaterloggedLilyBlockTile>> WATERLILY_TILE = ModRegistry.regTile("water_lily_pad", () -> PlatHelper.newBlockEntityType(WaterloggedLilyBlockTile::new, (Block[])new Block[]{WATERLILY_BLOCK.get()}));
    public static final Supplier<LiquidCauldronBlock> LIQUID_CAULDRON = ModRegistry.regBlock("liquid_cauldron", () -> new LiquidCauldronBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON)));
    public static final Supplier<Block> DYE_CAULDRON = ModRegistry.regBlock("dye_cauldron", () -> new DyeCauldronBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON)));
    public static final Supplier<BlockEntityType<LiquidCauldronBlockTile>> LIQUID_CAULDRON_TILE = ModRegistry.regTile("liquid_cauldron", () -> PlatHelper.newBlockEntityType(LiquidCauldronBlockTile::new, (Block[])new Block[]{(Block)LIQUID_CAULDRON.get(), DYE_CAULDRON.get()}));
    public static final Supplier<Block> HANGING_FLOWER_POT = ModRegistry.regBlock("hanging_flower_pot", () -> new HangingFlowerPotBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT)));
    public static final Supplier<BlockEntityType<HangingFlowerPotBlockTile>> HANGING_FLOWER_POT_TILE = ModRegistry.regTile("hanging_flower_pot", () -> PlatHelper.newBlockEntityType(HangingFlowerPotBlockTile::new, (Block[])new Block[]{HANGING_FLOWER_POT.get()}));
    public static final Map<DyeColor, Supplier<Block>> CEILING_BANNERS = (Map)Util.make(() -> {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        for (DyeColor color : BlocksColorAPI.SORTED_COLORS) {
            String name = "ceiling_banner_" + color.getName();
            map.put(color, ModRegistry.regBlock(name, () -> new CeilingBannerBlock(color, BlockBehaviour.Properties.of().ignitedByLava().forceSolidOn().mapColor(color.getMapColor()).strength(1.0f).noCollission().sound(SoundType.WOOD))));
        }
        return Collections.unmodifiableMap(map);
    });
    public static final Supplier<BlockEntityType<CeilingBannerBlockTile>> CEILING_BANNER_TILE = ModRegistry.regTile("ceiling_banner", () -> PlatHelper.newBlockEntityType(CeilingBannerBlockTile::new, (Block[])((Block[])CEILING_BANNERS.values().stream().map(Supplier::get).toArray(Block[]::new))));
    public static final Supplier<Block> CARPET_STAIRS = ModRegistry.regBlock("carpet_stairs", () -> new CarpetStairBlock(Blocks.OAK_STAIRS, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_STAIRS)));
    public static final Supplier<Block> CARPET_SLAB = ModRegistry.regBlock("carpet_slab", () -> new CarpetSlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SLAB)));
    public static final Supplier<BlockEntityType<CarpetedBlockTile>> CARPET_STAIRS_TILE = ModRegistry.regTile("carpeted_block", () -> PlatHelper.newBlockEntityType(CarpetedBlockTile::new, (Block[])new Block[]{CARPET_STAIRS.get(), CARPET_SLAB.get()}));
    public static final Supplier<WallLanternBlock> WALL_LANTERN = ModRegistry.regBlock("wall_lantern", () -> {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN).pushReaction(PushReaction.DESTROY).lightLevel(state -> 15).noLootTable();
        return new WallLanternBlock(p);
    });
    public static final Supplier<BlockEntityType<WallLanternBlockTile>> WALL_LANTERN_TILE = ModRegistry.regTile("wall_lantern", () -> PlatHelper.newBlockEntityType(WallLanternBlockTile::new, (Block[])new Block[]{(Block)WALL_LANTERN.get()}));
    public static final Supplier<EntityType<FallingLanternEntity>> FALLING_LANTERN = ModRegistry.regEntity("falling_lantern", EntityType.Builder.of(FallingLanternEntity::new, (MobCategory)MobCategory.MISC).sized(0.98f, 0.98f).clientTrackingRange(10).updateInterval(20));
    public static final Supplier<ToolHookBlock> TOOL_HOOK = ModRegistry.regBlock("tool_hook", () -> {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TRIPWIRE_HOOK).dropsLike(Blocks.TRIPWIRE_HOOK);
        return new ToolHookBlock(p);
    });
    public static final Supplier<BlockEntityType<ToolHookBlockTile>> TOOL_HOOK_TILE = ModRegistry.regTile("tool_hook", () -> PlatHelper.newBlockEntityType(ToolHookBlockTile::new, (Block[])new Block[]{TOOL_HOOK.get()}));
    public static final Supplier<Block> SKULL_PILE = ModRegistry.regBlock("skull_pile", () -> {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SKELETON_SKULL).sound(SoundType.BONE_BLOCK);
        return new DoubleSkullBlock(p);
    });
    public static final Supplier<BlockEntityType<DoubleSkullBlockTile>> SKULL_PILE_TILE = ModRegistry.regTile("skull_pile", () -> PlatHelper.newBlockEntityType(DoubleSkullBlockTile::new, (Block[])new Block[]{SKULL_PILE.get()}));
    public static final Supplier<Block> SKULL_CANDLE = ModRegistry.regBlock("skull_candle", () -> new FloorCandleSkullBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SKELETON_SKULL).sound(SoundType.BONE_BLOCK)));
    public static final Supplier<Block> SKULL_CANDLE_WALL = ModRegistry.regBlock("skull_candle_wall", () -> new WallCandleSkullBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SKULL_CANDLE.get()))));
    public static final Supplier<Block> SKULL_CANDLE_SOUL = ModRegistry.regBlock("skull_candle_soul", () -> new FloorCandleSkullBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SKULL_CANDLE.get()))));
    public static final Supplier<Block> SKULL_CANDLE_SOUL_WALL = ModRegistry.regBlock("skull_candle_soul_wall", () -> new WallCandleSkullBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SKULL_CANDLE.get()))));
    public static final Supplier<BlockEntityType<CandleSkullBlockTile>> SKULL_CANDLE_TILE = ModRegistry.regTile("skull_candle", () -> PlatHelper.newBlockEntityType(CandleSkullBlockTile::new, (Block[])new Block[]{SKULL_CANDLE.get(), SKULL_CANDLE_WALL.get(), SKULL_CANDLE_SOUL.get(), SKULL_CANDLE_SOUL_WALL.get()}));
    public static final Supplier<Block> DIRECTIONAL_CAKE = ModRegistry.regBlock("directional_cake", () -> new DirectionalCakeBlock(CakeRegistry.VANILLA));
    public static final Map<CakeRegistry.CakeType, DoubleCakeBlock> DOUBLE_CAKES = new LinkedHashMap<CakeRegistry.CakeType, DoubleCakeBlock>();

    public static void init() {
        BlockSetAPI.registerBlockSetDefinition((BlockTypeRegistry)CakeRegistry.INSTANCE);
        BlockSetAPI.addDynamicRegistration((String)"amendments", ModRegistry::registerDoubleCakes, (Registry)BuiltInRegistries.BLOCK);
    }

    public static void registerAdditionalPlacements() {
        WallLanternPlacement wallLanternPlacement = new WallLanternPlacement();
        for (Item i : BuiltInRegistries.ITEM) {
            if (!(i instanceof BlockItem)) continue;
            BlockItem bi = (BlockItem)i;
            Block block = bi.getBlock();
            Preconditions.checkNotNull((Object)block, (Object)("BlockItem " + String.valueOf(i) + " has a NULL block! This is not an amendments issue and its likely caused by some bigger underlying issue"));
            if (!CommonConfigs.WALL_LANTERN.get().booleanValue() || !WallLanternBlock.isValidBlock(block)) continue;
            AdditionalItemPlacementsAPI.registerPlacement((Item)i, (AdditionalItemPlacement)wallLanternPlacement);
        }
        if (CommonConfigs.HANGING_POT.get().booleanValue()) {
            AdditionalItemPlacementsAPI.registerSimplePlacement((Item)Items.FLOWER_POT, (Block)HANGING_FLOWER_POT.get());
        }
        if (CommonConfigs.CEILING_BANNERS.get().booleanValue()) {
            for (Map.Entry<DyeColor, Supplier<Block>> e : CEILING_BANNERS.entrySet()) {
                Item item = BannerBlock.byColor((DyeColor)e.getKey()).asItem();
                if (item == Items.AIR) {
                    throw new IllegalStateException("Block " + String.valueOf(e.getValue().get()) + " has no corresponding item! How did this happen? Some OTHER mod must have screwed up the block to items map!");
                }
                AdditionalItemPlacementsAPI.registerSimplePlacement((Item)((Item)Preconditions.checkNotNull((Object)item)), (Block)e.getValue().get());
            }
        }
    }

    private static void registerDoubleCakes(Registrator<Block> event) {
        Iterator iterator = CakeRegistry.INSTANCE.iterator();
        while (iterator.hasNext()) {
            CakeRegistry.CakeType type = (CakeRegistry.CakeType)((Object)iterator.next());
            ResourceLocation id = Amendments.res(type.getVariantId("double"));
            DoubleCakeBlock block = new DoubleCakeBlock(type);
            type.addChild("double_cake", (Object)block);
            event.register(id, (Object)block);
            DOUBLE_CAKES.put(type, block);
        }
    }

    public static <T extends BlockEntityType<E>, E extends BlockEntity> Supplier<T> regTile(String name, Supplier<T> sup) {
        return RegHelper.registerBlockEntityType((ResourceLocation)Amendments.res(name), sup);
    }

    public static <T extends Block> RegSupplier<T> regBlock(String name, Supplier<T> sup) {
        return RegHelper.registerBlock((ResourceLocation)Amendments.res(name), sup);
    }

    public static <T extends Item> RegSupplier<T> regItem(String name, Supplier<T> sup) {
        return RegHelper.registerItem((ResourceLocation)Amendments.res(name), sup);
    }

    public static <T extends Entity> Supplier<EntityType<T>> regEntity(String name, EntityType.Builder<T> builder) {
        return RegHelper.registerEntityType((ResourceLocation)Amendments.res(name), builder);
    }
}

