/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.neoforge.mixin.perf.faster_ingredients;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import org.embeddedt.modernfix.neoforge.load.MinecraftServerReloadTracker;
import org.embeddedt.modernfix.neoforge.recipe.ExtendedIngredient;
import org.embeddedt.modernfix.neoforge.recipe.IngredientItemStacksSoftReference;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Ingredient.class}, priority=700)
public abstract class IngredientMixin
implements ExtendedIngredient {
    @Shadow
    @Final
    private Ingredient.Value[] values;
    @Shadow
    @Nullable
    private IntList stackingIds;
    @Shadow
    @Nullable
    private ItemStack[] itemStacks;
    @Shadow
    private ICustomIngredient customIngredient;
    private volatile IngredientItemStacksSoftReference mfix$cachedItemStacks;

    @Shadow
    public abstract boolean isCustom();

    @Unique
    private boolean isVanilla() {
        return !this.isCustom();
    }

    private boolean mfix$areTagsAvailable() {
        return !MinecraftServerReloadTracker.isReloadActive();
    }

    @Inject(method={"test(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/crafting/Ingredient;getItems()[Lnet/minecraft/world/item/ItemStack;")}, cancellable=true)
    private void modernfix$fasterTagIngredientTest(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        Ingredient.Value value;
        if (this.isVanilla() && this.values.length == 1 && (value = this.values[0]) instanceof Ingredient.TagValue) {
            Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
            if (this.mfix$areTagsAvailable()) {
                cir.setReturnValue((Object)stack.getItemHolder().is(tagValue.tag()));
            }
        }
    }

    @Inject(method={"hasNoItems"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void hasNoItems(CallbackInfoReturnable<Boolean> cir) {
        if (this.isVanilla()) {
            cir.setReturnValue((Object)(!this.containsItems() ? 1 : 0));
        }
    }

    @Unique
    private boolean isEmptyTagStack(ItemStack item) {
        MutableComponent hoverName;
        Component component;
        return item.getItem() == Items.BARRIER && (component = item.getHoverName()) instanceof MutableComponent && (hoverName = (MutableComponent)component).getString().startsWith("Empty Tag: ");
    }

    @Unique
    private boolean containsItems() {
        for (Ingredient.Value value : this.values) {
            Collection items;
            if (value instanceof Ingredient.ItemValue) {
                return true;
            }
            if (value instanceof Ingredient.TagValue) {
                Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                if (this.mfix$areTagsAvailable()) {
                    Optional holderSetOpt = BuiltInRegistries.ITEM.getTag(tagValue.tag());
                    if (!holderSetOpt.isPresent() || ((HolderSet.Named)holderSetOpt.get()).size() <= 0) continue;
                    return true;
                }
            }
            if ((items = value.getItems()).isEmpty() || this.isEmptyTagStack((ItemStack)items.iterator().next())) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"getStackingIds"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/crafting/Ingredient;getItems()[Lnet/minecraft/world/item/ItemStack;")}, cancellable=true)
    private void modernfix$fasterTagIngredientStacking(CallbackInfoReturnable<IntList> cir) {
        Ingredient.Value value;
        if (this.isVanilla() && this.values.length == 1 && (value = this.values[0]) instanceof Ingredient.TagValue) {
            Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
            if (this.mfix$areTagsAvailable()) {
                Optional tag = BuiltInRegistries.ITEM.getTag(tagValue.tag());
                if (!tag.isPresent() || ((HolderSet.Named)tag.get()).size() == 0) {
                    return;
                }
                IntArrayList list = new IntArrayList(((HolderSet.Named)tag.get()).stream().mapToInt(h -> BuiltInRegistries.ITEM.getId((Object)((Item)h.value()))).toArray());
                list.sort(IntComparators.NATURAL_COMPARATOR);
                this.stackingIds = list;
                cir.setReturnValue((Object)list);
            }
        }
    }

    @Overwrite
    public ItemStack[] getItems() {
        ItemStack[] stacks;
        if (this.itemStacks != null) {
            return this.itemStacks;
        }
        if (this.customIngredient != null) {
            this.itemStacks = (ItemStack[])this.customIngredient.getItems().collect(Collectors.toCollection(ItemStackLinkedSet::createTypeAndComponentsSet)).toArray(ItemStack[]::new);
            return this.itemStacks;
        }
        IngredientItemStacksSoftReference cache = this.mfix$cachedItemStacks;
        if (cache != null && (stacks = (ItemStack[])cache.get()) != null) {
            return stacks;
        }
        ItemStack[] result = this.computeItemsArray();
        this.mfix$cachedItemStacks = new IngredientItemStacksSoftReference((Ingredient)this, result);
        return result;
    }

    private ItemStack[] computeItemsArray() {
        Ingredient.Value[] valueArray;
        if (this.values.length == 1 && (valueArray = this.values[0]) instanceof Ingredient.TagValue) {
            Optional tag;
            Ingredient.TagValue tagValue = (Ingredient.TagValue)valueArray;
            if (this.mfix$areTagsAvailable() && (tag = BuiltInRegistries.ITEM.getTag(tagValue.tag())).isPresent() && ((HolderSet.Named)tag.get()).size() > 0) {
                HolderSet.Named holderSet = (HolderSet.Named)tag.get();
                ItemStack[] result = new ItemStack[holderSet.size()];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = new ItemStack(holderSet.get(i));
                }
                return result;
            }
        }
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(2);
        for (Ingredient.Value value : this.values) {
            Collection collection = value.getItems();
            itemList.ensureCapacity(collection.size() + itemList.size());
            for (ItemStack item : collection) {
                itemList.add(item);
            }
        }
        return (ItemStack[])itemList.toArray(ItemStack[]::new);
    }

    @Override
    public void mfix$clearReference() {
        this.mfix$cachedItemStacks = null;
    }
}

