/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;

public record ClearRepeatCooldownMessage(long id) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClearRepeatCooldownMessage> TYPE = new CustomPacketPayload.Type(FTBQuestsAPI.rl("clear_repeat_cooldown"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClearRepeatCooldownMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, ClearRepeatCooldownMessage::id, ClearRepeatCooldownMessage::new);

    public CustomPacketPayload.Type<ClearRepeatCooldownMessage> type() {
        return TYPE;
    }

    public static void handle(ClearRepeatCooldownMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            QuestObjectBase patt0$temp;
            if (ClientQuestFile.exists() && (patt0$temp = ClientQuestFile.INSTANCE.getBase(message.id)) instanceof Quest) {
                Quest quest = (Quest)patt0$temp;
                ClientQuestFile.INSTANCE.selfTeamData.clearRepeatCooldown(quest);
            }
        });
    }

    public static void sendToTeam(Quest quest, UUID teamId) {
        FTBTeamsAPI.api().getManager().getTeamByID(teamId).ifPresent(team -> {
            ClearRepeatCooldownMessage msg = new ClearRepeatCooldownMessage(quest.getId());
            team.getOnlineMembers().forEach(player -> NetworkHelper.sendTo((ServerPlayer)player, (CustomPacketPayload)msg));
        });
    }
}

