/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.rpcsdk.connection;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.hypherionmc.simplerpc.rpcsdk.DiscordRpc;
import com.hypherionmc.simplerpc.rpcsdk.connection.BaseConnection;
import com.hypherionmc.simplerpc.rpcsdk.enums.ErrorCode;
import com.hypherionmc.simplerpc.rpcsdk.enums.OpCode;
import com.hypherionmc.simplerpc.rpcsdk.enums.RPCState;
import com.hypherionmc.simplerpc.rpcsdk.exceptions.NoDiscordClientException;
import com.hypherionmc.simplerpc.rpcsdk.exceptions.PipeAccessDenied;
import com.hypherionmc.simplerpc.rpcsdk.exceptions.UnsupportedOsType;
import com.hypherionmc.simplerpc.rpcsdk.handlers.Callbacks;
import com.hypherionmc.simplerpc.rpcsdk.models.MessageFrame;
import com.hypherionmc.simplerpc.rpcsdk.models.User;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RPCConnection {
    private static final Gson GSON = new GsonBuilder().serializeNulls().create();
    private final BaseConnection baseConnection;
    private Callbacks.Connected connectedCallback;
    private Callbacks.Disconnected disconnectedCallback;
    private final String appId;
    private ErrorCode lastErrorCode;
    private String lastErrorMessage;
    private RPCState state;
    private final Lock writeLock;
    private final DiscordRpc rpcClient;

    private RPCConnection(String applicationId, DiscordRpc rpc) throws UnsupportedOsType {
        this.baseConnection = BaseConnection.createConnection(rpc);
        this.state = RPCState.DISCONNECTED;
        this.rpcClient = rpc;
        this.connectedCallback = null;
        this.disconnectedCallback = null;
        this.appId = applicationId;
        this.lastErrorCode = ErrorCode.SUCCESS;
        this.lastErrorMessage = null;
        this.writeLock = new ReentrantLock();
    }

    public static RPCConnection create(String applicationId, DiscordRpc rpc) throws UnsupportedOsType {
        return new RPCConnection(applicationId, rpc);
    }

    public static void destroy(RPCConnection connection) {
        connection.close();
    }

    public boolean isOpen() {
        return this.state == RPCState.CONNECTED && this.baseConnection.isOpen();
    }

    private String writeHandshake() {
        JsonObject data = new JsonObject();
        data.add("v", (JsonElement)new JsonPrimitive((Number)1));
        data.add("client_id", (JsonElement)new JsonPrimitive(this.appId));
        return data.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws NoDiscordClientException, PipeAccessDenied {
        boolean success;
        if (this.state == RPCState.CONNECTED) {
            return;
        }
        if (this.state == RPCState.DISCONNECTED && !this.baseConnection.open()) {
            return;
        }
        if (this.state == RPCState.SENT_HANDSHAKE) {
            JsonObject data = new JsonObject();
            if (this.read(data)) {
                String evt;
                String cmd = data.has("cmd") && !data.get("cmd").isJsonNull() ? data.get("cmd").getAsString() : null;
                String string = evt = data.has("evt") && !data.get("evt").isJsonNull() ? data.get("evt").getAsString() : null;
                if (cmd != null && evt != null && cmd.equals("DISPATCH") && evt.equals("READY")) {
                    this.state = RPCState.CONNECTED;
                    JsonObject userData = data.get("data").getAsJsonObject().get("user").getAsJsonObject();
                    User user = (User)GSON.fromJson((JsonElement)userData, User.class);
                    if (this.connectedCallback != null) {
                        this.connectedCallback.accept(user);
                    }
                }
            }
            return;
        }
        MessageFrame messageFrame = new MessageFrame(OpCode.HANDSHAKE, this.writeHandshake());
        this.writeLock.lock();
        try {
            success = this.baseConnection.write(messageFrame.write().array());
        }
        finally {
            this.writeLock.unlock();
        }
        if (success) {
            this.state = RPCState.SENT_HANDSHAKE;
        } else {
            this.close();
        }
    }

    private void close() {
        if (this.disconnectedCallback != null && (this.state == RPCState.CONNECTED || this.state == RPCState.SENT_HANDSHAKE)) {
            this.disconnectedCallback.accept(this.lastErrorCode, this.lastErrorMessage);
        }
        BaseConnection.destroyConnection(this.baseConnection);
        this.state = RPCState.DISCONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(byte[] bytes) {
        boolean success;
        MessageFrame messageFrame = new MessageFrame(OpCode.FRAME, new String(bytes, StandardCharsets.UTF_8));
        this.writeLock.lock();
        try {
            success = this.baseConnection.write(messageFrame.write().array());
        }
        finally {
            this.writeLock.unlock();
        }
        if (!success) {
            this.close();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read(JsonObject jsonObject) {
        if (this.state != RPCState.CONNECTED && this.state != RPCState.SENT_HANDSHAKE) {
            return false;
        }
        MessageFrame messageFrame = new MessageFrame();
        block9: while (true) {
            boolean didRead;
            if (!(didRead = this.baseConnection.read(messageFrame.getHeaderBuffer(), messageFrame.getHeaderBuffer().length)) || !messageFrame.parseHeader()) {
                if (!this.baseConnection.isOpen()) {
                    this.lastErrorCode = ErrorCode.PIPE_CLOSED;
                    this.lastErrorMessage = "Pipe Closed";
                    this.close();
                }
                return false;
            }
            if (!(messageFrame.getLength() <= 0 || (didRead = this.baseConnection.read(messageFrame.getMessageBuffer(), messageFrame.getLength())) && messageFrame.parseMessage())) {
                this.lastErrorCode = ErrorCode.READ_CORRUPT;
                this.lastErrorMessage = "Partial data in frame";
                this.close();
                return false;
            }
            JsonObject object = (JsonObject)GSON.fromJson(messageFrame.getMessage(), JsonObject.class);
            this.rpcClient.printDebug("Got Message %s", object.toString());
            switch (messageFrame.getOpCode()) {
                case CLOSE: {
                    int error;
                    object.entrySet().forEach(entry -> jsonObject.add((String)entry.getKey(), (JsonElement)entry.getValue()));
                    int n = error = object.has("code") && !object.get("code").isJsonNull() ? object.get("code").getAsInt() : 0;
                    if (error == 1000) {
                        error = 4;
                    }
                    this.lastErrorCode = error >= ErrorCode.values().length ? ErrorCode.UNKNOWN : ErrorCode.values()[error];
                    this.lastErrorMessage = object.has("message") && !object.get("message").isJsonNull() ? object.get("message").getAsString() : "";
                    this.close();
                    return false;
                }
                case FRAME: {
                    object.entrySet().forEach(entry -> jsonObject.add((String)entry.getKey(), (JsonElement)entry.getValue()));
                    return true;
                }
                case PING: {
                    boolean success;
                    messageFrame.setOpCode(OpCode.PONG);
                    this.writeLock.lock();
                    try {
                        success = this.baseConnection.write(messageFrame.write().array());
                    }
                    finally {
                        this.writeLock.unlock();
                    }
                    if (!success) continue block9;
                    this.close();
                    continue block9;
                }
                case PONG: {
                    continue block9;
                }
            }
            break;
        }
        this.lastErrorCode = ErrorCode.READ_CORRUPT;
        this.lastErrorMessage = "Bad IPC Frame";
        this.close();
        return false;
    }

    public BaseConnection getBaseConnection() {
        return this.baseConnection;
    }

    public void setConnectedCallback(Callbacks.Connected connectedCallback) {
        this.connectedCallback = connectedCallback;
    }

    public void setDisconnectedCallback(Callbacks.Disconnected disconnectedCallback) {
        this.disconnectedCallback = disconnectedCallback;
    }
}

