/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.config.base;

import com.hypherionmc.craterlib.core.config.AbstractConfig;
import com.hypherionmc.craterlib.core.config.ConfigController;
import com.hypherionmc.simplerpc.RPCConstants;
import com.hypherionmc.simplerpc.config.impl.ClientConfig;
import com.hypherionmc.simplerpc.config.impl.ReplayModConfig;
import com.hypherionmc.simplerpc.config.impl.ServerEntriesConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import shadow.hypherionmc.moonconfig.core.CommentedConfig;
import shadow.hypherionmc.moonconfig.core.Config;
import shadow.hypherionmc.moonconfig.core.conversion.ObjectConverter;
import shadow.hypherionmc.moonconfig.core.fields.RandomArrayList;
import shadow.hypherionmc.moonconfig.core.file.CommentedFileConfig;

public abstract class BaseRPCConfig<S extends BaseRPCConfig>
extends AbstractConfig<S> {
    public BaseRPCConfig(String configName, String langCode) {
        super("simplerpc", "simple-rpc", BaseRPCConfig.getConfigName(configName, "simple-rpc", langCode));
    }

    private static String getConfigName(String configName, String subFolder, String langCode) {
        File configDir = new File("config" + (String)(subFolder.isEmpty() ? "" : File.separator + subFolder));
        Object configName1 = configName;
        File translated = new File(configDir + File.separator + configName + "_" + langCode + ".toml");
        if (!langCode.isEmpty() && translated.exists()) {
            configName1 = configName + "_" + langCode + ".toml";
        }
        return configName1;
    }

    public void registerAndSetup(S config) {
        if (!config.getConfigPath().exists() || config.getConfigPath().length() < 2L) {
            this.appendAdditional();
            this.saveConfig(config);
            RPCConstants.logger.info("Saved config to {}", (Object)config.getConfigPath().getAbsolutePath());
        } else {
            this.migrateConfigInternal(config);
        }
        RPCConstants.logger.info("Loading config file from {}", (Object)config.getConfigPath().getAbsolutePath());
        ConfigController.register_config((AbstractConfig)this);
        this.configReloaded();
    }

    private void migrateConfigInternal(S conf) {
        int ver;
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((File)conf.getConfigPath()).sync().build();
        CommentedFileConfig newConfig = (CommentedFileConfig)CommentedFileConfig.builder((File)conf.getConfigPath()).sync().build();
        config.load();
        int n = ver = config.contains("general.version") ? config.getInt("general.version") : config.getIntOrElse("version", 0);
        if (ver != this.getConfigVersion()) {
            if (ver < 24 && this instanceof ClientConfig) {
                config.close();
                conf.getConfigPath().renameTo(new File(conf.getConfigPath().getAbsolutePath().replace(".toml", ".legacy")));
                RPCConstants.logger.error("Your Simple RPC config file is too old and cannot be upgraded. A new one has been created and your old one backed up to simple-rpc.legacy");
                this.appendAdditional();
                this.saveConfig(conf);
                return;
            }
            if (ver < 3 && this instanceof ServerEntriesConfig) {
                config.close();
                conf.getConfigPath().renameTo(new File(conf.getConfigPath().getAbsolutePath().replace(".toml", ".legacy")));
                RPCConstants.logger.error("Your Simple RPC server entries config file is too old and cannot be upgraded. A new one has been created and your old one backed up to server-entries.legacy");
                this.appendAdditional();
                this.saveConfig(conf);
                return;
            }
            if (ver < 2 && this instanceof ReplayModConfig) {
                config.close();
                conf.getConfigPath().renameTo(new File(conf.getConfigPath().getAbsolutePath().replace(".toml", ".legacy")));
                RPCConstants.logger.error("Your Simple RPC ReplayMod config file is too old and cannot be upgraded. A new one has been created and your old one backed up to simple-rpc-replaymod.legacy");
                this.appendAdditional();
                this.saveConfig(conf);
                return;
            }
            new ObjectConverter().toConfig(conf, (Config)newConfig);
            this.updateConfigValuesInternal((CommentedConfig)config, (CommentedConfig)newConfig, (CommentedConfig)newConfig, "", ver);
            conf.getConfigPath().renameTo(new File(conf.getConfigPath().getAbsolutePath().replace(".toml", ".bak")));
            newConfig.save();
        }
        config.close();
        newConfig.close();
    }

    private void updateConfigValuesInternal(CommentedConfig oldConfig, CommentedConfig newConfig, CommentedConfig outputConfig, String subKey, int ver) {
        List entryConfig;
        newConfig.valueMap().forEach((key, value) -> {
            String finalKey = subKey + (subKey.isEmpty() ? "" : ".") + key;
            if (value instanceof CommentedConfig) {
                this.updateConfigValuesInternal(oldConfig, (CommentedConfig)value, outputConfig, finalKey, ver);
            } else {
                Object val;
                Object object = val = oldConfig.contains(finalKey) ? oldConfig.get(finalKey) : value;
                if ((finalKey.contains("largeImageKey") || finalKey.contains("smallImageKey")) && !List.class.isAssignableFrom(val.getClass())) {
                    val = RandomArrayList.of((Object[])new Object[]{val});
                }
                outputConfig.set(finalKey, val);
            }
        });
        List commentedConfig = (List)newConfig.get("dimension_overrides.dimensions");
        if (commentedConfig != null && !commentedConfig.isEmpty()) {
            commentedConfig.forEach(ddm -> {
                List presence = (List)ddm.get("presence");
                if (presence != null && !presence.isEmpty()) {
                    presence.forEach(dim -> {
                        Object largeImg;
                        if (!dim.contains("buttons")) {
                            dim.add("buttons", new ArrayList());
                        }
                        if (!List.class.isAssignableFrom((largeImg = dim.get("largeImageKey")).getClass())) {
                            dim.update("largeImageKey", (Object)RandomArrayList.of((Object[])new Object[]{largeImg}));
                        } else {
                            dim.update("largeImageKey", largeImg);
                        }
                        Object smallImg = dim.get("smallImageKey");
                        if (!List.class.isAssignableFrom(smallImg.getClass())) {
                            dim.update("smallImageKey", (Object)RandomArrayList.of((Object[])new Object[]{smallImg}));
                        } else {
                            dim.update("smallImageKey", smallImg);
                        }
                    });
                }
            });
            outputConfig.set("dimension_overrides.dimensions", (Object)commentedConfig);
        }
        if ((entryConfig = (List)newConfig.get("entry")) != null && !entryConfig.isEmpty()) {
            entryConfig.forEach(dim -> {
                Object largeImg = dim.get("largeImageKey");
                if (!List.class.isAssignableFrom(largeImg.getClass())) {
                    dim.update("largeImageKey", (Object)RandomArrayList.of((Object[])new Object[]{largeImg}));
                } else {
                    dim.update("largeImageKey", largeImg);
                }
                Object smallImg = dim.get("smallImageKey");
                if (!List.class.isAssignableFrom(smallImg.getClass())) {
                    dim.update("smallImageKey", (Object)RandomArrayList.of((Object[])new Object[]{smallImg}));
                } else {
                    dim.update("smallImageKey", smallImg);
                }
            });
            outputConfig.set("entry", (Object)entryConfig);
        }
        if (outputConfig.contains("general.version")) {
            outputConfig.update("general.version", (Object)this.getConfigVersion());
        }
        if (outputConfig.contains("version")) {
            outputConfig.update("version", (Object)this.getConfigVersion());
        }
        if (oldConfig.contains("general.clientID")) {
            outputConfig.update("general.applicationID", oldConfig.get("general.clientID"));
        }
    }

    public void appendAdditional() {
    }

    public int getConfigVersion() {
        return 0;
    }
}

