/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.registry.datapack;

import com.teamabnormals.upgrade_aquatic.common.entity.animal.PikeVariant;
import com.teamabnormals.upgrade_aquatic.core.UpgradeAquatic;
import com.teamabnormals.upgrade_aquatic.core.registry.UARegistries;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.Tags;

public final class UAPikeVariants {
    public static final ResourceKey<PikeVariant> AMUR = UAPikeVariants.create("amur");
    public static final ResourceKey<PikeVariant> REDFIN_PICKEREL = UAPikeVariants.create("redfin_pickerel");
    public static final ResourceKey<PikeVariant> BROWN_NORTHERN = UAPikeVariants.create("brown_northern");
    public static final ResourceKey<PikeVariant> MAHOGANY_NORTHERN = UAPikeVariants.create("mahogany_northern");
    public static final ResourceKey<PikeVariant> JADE_NORTHERN = UAPikeVariants.create("jade_northern");
    public static final ResourceKey<PikeVariant> OLIVE_NORTHERN = UAPikeVariants.create("olive_northern");
    public static final ResourceKey<PikeVariant> SPECTRAL = UAPikeVariants.create("spectral");
    public static final ResourceKey<PikeVariant> SPOTTED_BROWN_NORTHERN = UAPikeVariants.create("spotted_brown_northern");
    public static final ResourceKey<PikeVariant> SPOTTED_MAHOGANY_NORTHERN = UAPikeVariants.create("spotted_mahogany_northern");
    public static final ResourceKey<PikeVariant> SPOTTED_JADE_NORTHERN = UAPikeVariants.create("spotted_jade_northern");
    public static final ResourceKey<PikeVariant> SPOTTED_OLIVE_NORTHERN = UAPikeVariants.create("spotted_olive_northern");
    public static final ResourceKey<PikeVariant> SUPERCHARGED = UAPikeVariants.create("supercharged");
    public static final ResourceKey<PikeVariant> OBSIDIAN = UAPikeVariants.create("obsidian");
    public static final ResourceKey<PikeVariant> MUSKELLUNGE = UAPikeVariants.create("muskellunge");
    public static final ResourceKey<PikeVariant> CHAIN_PICKEREL = UAPikeVariants.create("chain_pickerel");
    public static final ResourceKey<PikeVariant> GRASS_PICKEREL = UAPikeVariants.create("grass_pickerel");
    public static final ResourceKey<PikeVariant> BLACK_SOUTHERN = UAPikeVariants.create("black_southern");
    public static final ResourceKey<PikeVariant> EBONY_SOUTHERN = UAPikeVariants.create("ebony_southern");
    public static final ResourceKey<PikeVariant> MUSTARD_SOUTHERN = UAPikeVariants.create("mustard_southern");
    public static final ResourceKey<PikeVariant> LEMON_SOUTHERN = UAPikeVariants.create("lemon_southern");
    public static final ResourceKey<PikeVariant> GOLDEN_SOUTHERN = UAPikeVariants.create("golden_southern");
    public static final ResourceKey<PikeVariant> DEFAULT = REDFIN_PICKEREL;

    public static void bootstrap(BootstrapContext<PikeVariant> context) {
        float small = 1.2f;
        float medium = 1.5f;
        float large = 1.7f;
        float huge = 2.3f;
        int common = 33;
        int uncommon = 25;
        int rare = 15;
        int epic = 5;
        int legendary = 1;
        UAPikeVariants.register(context, AMUR, small, uncommon, (TagKey<Biome>)Tags.Biomes.IS_SWAMP);
        UAPikeVariants.register(context, MUSKELLUNGE, huge, epic, (TagKey<Biome>)BiomeTags.IS_RIVER);
        UAPikeVariants.register(context, REDFIN_PICKEREL, small, common);
        UAPikeVariants.register(context, CHAIN_PICKEREL, small, common, (TagKey<Biome>)BiomeTags.IS_RIVER);
        UAPikeVariants.register(context, GRASS_PICKEREL, small, common, (TagKey<Biome>)Tags.Biomes.IS_SWAMP);
        UAPikeVariants.register(context, BLACK_SOUTHERN, medium, common);
        UAPikeVariants.register(context, EBONY_SOUTHERN, medium, uncommon);
        UAPikeVariants.register(context, MUSTARD_SOUTHERN, medium, rare);
        UAPikeVariants.register(context, LEMON_SOUTHERN, medium, rare);
        UAPikeVariants.register(context, GOLDEN_SOUTHERN, medium, epic);
        UAPikeVariants.register(context, BROWN_NORTHERN, large, common);
        UAPikeVariants.register(context, MAHOGANY_NORTHERN, large, uncommon);
        UAPikeVariants.register(context, JADE_NORTHERN, large, rare);
        UAPikeVariants.register(context, OLIVE_NORTHERN, large, epic);
        UAPikeVariants.register(context, SPOTTED_BROWN_NORTHERN, large, 0);
        UAPikeVariants.register(context, SPOTTED_MAHOGANY_NORTHERN, large, 0);
        UAPikeVariants.register(context, SPOTTED_JADE_NORTHERN, large, 0);
        UAPikeVariants.register(context, SPOTTED_OLIVE_NORTHERN, large, 0);
        UAPikeVariants.register(context, SPECTRAL, large, legendary, true);
        UAPikeVariants.register(context, SUPERCHARGED, large, legendary, true);
        UAPikeVariants.register(context, OBSIDIAN, large, legendary, true);
    }

    private static ResourceKey<PikeVariant> create(String name) {
        return ResourceKey.create(UARegistries.PIKE_VARIANT, (ResourceLocation)UpgradeAquatic.location(name));
    }

    public static void register(BootstrapContext<PikeVariant> context, ResourceKey<PikeVariant> key, float size, int weight, TagKey<Biome> biomes) {
        UAPikeVariants.register(context, key, size, weight, Optional.of(context.lookup(Registries.BIOME).getOrThrow(biomes)), false);
    }

    public static void register(BootstrapContext<PikeVariant> context, ResourceKey<PikeVariant> key, float size, int weight) {
        UAPikeVariants.register(context, key, size, weight, Optional.empty(), false);
    }

    public static void register(BootstrapContext<PikeVariant> context, ResourceKey<PikeVariant> key, float size, int weight, boolean glow) {
        UAPikeVariants.register(context, key, size, weight, Optional.empty(), glow);
    }

    public static void register(BootstrapContext<PikeVariant> context, ResourceKey<PikeVariant> key, float size, int weight, Optional<HolderSet<Biome>> biomes, boolean glow) {
        ResourceLocation texture = key.location().withPrefix("entity/pike/");
        context.register(key, (Object)new PikeVariant(texture, (Component)Component.translatable((String)Util.makeDescriptionId((String)"pike_variant", (ResourceLocation)key.location())).withStyle(UAPikeVariants.getColorForWeight(weight)), size, weight, biomes, glow ? Optional.of(texture.withSuffix("_glow")) : Optional.empty()));
    }

    public static ChatFormatting getColorForWeight(int weight) {
        return switch (weight) {
            case 1 -> ChatFormatting.GOLD;
            case 5 -> ChatFormatting.LIGHT_PURPLE;
            case 15 -> ChatFormatting.BLUE;
            case 25 -> ChatFormatting.GREEN;
            default -> ChatFormatting.GRAY;
        };
    }
}

