/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.registry;

import com.mojang.serialization.Codec;
import com.teamabnormals.upgrade_aquatic.common.levelgen.feature.BeachgrassDunesFeature;
import com.teamabnormals.upgrade_aquatic.common.levelgen.feature.DriftwoodFeature;
import com.teamabnormals.upgrade_aquatic.common.levelgen.feature.FloweringRushFeature;
import com.teamabnormals.upgrade_aquatic.common.levelgen.feature.PickerelweedFeature;
import com.teamabnormals.upgrade_aquatic.common.levelgen.feature.PrismarineCoralFeature;
import com.teamabnormals.upgrade_aquatic.common.levelgen.feature.RiverTreeFeature;
import com.teamabnormals.upgrade_aquatic.common.levelgen.feature.SearocketFeature;
import com.teamabnormals.upgrade_aquatic.common.levelgen.treedecorators.MulberryVinesDecorator;
import com.teamabnormals.upgrade_aquatic.core.UpgradeAquatic;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CarvingMaskPlacement;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class UAFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((ResourceKey)Registries.FEATURE, (String)"upgrade_aquatic");
    public static final DeferredRegister<TreeDecoratorType<?>> TREE_DECORATORS = DeferredRegister.create((ResourceKey)Registries.TREE_DECORATOR_TYPE, (String)"upgrade_aquatic");
    public static final DeferredHolder<Feature<?>, Feature<NoneFeatureConfiguration>> PRISMARINE_CORAL = FEATURES.register("prismarine_coral", () -> new PrismarineCoralFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, Feature<NoneFeatureConfiguration>> PICKERELWEED = FEATURES.register("pickerelweed", () -> new PickerelweedFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, Feature<NoneFeatureConfiguration>> SEAROCKET = FEATURES.register("searocket", () -> new SearocketFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, Feature<NoneFeatureConfiguration>> FLOWERING_RUSH = FEATURES.register("flowering_rush", () -> new FloweringRushFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, Feature<NoneFeatureConfiguration>> DRIFTWOOD = FEATURES.register("driftwood", () -> new DriftwoodFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, Feature<NoneFeatureConfiguration>> DUNES = FEATURES.register("dunes", () -> new BeachgrassDunesFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.CODEC));
    public static final DeferredHolder<Feature<?>, Feature<TreeConfiguration>> RIVER_TREE = FEATURES.register("river_tree", () -> new RiverTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.CODEC));
    public static final DeferredHolder<TreeDecoratorType<?>, TreeDecoratorType<?>> MULBERRY_VINES = TREE_DECORATORS.register("mulberry_vines", () -> new TreeDecoratorType(MulberryVinesDecorator.CODEC));

    public static final class UAPlacedFeatures {
        public static final ResourceKey<PlacedFeature> ORE_AMMONITE = UAPlacedFeatures.createKey("ore_ammonite");
        public static final ResourceKey<PlacedFeature> BEACHGRASS_DUNES = UAPlacedFeatures.createKey("beachgrass_dunes");
        public static final ResourceKey<PlacedFeature> RIVER_TREE = UAPlacedFeatures.createKey("river_tree");
        public static final ResourceKey<PlacedFeature> PRISMARINE_CORAL = UAPlacedFeatures.createKey("prismarine_coral");
        public static final ResourceKey<PlacedFeature> PATCH_SEAROCKET = UAPlacedFeatures.createKey("patch_searocket");
        public static final ResourceKey<PlacedFeature> PATCH_PICKERELWEED = UAPlacedFeatures.createKey("patch_pickerelweed");
        public static final ResourceKey<PlacedFeature> PATCH_PICKERELWEED_EXTRA = UAPlacedFeatures.createKey("patch_pickerelweed_extra");
        public static final ResourceKey<PlacedFeature> PATCH_FLOWERING_RUSH = UAPlacedFeatures.createKey("patch_flowering_rush");
        public static final ResourceKey<PlacedFeature> DRIFTWOOD_OCEAN = UAPlacedFeatures.createKey("driftwood_ocean");
        public static final ResourceKey<PlacedFeature> DRIFTWOOD_BEACH = UAPlacedFeatures.createKey("driftwood_beach");
        public static final ResourceKey<PlacedFeature> DRIFTWOOD_RIVER = UAPlacedFeatures.createKey("driftwood_river");
        public static final ResourceKey<PlacedFeature> DRIFTWOOD_SWAMP = UAPlacedFeatures.createKey("driftwood_swamp");
        public static final ResourceKey<PlacedFeature> DRIFTWOOD_EXTRA = UAPlacedFeatures.createKey("driftwood_extra");

        public static void bootstrap(BootstrapContext<PlacedFeature> context) {
            UAPlacedFeatures.register(context, ORE_AMMONITE, UAConfiguredFeatures.ORE_AMMONITE, UAPlacedFeatures.commonOrePlacement(30, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)73))));
            UAPlacedFeatures.register(context, BEACHGRASS_DUNES, UAConfiguredFeatures.BEACHGRASS_DUNES, VegetationPlacements.worldSurfaceSquaredWithCount((int)10));
            UAPlacedFeatures.register(context, RIVER_TREE, UAConfiguredFeatures.RIVER_TREE, VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)1, (float)0.5f, (int)2)));
            UAPlacedFeatures.register(context, PRISMARINE_CORAL, UAConfiguredFeatures.PRISMARINE_CORAL, new PlacementModifier[]{CarvingMaskPlacement.forStep((GenerationStep.Carving)GenerationStep.Carving.AIR), RarityFilter.onAverageOnceEvery((int)256), BiomeFilter.biome()});
            UAPlacedFeatures.register(context, PATCH_SEAROCKET, UAConfiguredFeatures.PATCH_SEAROCKET, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)15), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
            UAPlacedFeatures.register(context, PATCH_PICKERELWEED, UAConfiguredFeatures.PATCH_PICKERELWEED, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
            UAPlacedFeatures.register(context, PATCH_PICKERELWEED_EXTRA, UAConfiguredFeatures.PATCH_PICKERELWEED, new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
            UAPlacedFeatures.register(context, PATCH_FLOWERING_RUSH, UAConfiguredFeatures.PATCH_FLOWERING_RUSH, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)6), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
            UAPlacedFeatures.register(context, DRIFTWOOD_OCEAN, UAConfiguredFeatures.DRIFTWOOD, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)36), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
            UAPlacedFeatures.register(context, DRIFTWOOD_BEACH, UAConfiguredFeatures.DRIFTWOOD, new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)5), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
            UAPlacedFeatures.register(context, DRIFTWOOD_RIVER, UAConfiguredFeatures.DRIFTWOOD, VegetationPlacements.worldSurfaceSquaredWithCount((int)6));
            UAPlacedFeatures.register(context, DRIFTWOOD_SWAMP, UAConfiguredFeatures.DRIFTWOOD, VegetationPlacements.worldSurfaceSquaredWithCount((int)4));
            UAPlacedFeatures.register(context, DRIFTWOOD_EXTRA, UAConfiguredFeatures.DRIFTWOOD, VegetationPlacements.worldSurfaceSquaredWithCount((int)5));
        }

        private static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
            return List.of(p_195347_, InSquarePlacement.spread(), p_195348_, BiomeFilter.biome());
        }

        private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier modifier) {
            return UAPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.of((int)count), modifier);
        }

        public static ResourceKey<PlacedFeature> createKey(String name) {
            return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)UpgradeAquatic.location(name));
        }

        public static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> feature, List<PlacementModifier> modifiers) {
            context.register(key, (Object)new PlacedFeature((Holder)context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(feature), modifiers));
        }

        public static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> feature, PlacementModifier ... modifiers) {
            UAPlacedFeatures.register(context, key, feature, List.of(modifiers));
        }
    }

    public static final class UAConfiguredFeatures {
        public static final ResourceKey<ConfiguredFeature<?, ?>> RIVER_TREE = UAConfiguredFeatures.createKey("river_tree");
        public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_AMMONITE = UAConfiguredFeatures.createKey("ore_ammonite");
        public static final ResourceKey<ConfiguredFeature<?, ?>> BEACHGRASS_DUNES = UAConfiguredFeatures.createKey("beachgrass_dunes");
        public static final ResourceKey<ConfiguredFeature<?, ?>> PRISMARINE_CORAL = UAConfiguredFeatures.createKey("prismarine_coral");
        public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_SEAROCKET = UAConfiguredFeatures.createKey("patch_searocket");
        public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_PICKERELWEED = UAConfiguredFeatures.createKey("patch_pickerelweed");
        public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_FLOWERING_RUSH = UAConfiguredFeatures.createKey("patch_flowering_rush");
        public static final ResourceKey<ConfiguredFeature<?, ?>> DRIFTWOOD = UAConfiguredFeatures.createKey("driftwood");

        public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
            UAConfiguredFeatures.register(context, RIVER_TREE, (Feature)RIVER_TREE.get(), Configs.RIVER_TREE_CONFIG);
            UAConfiguredFeatures.register(context, ORE_AMMONITE, Feature.ORE, new OreConfiguration((RuleTest)new BlockMatchTest(Blocks.STONE), ((Block)UABlocks.EMBEDDED_AMMONITE.get()).defaultBlockState(), 3));
            UAConfiguredFeatures.register(context, BEACHGRASS_DUNES, (Feature)DUNES.get(), FeatureConfiguration.NONE);
            UAConfiguredFeatures.register(context, PRISMARINE_CORAL, (Feature)PRISMARINE_CORAL.get(), FeatureConfiguration.NONE);
            UAConfiguredFeatures.register(context, PATCH_SEAROCKET, (Feature)SEAROCKET.get(), FeatureConfiguration.NONE);
            UAConfiguredFeatures.register(context, PATCH_PICKERELWEED, (Feature)PICKERELWEED.get(), FeatureConfiguration.NONE);
            UAConfiguredFeatures.register(context, PATCH_FLOWERING_RUSH, (Feature)FLOWERING_RUSH.get(), FeatureConfiguration.NONE);
            UAConfiguredFeatures.register(context, DRIFTWOOD, (Feature)DRIFTWOOD.get(), FeatureConfiguration.NONE);
        }

        public static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
            return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)UpgradeAquatic.location(name));
        }

        public static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC config) {
            context.register(key, (Object)new ConfiguredFeature(feature, config));
        }
    }

    public static final class Configs {
        public static final TreeConfiguration RIVER_TREE_CONFIG = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)UABlocks.RIVER_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(3, 1, 1), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)UABlocks.RIVER_LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0), 0), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0)).ignoreVines().decorators(List.of(new MulberryVinesDecorator())).build();
    }
}

