/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.other;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamabnormals.upgrade_aquatic.common.entity.monster.Thrasher;
import com.teamabnormals.upgrade_aquatic.core.UAConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="upgrade_aquatic", value={Dist.CLIENT})
public class UAClientEvents {
    @SubscribeEvent
    public static void onEntityRenderPre(RenderLivingEvent.Pre<?, ?> event) {
        LocalPlayer clientPlayer;
        Entity entity;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof LocalPlayer && (entity = (clientPlayer = (LocalPlayer)livingEntity).getVehicle()) instanceof Thrasher) {
            Thrasher thrasher = (Thrasher)entity;
            ObfuscationReflectionHelper.setPrivateValue(LivingEntity.class, (Object)clientPlayer, (Object)Float.valueOf(1.0f), (String)"swimAmount");
            ObfuscationReflectionHelper.setPrivateValue(LivingEntity.class, (Object)clientPlayer, (Object)Float.valueOf(1.0f), (String)"swimAmountO");
            clientPlayer.setXRot(0.0f);
            clientPlayer.setYRot(thrasher.getYRot() + 90.0f);
            clientPlayer.yBodyRot = thrasher.yBodyRot + 90.0f;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerRenderPre(RenderPlayerEvent.Pre event) {
        PoseStack stack = event.getPoseStack();
        stack.pushPose();
        Entity entity = event.getEntity().getVehicle();
        if (entity instanceof Thrasher) {
            Thrasher thrasher = (Thrasher)entity;
            double dx = Math.cos((double)Mth.lerp((float)event.getPartialTick(), (float)thrasher.yRotO, (float)thrasher.getYRot()) * Math.PI / 180.0);
            double dz = Math.sin((double)Mth.lerp((float)event.getPartialTick(), (float)thrasher.yRotO, (float)thrasher.getYRot()) * Math.PI / 180.0);
            stack.translate((float)dx, 0.0f, (float)dz);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerRenderPost(RenderPlayerEvent.Post event) {
        event.getPoseStack().popPose();
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        String id;
        Item item = event.getItemStack().getItem();
        ResourceLocation name = BuiltInRegistries.ITEM.getKey((Object)item);
        Player player = event.getEntity();
        if (name.equals((Object)BuiltInRegistries.ITEM.getDefaultKey()) || player == null) {
            return;
        }
        if (player.getAbilities().instabuild && ((Boolean)UAConfig.CLIENT.showUnobtainableDescription.get()).booleanValue() && name.getNamespace().equals("upgrade_aquatic") && (id = name.getPath()).contains("jelly")) {
            event.getToolTip().add(Component.translatable((String)"tooltip.upgrade_aquatic.unobtainable").withStyle(ChatFormatting.GRAY));
        }
    }
}

