/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.data.server;

import com.teamabnormals.blueprint.core.data.server.BlueprintRecipeProvider;
import com.teamabnormals.boatload.core.api.BoatloadBoatType;
import com.teamabnormals.boatload.core.data.server.BoatloadRecipeProvider;
import com.teamabnormals.upgrade_aquatic.common.block.CoralType;
import com.teamabnormals.upgrade_aquatic.core.UpgradeAquatic;
import com.teamabnormals.upgrade_aquatic.core.other.UABlockFamilies;
import com.teamabnormals.upgrade_aquatic.core.other.UAConstants;
import com.teamabnormals.upgrade_aquatic.core.other.tags.UAItemTags;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import com.teamabnormals.upgrade_aquatic.integration.boatload.UABoatTypes;
import com.teamabnormals.woodworks.core.data.server.WoodworksRecipeProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class UARecipeProvider
extends BlueprintRecipeProvider {
    public UARecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super("upgrade_aquatic", output, provider);
    }

    public void buildRecipes(RecipeOutput output) {
        this.conversionRecipe(output, (ItemLike)Items.PINK_DYE, (ItemLike)UABlocks.PINK_SEAROCKET, "pink_dye");
        this.conversionRecipe(output, (ItemLike)Items.WHITE_DYE, (ItemLike)UABlocks.WHITE_SEAROCKET, "white_dye");
        this.conversionRecipe(output, (ItemLike)Items.CYAN_DYE, (ItemLike)UABlocks.PICKERELWEED, "cyan_dye");
        this.conversionRecipe(output, (ItemLike)Items.PINK_DYE, (ItemLike)UABlocks.FLOWERING_RUSH, "pink_dye", 2);
        this.conversionRecipe(output, (ItemLike)Items.MAGENTA_DYE, (ItemLike)UAItems.MULBERRY, "magenta_dye");
        UARecipeProvider.foodCookingRecipes((RecipeOutput)output, UAItems.PIKE, UAItems.COOKED_PIKE);
        UARecipeProvider.foodCookingRecipes((RecipeOutput)output, UAItems.PERCH, UAItems.COOKED_PERCH);
        UARecipeProvider.foodCookingRecipes((RecipeOutput)output, UAItems.LIONFISH, UAItems.COOKED_LIONFISH);
        UARecipeProvider.foodCookingRecipes((RecipeOutput)output, UABlocks.PICKERELWEED, UAItems.BOILED_PICKERELWEED);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, UABlocks.BEDROLL).define(Character.valueOf('#'), (ItemLike)Items.LEATHER).define(Character.valueOf('X'), (ItemLike)Items.WHITE_WOOL).pattern("##X").pattern("###").group("bedroll").unlockedBy(UARecipeProvider.getHasName((ItemLike)Items.LEATHER), UARecipeProvider.has((ItemLike)Items.LEATHER)).save(output);
        this.oreRecipes(output, List.of(UABlocks.EMBEDDED_AMMONITE), RecipeCategory.MISC, (ItemLike)Items.NAUTILUS_SHELL, 1.0f, 200, "nautilus_shell");
        this.storageRecipes(output, RecipeCategory.MISC, (ItemLike)Items.TURTLE_SCUTE, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.SCUTE_BLOCK);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, UABlocks.SCUTE_SHINGLES, (int)8).define(Character.valueOf('#'), (ItemLike)Blocks.STONE_BRICKS).define(Character.valueOf('S'), (ItemLike)Items.TURTLE_SCUTE).pattern("###").pattern("#S#").pattern("###").unlockedBy("has_scute", UARecipeProvider.has((ItemLike)Items.TURTLE_SCUTE)).save(output);
        UARecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)UABlockFamilies.SCUTE_SHINGLES_FAMILY, (FeatureFlagSet)FeatureFlags.REGISTRY.allFlags());
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.SCUTE_SHINGLE_SLAB, (ItemLike)UABlocks.SCUTE_SHINGLES, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.SCUTE_SHINGLE_STAIRS, (ItemLike)UABlocks.SCUTE_SHINGLES);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)UABlocks.SCUTE_SHINGLE_WALL, (ItemLike)UABlocks.SCUTE_SHINGLES);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.CHISELED_SCUTE_SHINGLES, (ItemLike)UABlocks.SCUTE_SHINGLES);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, UABlocks.SCUTE_PAVEMENT, (int)4).define(Character.valueOf('#'), UABlocks.SCUTE_SHINGLES).pattern("##").pattern("##").unlockedBy("has_scute_shingles", UARecipeProvider.has(UABlocks.SCUTE_SHINGLES)).save(output);
        UARecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)UABlockFamilies.SCUTE_PAVEMENT_FAMILY, (FeatureFlagSet)FeatureFlags.REGISTRY.allFlags());
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.SCUTE_PAVEMENT_SLAB, (ItemLike)UABlocks.SCUTE_PAVEMENT, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.SCUTE_PAVEMENT_STAIRS, (ItemLike)UABlocks.SCUTE_PAVEMENT);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)UABlocks.SCUTE_PAVEMENT_WALL, (ItemLike)UABlocks.SCUTE_PAVEMENT);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.SCUTE_PAVEMENT, (ItemLike)UABlocks.SCUTE_SHINGLES);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.SCUTE_PAVEMENT_SLAB, (ItemLike)UABlocks.SCUTE_SHINGLES, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.SCUTE_PAVEMENT_STAIRS, (ItemLike)UABlocks.SCUTE_SHINGLES);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.SCUTE_PAVEMENT_WALL, (ItemLike)UABlocks.SCUTE_SHINGLES);
        this.storageRecipes(output, RecipeCategory.MISC, (ItemLike)UAItems.THRASHER_TOOTH, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.TOOTH_BLOCK);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, UABlocks.TOOTH_BRICKS, (int)8).define(Character.valueOf('#'), (ItemLike)Blocks.STONE_BRICKS).define(Character.valueOf('S'), UAItems.THRASHER_TOOTH).pattern("###").pattern("#S#").pattern("###").unlockedBy("has_thrasher_tooth", UARecipeProvider.has(UAItems.THRASHER_TOOTH)).save(output);
        UARecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)UABlockFamilies.TOOTH_BRICKS_FAMILY, (FeatureFlagSet)FeatureFlags.REGISTRY.allFlags());
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.TOOTH_BRICK_SLAB, (ItemLike)UABlocks.TOOTH_BRICKS, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.TOOTH_BRICK_STAIRS, (ItemLike)UABlocks.TOOTH_BRICKS);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)UABlocks.TOOTH_BRICK_WALL, (ItemLike)UABlocks.TOOTH_BRICKS);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.CHISELED_TOOTH_BRICKS, (ItemLike)UABlocks.TOOTH_BRICKS);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, UABlocks.TOOTH_TILES, (int)4).define(Character.valueOf('#'), UABlocks.TOOTH_BRICKS).pattern("##").pattern("##").unlockedBy("has_tooth_bricks", UARecipeProvider.has(UABlocks.TOOTH_BRICKS)).save(output);
        UARecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)UABlockFamilies.TOOTH_TILES_FAMILY, (FeatureFlagSet)FeatureFlags.REGISTRY.allFlags());
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.TOOTH_TILE_SLAB, (ItemLike)UABlocks.TOOTH_TILES, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.TOOTH_TILE_STAIRS, (ItemLike)UABlocks.TOOTH_TILES);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)UABlocks.TOOTH_TILE_WALL, (ItemLike)UABlocks.TOOTH_TILES);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.TOOTH_TILES, (ItemLike)UABlocks.TOOTH_BRICKS);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.TOOTH_TILE_SLAB, (ItemLike)UABlocks.TOOTH_BRICKS, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.TOOTH_TILE_STAIRS, (ItemLike)UABlocks.TOOTH_BRICKS);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.TOOTH_TILE_WALL, (ItemLike)UABlocks.TOOTH_BRICKS);
        UARecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)UABlockFamilies.DRIFTWOOD_PLANKS_FAMILY, (FeatureFlagSet)FeatureFlags.REGISTRY.allFlags());
        UARecipeProvider.planksFromLogs((RecipeOutput)output, UABlocks.DRIFTWOOD_PLANKS, UAItemTags.DRIFTWOOD_LOGS, (int)4);
        UARecipeProvider.woodFromLogs((RecipeOutput)output, UABlocks.DRIFTWOOD, UABlocks.DRIFTWOOD_LOG);
        UARecipeProvider.woodFromLogs((RecipeOutput)output, UABlocks.STRIPPED_DRIFTWOOD, UABlocks.STRIPPED_DRIFTWOOD_LOG);
        UARecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)((ItemLike)UABlocks.DRIFTWOOD_HANGING_SIGNS.getFirst()), UABlocks.STRIPPED_DRIFTWOOD_LOG);
        BoatloadRecipeProvider.boatRecipes((RecipeOutput)output, (BoatloadBoatType)UABoatTypes.DRIFTWOOD);
        WoodworksRecipeProvider.baseRecipes((RecipeOutput)output, (ItemLike)((ItemLike)UABlocks.DRIFTWOOD_PLANKS.get()), (ItemLike)((ItemLike)UABlocks.DRIFTWOOD_SLAB.get()), (ItemLike)((ItemLike)UABlocks.DRIFTWOOD_BOARDS.get()), (ItemLike)((ItemLike)UABlocks.DRIFTWOOD_BOOKSHELF.get()), (ItemLike)((ItemLike)UABlocks.CHISELED_DRIFTWOOD_BOOKSHELF.get()), (ItemLike)((ItemLike)UABlocks.DRIFTWOOD_LADDER.get()), (ItemLike)((ItemLike)UABlocks.DRIFTWOOD_BEEHIVE.get()), (ItemLike)((ItemLike)UABlocks.DRIFTWOOD_CHEST.get()), (ItemLike)((ItemLike)UABlocks.TRAPPED_DRIFTWOOD_CHEST.get()), (String)"upgrade_aquatic");
        WoodworksRecipeProvider.sawmillRecipes((RecipeOutput)output, (BlockFamily)UABlockFamilies.DRIFTWOOD_PLANKS_FAMILY, UAItemTags.DRIFTWOOD_LOGS, (ItemLike)((ItemLike)UABlocks.DRIFTWOOD_BOARDS.get()), (ItemLike)((ItemLike)UABlocks.DRIFTWOOD_LADDER.get()), (String)"upgrade_aquatic");
        UARecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)UABlockFamilies.RIVER_PLANKS_FAMILY, (FeatureFlagSet)FeatureFlags.REGISTRY.allFlags());
        UARecipeProvider.planksFromLogs((RecipeOutput)output, UABlocks.RIVER_PLANKS, UAItemTags.RIVER_LOGS, (int)4);
        UARecipeProvider.woodFromLogs((RecipeOutput)output, UABlocks.RIVER_WOOD, UABlocks.RIVER_LOG);
        UARecipeProvider.woodFromLogs((RecipeOutput)output, UABlocks.STRIPPED_RIVER_WOOD, UABlocks.STRIPPED_RIVER_LOG);
        UARecipeProvider.hangingSign((RecipeOutput)output, (ItemLike)((ItemLike)UABlocks.RIVER_HANGING_SIGNS.getFirst()), UABlocks.STRIPPED_RIVER_LOG);
        BoatloadRecipeProvider.boatRecipes((RecipeOutput)output, (BoatloadBoatType)UABoatTypes.RIVER);
        WoodworksRecipeProvider.baseRecipes((RecipeOutput)output, (ItemLike)((ItemLike)UABlocks.RIVER_PLANKS.get()), (ItemLike)((ItemLike)UABlocks.RIVER_SLAB.get()), (ItemLike)((ItemLike)UABlocks.RIVER_BOARDS.get()), (ItemLike)((ItemLike)UABlocks.RIVER_BOOKSHELF.get()), (ItemLike)((ItemLike)UABlocks.CHISELED_RIVER_BOOKSHELF.get()), (ItemLike)((ItemLike)UABlocks.RIVER_LADDER.get()), (ItemLike)((ItemLike)UABlocks.RIVER_BEEHIVE.get()), (ItemLike)((ItemLike)UABlocks.RIVER_CHEST.get()), (ItemLike)((ItemLike)UABlocks.TRAPPED_RIVER_CHEST.get()), (String)"upgrade_aquatic");
        WoodworksRecipeProvider.sawmillRecipes((RecipeOutput)output, (BlockFamily)UABlockFamilies.RIVER_PLANKS_FAMILY, UAItemTags.RIVER_LOGS, (ItemLike)((ItemLike)UABlocks.RIVER_BOARDS.get()), (ItemLike)((ItemLike)UABlocks.RIVER_LADDER.get()), (String)"upgrade_aquatic");
        WoodworksRecipeProvider.conditionalLeafPileRecipes((RecipeOutput)output, UABlocks.RIVER_LEAVES, UABlocks.RIVER_LEAF_PILE, (String)"upgrade_aquatic");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, UABlocks.CORALSTONE, (int)8).define(Character.valueOf('#'), (ItemLike)Blocks.STONE_BRICKS).define(Character.valueOf('S'), (ItemLike)Items.NAUTILUS_SHELL).pattern("###").pattern("#S#").pattern("###").unlockedBy("has_nautilus_shell", UARecipeProvider.has((ItemLike)Items.NAUTILUS_SHELL)).save(output);
        UARecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)UABlockFamilies.CORALSTONE_FAMILY, (FeatureFlagSet)FeatureFlags.REGISTRY.allFlags());
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.CORALSTONE_SLAB, (ItemLike)UABlocks.CORALSTONE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.CORALSTONE_STAIRS, (ItemLike)UABlocks.CORALSTONE);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)UABlocks.CORALSTONE_WALL, (ItemLike)UABlocks.CORALSTONE);
        UARecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)UABlockFamilies.DEAD_CORALSTONE_FAMILY, (FeatureFlagSet)FeatureFlags.REGISTRY.allFlags());
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.DEAD_CORALSTONE_SLAB, (ItemLike)UABlocks.DEAD_CORALSTONE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.DEAD_CORALSTONE_STAIRS, (ItemLike)UABlocks.DEAD_CORALSTONE);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)UABlocks.DEAD_CORALSTONE_WALL, (ItemLike)UABlocks.DEAD_CORALSTONE);
        UARecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)UABlockFamilies.ELDER_PRISMARINE_CORALSTONE_FAMILY, (FeatureFlagSet)FeatureFlags.REGISTRY.allFlags());
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.ELDER_PRISMARINE_CORALSTONE_SLAB, (ItemLike)UABlocks.ELDER_PRISMARINE_CORALSTONE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.ELDER_PRISMARINE_CORALSTONE_STAIRS, (ItemLike)UABlocks.ELDER_PRISMARINE_CORALSTONE);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)UABlocks.ELDER_PRISMARINE_CORALSTONE_WALL, (ItemLike)UABlocks.ELDER_PRISMARINE_CORALSTONE);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, UAItems.PRISMARINE_ROD).define(Character.valueOf('#'), (ItemLike)Items.PRISMARINE_SHARD).pattern("#").pattern("#").unlockedBy("has_prismarine_shard", UARecipeProvider.has((ItemLike)Items.PRISMARINE_SHARD)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Items.TRIDENT).define(Character.valueOf('#'), UAItems.PRISMARINE_ROD).define(Character.valueOf('X'), UAItems.THRASHER_TOOTH).pattern(" XX").pattern(" #X").pattern("#  ").unlockedBy("has_prismarine_rod", UARecipeProvider.has(UAItems.PRISMARINE_ROD)).unlockedBy("has_thrasher_tooth", UARecipeProvider.has(UAItems.THRASHER_TOOTH)).save(output, UpgradeAquatic.location("trident"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, UABlocks.TOOTH_LANTERN).define(Character.valueOf('#'), UAItems.THRASHER_TOOTH).define(Character.valueOf('X'), (ItemLike)Items.PRISMARINE_CRYSTALS).pattern("#").pattern("X").pattern("#").unlockedBy("has_thrasher_tooth", UARecipeProvider.has(UAItems.THRASHER_TOOTH)).save(output);
        UARecipeProvider.doorBuilder(UABlocks.TOOTH_DOOR, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{UAItems.THRASHER_TOOTH})).unlockedBy(UARecipeProvider.getHasName(UAItems.THRASHER_TOOTH), UARecipeProvider.has(UAItems.THRASHER_TOOTH)).save(output);
        UARecipeProvider.twoByTwoPacker((RecipeOutput)output, (RecipeCategory)RecipeCategory.REDSTONE, UABlocks.TOOTH_TRAPDOOR, UAItems.THRASHER_TOOTH);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, UAItems.MULBERRY_JAM_BOTTLE, (int)4).requires(UABlocks.MULBERRY_JAM_BLOCK).requires((ItemLike)Items.GLASS_BOTTLE, 4).unlockedBy("has_mulberry_jam_block", UARecipeProvider.has(UABlocks.MULBERRY_JAM_BLOCK)).save(output, this.getModConversionRecipeName((ItemLike)UAItems.MULBERRY_JAM_BOTTLE, (ItemLike)UABlocks.MULBERRY_JAM_BLOCK));
        UARecipeProvider.twoByTwoPacker((RecipeOutput)output, (RecipeCategory)RecipeCategory.REDSTONE, UABlocks.MULBERRY_JAM_BLOCK, UAItems.MULBERRY_JAM_BOTTLE);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, UAItems.MULBERRY_BREAD).requires((ItemLike)Items.BREAD).requires(UAItems.MULBERRY_JAM_BOTTLE).unlockedBy("has_mulberry_jam_bottle", UARecipeProvider.has(UAItems.MULBERRY_JAM_BOTTLE)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, UAItems.MULBERRY_PIE).requires(UAItems.MULBERRY).requires((ItemLike)Items.SUGAR).requires(Tags.Items.EGGS).unlockedBy("has_mulberry", UARecipeProvider.has(UAItems.MULBERRY)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, UAItems.MULBERRY_JAM_BOTTLE).requires(UAItems.MULBERRY).requires((ItemLike)Items.SUGAR).requires((ItemLike)Items.GLASS_BOTTLE).unlockedBy("has_mulberry", UARecipeProvider.has(UAItems.MULBERRY)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.DARK_PRISMARINE).define(Character.valueOf('S'), (ItemLike)Items.PRISMARINE_SHARD).define(Character.valueOf('I'), (ItemLike)Items.INK_SAC).pattern("SSS").pattern("SIS").pattern("SSS").unlockedBy("has_prismarine_shard", UARecipeProvider.has((ItemLike)Items.PRISMARINE_SHARD)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, UABlocks.LUMINOUS_PRISMARINE).define(Character.valueOf('S'), (ItemLike)Items.PRISMARINE_SHARD).define(Character.valueOf('I'), (ItemLike)Items.GLOW_INK_SAC).pattern("SSS").pattern("SIS").pattern("SSS").unlockedBy("has_prismarine_shard", UARecipeProvider.has((ItemLike)Items.PRISMARINE_SHARD)).save(output);
        UARecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)UABlockFamilies.LUMINOUS_PRISMARINE_FAMILY, (FeatureFlagSet)FeatureFlags.REGISTRY.allFlags());
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.LUMINOUS_PRISMARINE_SLAB, (ItemLike)UABlocks.LUMINOUS_PRISMARINE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.LUMINOUS_PRISMARINE_STAIRS, (ItemLike)UABlocks.LUMINOUS_PRISMARINE);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, UABlocks.BEACHGRASS_THATCH, (int)4).define(Character.valueOf('#'), UABlocks.BEACHGRASS).pattern("##").pattern("##").unlockedBy("has_beachgrass", UARecipeProvider.has(UABlocks.BEACHGRASS)).save(output);
        UARecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)UABlockFamilies.BEACHGRASS_THATCH_FAMILY, (FeatureFlagSet)FeatureFlags.REGISTRY.allFlags());
        this.conversionRecipe(output, (ItemLike)Items.BONE_MEAL, (ItemLike)UAItems.THRASHER_TOOTH, "bone_meal", 6);
        UARecipeProvider.threeByThreePacker((RecipeOutput)output, (RecipeCategory)RecipeCategory.MISC, UAItems.MUSIC_DISC_ATLANTIS, UAItems.DISC_FRAGMENT_ATLANTIS);
        CoralType.values().forEach(coralType -> {
            BlockFamily family = coralType.coralstoneFamily();
            this.coralBlockRecipe(output, (ItemLike)coralType.coralBlock().get(), (ItemLike)coralType.coral().get(), coralType.itemTag());
            this.coralBlockRecipe(output, (ItemLike)coralType.deadCoralBlock().get(), (ItemLike)coralType.deadCoral().get(), coralType.deadItemTag());
            UARecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)coralType.coralstoneFamily(), (FeatureFlagSet)FeatureFlags.REGISTRY.allFlags());
            this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)family.get(BlockFamily.Variant.SLAB), (ItemLike)family.getBaseBlock(), 2);
            this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)family.get(BlockFamily.Variant.STAIRS), (ItemLike)family.getBaseBlock());
            this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)family.get(BlockFamily.Variant.WALL), (ItemLike)family.getBaseBlock());
        });
        this.storageRecipes(output, RecipeCategory.MISC, (ItemLike)Items.KELP, RecipeCategory.DECORATIONS, (ItemLike)UABlocks.KELP_BLOCK);
        this.storageRecipes(output, RecipeCategory.MISC, (ItemLike)UABlocks.PICKERELWEED, RecipeCategory.DECORATIONS, (ItemLike)UABlocks.PICKERELWEED_BLOCK);
        this.conditionalStorageRecipes(output, (ICondition)new ModLoadedCondition("berry_good"), RecipeCategory.MISC, (ItemLike)UAItems.MULBERRY, RecipeCategory.DECORATIONS, (ItemLike)UABlocks.MULBERRY_PUNNET);
        this.storageRecipesWithCustomUnpacking(output, RecipeCategory.FOOD, (ItemLike)UAItems.BOILED_PICKERELWEED, RecipeCategory.DECORATIONS, (ItemLike)UABlocks.BOILED_PICKERELWEED_BLOCK, "boiled_pickerelweed_from_boiled_pickerelweed_block", null);
        this.storageRecipesWithCustomUnpacking(output, RecipeCategory.MISC, (ItemLike)UAItems.PRISMARINE_ROD, RecipeCategory.DECORATIONS, (ItemLike)UABlocks.PRISMARINE_ROD_BUNDLE, "prismarine_rod_from_prismarine_rod_bundle", null);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, UABlocks.KELPY_COBBLESTONE).requires((ItemLike)Blocks.COBBLESTONE).requires((ItemLike)Items.KELP).group("kelpy_cobblestone").unlockedBy("has_kelp", UARecipeProvider.has((ItemLike)Items.KELP)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, UABlocks.KELPY_STONE_BRICKS).requires((ItemLike)Blocks.STONE_BRICKS).requires((ItemLike)Items.KELP).group("kelpy_stone_bricks").unlockedBy("has_kelp", UARecipeProvider.has((ItemLike)Items.KELP)).save(output);
        UARecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)UABlockFamilies.KELPY_COBBLESTONE_FAMILY, (FeatureFlagSet)FeatureFlags.REGISTRY.allFlags());
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.KELPY_COBBLESTONE_SLAB, (ItemLike)UABlocks.KELPY_COBBLESTONE, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.KELPY_COBBLESTONE_STAIRS, (ItemLike)UABlocks.KELPY_COBBLESTONE);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)UABlocks.KELPY_COBBLESTONE_WALL, (ItemLike)UABlocks.KELPY_COBBLESTONE);
        UARecipeProvider.generateRecipes((RecipeOutput)output, (BlockFamily)UABlockFamilies.KELPY_STONE_BRICKS_FAMILY, (FeatureFlagSet)FeatureFlags.REGISTRY.allFlags());
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.KELPY_STONE_BRICK_SLAB, (ItemLike)UABlocks.KELPY_STONE_BRICKS, 2);
        this.stonecutterRecipe(output, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.KELPY_STONE_BRICK_STAIRS, (ItemLike)UABlocks.KELPY_STONE_BRICKS);
        this.stonecutterRecipe(output, RecipeCategory.DECORATIONS, (ItemLike)UABlocks.KELPY_STONE_BRICK_WALL, (ItemLike)UABlocks.KELPY_STONE_BRICKS);
        ModLoadedCondition cnc = new ModLoadedCondition("caverns_and_chasms");
        UARecipeProvider.conditionalRecipe((RecipeOutput)output, (RecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, UABlocks.KELPY_COBBLESTONE_BRICKS, (int)4).define(Character.valueOf('#'), UABlocks.KELPY_COBBLESTONE).pattern("##").pattern("##").unlockedBy(UARecipeProvider.getHasName(UABlocks.KELPY_COBBLESTONE), UARecipeProvider.has(UABlocks.KELPY_COBBLESTONE)), (ICondition[])new ICondition[]{cnc});
        UARecipeProvider.conditionalRecipe((RecipeOutput)output, (RecipeBuilder)UARecipeProvider.stairBuilder(UABlocks.KELPY_COBBLESTONE_BRICK_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{UABlocks.KELPY_COBBLESTONE_BRICKS})).unlockedBy(UARecipeProvider.getHasName(UABlocks.KELPY_COBBLESTONE_BRICKS), UARecipeProvider.has(UABlocks.KELPY_COBBLESTONE_BRICKS)), (ICondition[])new ICondition[]{cnc});
        UARecipeProvider.conditionalRecipe((RecipeOutput)output, (RecipeBuilder)UARecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, UABlocks.KELPY_COBBLESTONE_BRICK_SLAB, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{UABlocks.KELPY_COBBLESTONE_BRICKS})).unlockedBy(UARecipeProvider.getHasName(UABlocks.KELPY_COBBLESTONE_BRICKS), UARecipeProvider.has(UABlocks.KELPY_COBBLESTONE_BRICKS)), (ICondition[])new ICondition[]{cnc});
        UARecipeProvider.conditionalRecipe((RecipeOutput)output, (RecipeBuilder)UARecipeProvider.wallBuilder((RecipeCategory)RecipeCategory.DECORATIONS, UABlocks.KELPY_COBBLESTONE_BRICK_WALL, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{UABlocks.KELPY_COBBLESTONE_BRICKS})).unlockedBy(UARecipeProvider.getHasName(UABlocks.KELPY_COBBLESTONE_BRICKS), UARecipeProvider.has(UABlocks.KELPY_COBBLESTONE_BRICKS)), (ICondition[])new ICondition[]{cnc});
        this.conditionalStonecutterRecipe(output, (ICondition)cnc, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.KELPY_COBBLESTONE_BRICK_SLAB, (ItemLike)UABlocks.KELPY_COBBLESTONE_BRICKS, 2);
        this.conditionalStonecutterRecipe(output, (ICondition)cnc, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.KELPY_COBBLESTONE_BRICK_STAIRS, (ItemLike)UABlocks.KELPY_COBBLESTONE_BRICKS);
        this.conditionalStonecutterRecipe(output, (ICondition)cnc, RecipeCategory.DECORATIONS, (ItemLike)UABlocks.KELPY_COBBLESTONE_BRICK_WALL, (ItemLike)UABlocks.KELPY_COBBLESTONE_BRICKS);
        this.conditionalStonecutterRecipe(output, (ICondition)cnc, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.KELPY_COBBLESTONE_BRICKS, (ItemLike)UABlocks.KELPY_COBBLESTONE);
        this.conditionalStonecutterRecipe(output, (ICondition)cnc, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.KELPY_COBBLESTONE_BRICK_SLAB, (ItemLike)UABlocks.KELPY_COBBLESTONE, 2);
        this.conditionalStonecutterRecipe(output, (ICondition)cnc, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.KELPY_COBBLESTONE_BRICK_STAIRS, (ItemLike)UABlocks.KELPY_COBBLESTONE);
        this.conditionalStonecutterRecipe(output, (ICondition)cnc, RecipeCategory.DECORATIONS, (ItemLike)UABlocks.KELPY_COBBLESTONE_BRICK_WALL, (ItemLike)UABlocks.KELPY_COBBLESTONE);
        UARecipeProvider.conditionalRecipe((RecipeOutput)output, (RecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, UABlocks.KELPY_COBBLESTONE_TILES, (int)4).define(Character.valueOf('#'), UABlocks.KELPY_COBBLESTONE_BRICKS).pattern("##").pattern("##").unlockedBy(UARecipeProvider.getHasName(UABlocks.KELPY_COBBLESTONE_BRICKS), UARecipeProvider.has(UABlocks.KELPY_COBBLESTONE_BRICKS)), (ICondition[])new ICondition[]{cnc});
        UARecipeProvider.conditionalRecipe((RecipeOutput)output, (RecipeBuilder)UARecipeProvider.stairBuilder(UABlocks.KELPY_COBBLESTONE_TILE_STAIRS, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{UABlocks.KELPY_COBBLESTONE_TILES})).unlockedBy(UARecipeProvider.getHasName(UABlocks.KELPY_COBBLESTONE_TILES), UARecipeProvider.has(UABlocks.KELPY_COBBLESTONE_TILES)), (ICondition[])new ICondition[]{cnc});
        UARecipeProvider.conditionalRecipe((RecipeOutput)output, (RecipeBuilder)UARecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, UABlocks.KELPY_COBBLESTONE_TILE_SLAB, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{UABlocks.KELPY_COBBLESTONE_TILES})).unlockedBy(UARecipeProvider.getHasName(UABlocks.KELPY_COBBLESTONE_TILES), UARecipeProvider.has(UABlocks.KELPY_COBBLESTONE_TILES)), (ICondition[])new ICondition[]{cnc});
        UARecipeProvider.conditionalRecipe((RecipeOutput)output, (RecipeBuilder)UARecipeProvider.wallBuilder((RecipeCategory)RecipeCategory.DECORATIONS, UABlocks.KELPY_COBBLESTONE_TILE_WALL, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{UABlocks.KELPY_COBBLESTONE_TILES})).unlockedBy(UARecipeProvider.getHasName(UABlocks.KELPY_COBBLESTONE_TILES), UARecipeProvider.has(UABlocks.KELPY_COBBLESTONE_TILES)), (ICondition[])new ICondition[]{cnc});
        this.conditionalStonecutterRecipe(output, (ICondition)cnc, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.KELPY_COBBLESTONE_TILE_SLAB, (ItemLike)UABlocks.KELPY_COBBLESTONE_TILES, 2);
        this.conditionalStonecutterRecipe(output, (ICondition)cnc, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.KELPY_COBBLESTONE_TILE_STAIRS, (ItemLike)UABlocks.KELPY_COBBLESTONE_TILES);
        this.conditionalStonecutterRecipe(output, (ICondition)cnc, RecipeCategory.DECORATIONS, (ItemLike)UABlocks.KELPY_COBBLESTONE_TILE_WALL, (ItemLike)UABlocks.KELPY_COBBLESTONE_TILES);
        this.conditionalStonecutterRecipe(output, (ICondition)cnc, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.KELPY_COBBLESTONE_TILES, (ItemLike)UABlocks.KELPY_COBBLESTONE_BRICKS);
        this.conditionalStonecutterRecipe(output, (ICondition)cnc, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.KELPY_COBBLESTONE_TILE_SLAB, (ItemLike)UABlocks.KELPY_COBBLESTONE_BRICKS, 2);
        this.conditionalStonecutterRecipe(output, (ICondition)cnc, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.KELPY_COBBLESTONE_TILE_STAIRS, (ItemLike)UABlocks.KELPY_COBBLESTONE_BRICKS);
        this.conditionalStonecutterRecipe(output, (ICondition)cnc, RecipeCategory.DECORATIONS, (ItemLike)UABlocks.KELPY_COBBLESTONE_TILE_WALL, (ItemLike)UABlocks.KELPY_COBBLESTONE_BRICKS);
        this.conditionalStonecutterRecipe(output, (ICondition)cnc, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.KELPY_COBBLESTONE_TILES, (ItemLike)UABlocks.KELPY_COBBLESTONE);
        this.conditionalStonecutterRecipe(output, (ICondition)cnc, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.KELPY_COBBLESTONE_TILE_SLAB, (ItemLike)UABlocks.KELPY_COBBLESTONE, 2);
        this.conditionalStonecutterRecipe(output, (ICondition)cnc, RecipeCategory.BUILDING_BLOCKS, (ItemLike)UABlocks.KELPY_COBBLESTONE_TILE_STAIRS, (ItemLike)UABlocks.KELPY_COBBLESTONE);
        this.conditionalStonecutterRecipe(output, (ICondition)cnc, RecipeCategory.DECORATIONS, (ItemLike)UABlocks.KELPY_COBBLESTONE_TILE_WALL, (ItemLike)UABlocks.KELPY_COBBLESTONE);
        UARecipeProvider.conditionalRecipe((RecipeOutput)output, (RecipeBuilder)ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, UABlocks.KELPY_COBBLESTONE_BRICKS).requires(UAConstants.COBBLESTONE_BRICKS).requires((ItemLike)Blocks.KELP).group("kelpy_cobblestone_bricks").unlockedBy("has_kelp", UARecipeProvider.has((ItemLike)Blocks.KELP)), (ResourceLocation)this.getModConversionRecipeName((ItemLike)UABlocks.KELPY_COBBLESTONE_BRICKS, (ItemLike)Blocks.KELP), (ICondition[])new ICondition[]{cnc});
        UARecipeProvider.conditionalRecipe((RecipeOutput)output, (RecipeBuilder)ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, UABlocks.KELPY_COBBLESTONE_TILES).requires(UAConstants.COBBLESTONE_TILES).requires((ItemLike)Blocks.KELP).group("kelpy_cobblestone_tiles").unlockedBy("has_kelp", UARecipeProvider.has((ItemLike)Blocks.KELP)), (ResourceLocation)this.getModConversionRecipeName((ItemLike)UABlocks.KELPY_COBBLESTONE_TILES, (ItemLike)Blocks.KELP), (ICondition[])new ICondition[]{cnc});
    }

    public void coralBlockRecipe(RecipeOutput consumer, ItemLike coralBlock, ItemLike coral, TagKey<Item> itemTag) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)coralBlock).define(Character.valueOf('#'), itemTag).pattern("##").pattern("##").unlockedBy(UARecipeProvider.getHasName((ItemLike)coral), UARecipeProvider.has(itemTag)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)this.getModID(), (String)RecipeBuilder.getDefaultRecipeId((ItemLike)coralBlock).getPath()));
    }

    public void conditionalStonecutterRecipe(RecipeOutput consumer, ICondition condition, RecipeCategory category, ItemLike output, ItemLike input) {
        this.conditionalStonecutterRecipe(consumer, condition, category, output, input, 1);
    }

    public void conditionalStonecutterRecipe(RecipeOutput consumer, ICondition condition, RecipeCategory category, ItemLike output, ItemLike input, int count) {
        UARecipeProvider.conditionalRecipe((RecipeOutput)consumer, (RecipeBuilder)SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)category, (ItemLike)output, (int)count).unlockedBy(UARecipeProvider.getHasName((ItemLike)input), UARecipeProvider.has((ItemLike)input)), (ResourceLocation)this.getModConversionRecipeName(output, input).withSuffix("_stonecutting"), (ICondition[])new ICondition[]{condition});
    }

    public void smeltingRecipe(RecipeOutput recipeOutput, List<ItemLike> inputs, RecipeCategory category, ItemLike output, float xp, int cookTime, String group) {
        for (ItemLike item : inputs) {
            SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item}), (RecipeCategory)category, (ItemLike)output, (float)xp, (int)cookTime).unlockedBy(UARecipeProvider.getHasName((ItemLike)item), UARecipeProvider.has((ItemLike)item)).group(group).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)this.getModID(), (String)(UARecipeProvider.getItemName((ItemLike)output) + "_from_smelting_" + UARecipeProvider.getItemName((ItemLike)item))));
        }
    }

    public void blastingRecipe(RecipeOutput recipeOutput, List<ItemLike> inputs, RecipeCategory category, ItemLike output, float xp, int cookTime, String group) {
        for (ItemLike item : inputs) {
            SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item}), (RecipeCategory)category, (ItemLike)output, (float)xp, (int)cookTime).unlockedBy(UARecipeProvider.getHasName((ItemLike)item), UARecipeProvider.has((ItemLike)item)).group(group).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)this.getModID(), (String)(UARecipeProvider.getItemName((ItemLike)output) + "_from_blasting_" + UARecipeProvider.getItemName((ItemLike)item))));
        }
    }
}

