/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.data.server;

import com.teamabnormals.upgrade_aquatic.common.advancement.BucketEntityDataPredicate;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.teamabnormals.upgrade_aquatic.core.registry.UACriteriaTriggers;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItemSubPredicates;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import com.teamabnormals.upgrade_aquatic.core.registry.UAMobEffects;
import com.teamabnormals.upgrade_aquatic.core.registry.UARegistries;
import com.teamabnormals.upgrade_aquatic.core.registry.datapack.UAPikeVariants;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class UAAdvancementProvider
implements AdvancementProvider.AdvancementGenerator {
    public static AdvancementProvider create(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper helper) {
        return new AdvancementProvider(output, provider, helper, List.of(new UAAdvancementProvider()));
    }

    public void generate(HolderLookup.Provider provider, Consumer<AdvancementHolder> consumer, ExistingFileHelper helper) {
        ItemStack splashPotion = new ItemStack((ItemLike)Items.SPLASH_POTION);
        splashPotion.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(UAMobEffects.INSOMNIA_NORMAL));
        UAAdvancementProvider.createAdvancement("sleepless_slave", "nether", ResourceLocation.withDefaultNamespace((String)"nether/brew_potion"), splashPotion, AdvancementType.TASK, true, true, false).addCriterion("convert_phantom", UACriteriaTriggers.convertPhantom()).save(consumer, "upgrade_aquatic:nether/sleepless_slave");
        ItemStack lingeringPotion = new ItemStack((ItemLike)Items.LINGERING_POTION);
        lingeringPotion.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(UAMobEffects.VIBING_NORMAL));
        UAAdvancementProvider.createAdvancement("vibe_check", "nether", ResourceLocation.withDefaultNamespace((String)"nether/brew_potion"), lingeringPotion, AdvancementType.TASK, true, true, false).addCriterion("vibing", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().hasComponents(DataComponentPredicate.builder().expect(DataComponents.POTION_CONTENTS, (Object)new PotionContents(UAMobEffects.VIBING_NORMAL)).build())})).addCriterion("vibing_long", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().hasComponents(DataComponentPredicate.builder().expect(DataComponents.POTION_CONTENTS, (Object)new PotionContents(UAMobEffects.VIBING_LONG)).build())})).addCriterion("vibing_strong", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().hasComponents(DataComponentPredicate.builder().expect(DataComponents.POTION_CONTENTS, (Object)new PotionContents(UAMobEffects.VIBING_STRONG)).build())})).requirements(AdvancementRequirements.Strategy.OR).save(consumer, "upgrade_aquatic:nether/vibe_check");
        UAAdvancementProvider.createAdvancement("sleep_underwater", "adventure", ResourceLocation.withDefaultNamespace((String)"adventure/sleep_in_bed"), UABlocks.BEDROLL, AdvancementType.TASK, true, true, false).addCriterion("sleep_underwater", UACriteriaTriggers.sleepUnderwater()).save(consumer, "upgrade_aquatic:adventure/sleep_underwater");
        AdvancementHolder obtainTooth = UAAdvancementProvider.createAdvancement("tooth_fairy", "adventure", ResourceLocation.withDefaultNamespace((String)"adventure/kill_a_mob"), (ItemLike)UAItems.THRASHER_TOOTH.get(), AdvancementType.TASK, true, true, false).addCriterion("thrasher_tooth", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)UAItems.THRASHER_TOOTH.get()})).save(consumer, "upgrade_aquatic:adventure/tooth_fairy");
        UAAdvancementProvider.createAdvancement("kill_great_thrasher", "adventure", obtainTooth, (ItemLike)UAItems.THRASHER_TOOTH.get(), AdvancementType.CHALLENGE, true, true, false).addCriterion("great_thrasher", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)UAEntityTypes.GREAT_THRASHER.get()))).save(consumer, "upgrade_aquatic:adventure/kill_great_thrasher");
        Advancement.Builder unethicalDentistry = UAAdvancementProvider.createAdvancement("unethical_dentistry", "adventure", obtainTooth, (ItemLike)UABlocks.TOOTH_BLOCK.get(), AdvancementType.TASK, true, true, false);
        for (DeferredBlock block : new DeferredBlock[]{UABlocks.TOOTH_BLOCK, UABlocks.TOOTH_BRICKS, UABlocks.TOOTH_BRICK_STAIRS, UABlocks.TOOTH_BRICK_SLAB, UABlocks.TOOTH_BRICK_WALL, UABlocks.TOOTH_TILES, UABlocks.TOOTH_TILE_STAIRS, UABlocks.TOOTH_TILE_SLAB, UABlocks.TOOTH_TILE_WALL, UABlocks.CHISELED_TOOTH_BRICKS, UABlocks.TOOTH_DOOR, UABlocks.TOOTH_TRAPDOOR, UABlocks.TOOTH_LANTERN}) {
            unethicalDentistry.addCriterion(block.getRegisteredName(), ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)((Block)block.get())));
        }
        unethicalDentistry.requirements(AdvancementRequirements.Strategy.OR).save(consumer, "upgrade_aquatic:adventure/unethical_dentistry");
        ItemStack bucket = new ItemStack((ItemLike)UAItems.PIKE_BUCKET.get());
        CompoundTag nbt = new CompoundTag();
        nbt.putString("BucketVariantTag", UAPikeVariants.GOLDEN_SOUTHERN.location().toString());
        lingeringPotion.set(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.of((CompoundTag)nbt));
        Advancement.Builder collectAllPike = UAAdvancementProvider.createAdvancement("collect_all_pike", "husbandry", ResourceLocation.withDefaultNamespace((String)"husbandry/tactical_fishing"), bucket, AdvancementType.CHALLENGE, true, true, false);
        for (ResourceKey variant : provider.lookupOrThrow(UARegistries.PIKE_VARIANT).listElementIds().toList().stream().sorted().toList()) {
            CompoundTag tag = new CompoundTag();
            tag.putString("BucketVariantTag", variant.location().toString());
            collectAllPike.addCriterion(variant.location().toString(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)UAItems.PIKE_BUCKET.get()}).withSubPredicate((ItemSubPredicate.Type)UAItemSubPredicates.BUCKET_ENTITY_DATA.get(), (ItemSubPredicate)BucketEntityDataPredicate.bucketEntityData(CustomData.of((CompoundTag)tag)))}));
        }
        collectAllPike.save(consumer, "upgrade_aquatic:adventure/collect_all_pike");
        UAAdvancementProvider.createAdvancement("eat_pickerelweed", "husbandry", ResourceLocation.withDefaultNamespace((String)"husbandry/root"), (ItemLike)UAItems.BOILED_PICKERELWEED.get(), AdvancementType.TASK, true, true, false).addCriterion("eat_pickerelweed", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)UAItems.BOILED_PICKERELWEED.get()))).save(consumer, "upgrade_aquatic:husbandry/eat_pickerelweed");
    }

    private static Advancement.Builder createAdvancement(String name, String category, AdvancementHolder parent, ItemStack icon, AdvancementType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return Advancement.Builder.advancement().parent(parent).display(icon, (Component)Component.translatable((String)("advancements.upgrade_aquatic." + category + "." + name + ".title")), (Component)Component.translatable((String)("advancements.upgrade_aquatic." + category + "." + name + ".description")), null, frame, showToast, announceToChat, hidden);
    }

    private static Advancement.Builder createAdvancement(String name, String category, AdvancementHolder parent, ItemLike icon, AdvancementType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return UAAdvancementProvider.createAdvancement(name, category, parent, new ItemStack(icon), frame, showToast, announceToChat, hidden);
    }

    private static Advancement.Builder createAdvancement(String name, String category, ResourceLocation parent, ItemLike icon, AdvancementType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return UAAdvancementProvider.createAdvancement(name, category, parent, new ItemStack(icon), frame, showToast, announceToChat, hidden);
    }

    private static Advancement.Builder createAdvancement(String name, String category, ResourceLocation parent, ItemStack icon, AdvancementType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return UAAdvancementProvider.createAdvancement(name, category, Advancement.Builder.advancement().build(parent), icon, frame, showToast, announceToChat, hidden);
    }
}

