/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.data.server;

import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierProvider;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.CriteriaModifier;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.EffectsChangedModifier;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.ParentModifier;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import com.teamabnormals.upgrade_aquatic.core.UpgradeAquatic;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import com.teamabnormals.upgrade_aquatic.core.registry.UAMobEffects;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.FilledBucketTrigger;
import net.minecraft.advancements.critereon.FishingRodHookedTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class UAAdvancementModifierProvider
extends AdvancementModifierProvider {
    private static final EntityType<?>[] MOBS_TO_KILL = new EntityType[]{(EntityType)UAEntityTypes.THRASHER.get(), (EntityType)UAEntityTypes.GREAT_THRASHER.get(), (EntityType)UAEntityTypes.FLARE.get()};

    public UAAdvancementModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super("upgrade_aquatic", output, provider);
    }

    protected void registerEntries(HolderLookup.Provider provider) {
        String name;
        MobEffectsPredicate.Builder predicate = MobEffectsPredicate.Builder.effects();
        UAMobEffects.MOB_EFFECTS.getEntries().forEach(mobEffect -> {
            if (!((MobEffect)mobEffect.get()).isInstantenous()) {
                predicate.and((Holder)mobEffect);
            }
        });
        this.entry("nether/all_effects").selects(new String[]{"nether/all_effects"}).addModifier((ObjectModifier)new EffectsChangedModifier("all_effects", false, (MobEffectsPredicate)predicate.build().get()), new ICondition[0]);
        this.entry("nether/all_potions").selects(new String[]{"nether/all_potions"}).addModifier((ObjectModifier)new EffectsChangedModifier("all_effects", false, (MobEffectsPredicate)predicate.build().get()), new ICondition[0]);
        CriteriaModifier.Builder balancedDiet = CriteriaModifier.builder((String)this.modId);
        List<DeferredHolder> items = ((DeferredRegister.Items)UAItems.ITEMS.getDeferredRegister()).getEntries().stream().filter(i -> ((Item)i.get()).getDefaultInstance().getFoodProperties(null) != null).toList();
        items.forEach(item -> balancedDiet.addCriterion(BuiltInRegistries.ITEM.getKey((Object)((Item)item.get())).getPath(), ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)item.get()))));
        this.entry("husbandry/balanced_diet").selects(new String[]{"husbandry/balanced_diet"}).addModifier((ObjectModifier)balancedDiet.requirements(AdvancementRequirements.Strategy.AND).build(), new ICondition[0]);
        CriteriaModifier.Builder fishyBusiness = CriteriaModifier.builder((String)this.modId);
        fishyBusiness.addCriterion("pike", FishingRodHookedTrigger.TriggerInstance.fishedItem(Optional.empty(), Optional.empty(), Optional.of(ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)UAItems.PIKE.get()}).build())));
        fishyBusiness.addCriterion("lionfish", FishingRodHookedTrigger.TriggerInstance.fishedItem(Optional.empty(), Optional.empty(), Optional.of(ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)UAItems.LIONFISH.get()}).build())));
        fishyBusiness.addCriterion("perch", FishingRodHookedTrigger.TriggerInstance.fishedItem(Optional.empty(), Optional.empty(), Optional.of(ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)UAItems.PERCH.get()}).build())));
        this.entry("husbandry/fishy_business").selects(new String[]{"husbandry/fishy_business"}).addModifier((ObjectModifier)fishyBusiness.addIndexedRequirements(0, false, new String[]{"pike", "lionfish", "perch"}).build(), new ICondition[0]);
        CriteriaModifier.Builder killAMob = CriteriaModifier.builder((String)this.modId);
        CriteriaModifier.Builder killAllMobs = CriteriaModifier.builder((String)this.modId);
        ArrayList<String> names = new ArrayList<String>();
        for (EntityType<?> entityType : MOBS_TO_KILL) {
            name = BuiltInRegistries.ENTITY_TYPE.getKey(entityType).getPath();
            Criterion triggerInstance = KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(entityType));
            killAMob.addCriterion(name, triggerInstance);
            killAllMobs.addCriterion(name, triggerInstance);
            names.add(name);
        }
        this.entry("adventure/kill_a_mob").selects(new String[]{"adventure/kill_a_mob"}).addModifier((ObjectModifier)killAMob.addIndexedRequirements(0, false, names.toArray(new String[0])).build(), new ICondition[0]);
        this.entry("adventure/kill_all_mobs").selects(new String[]{"adventure/kill_all_mobs"}).addModifier((ObjectModifier)killAllMobs.requirements(AdvancementRequirements.Strategy.AND).build(), new ICondition[0]);
        CriteriaModifier.Builder tacticalFishing = CriteriaModifier.builder((String)this.modId);
        names = new ArrayList();
        for (DeferredHolder object : ((DeferredRegister.Items)UAItems.ITEMS.getDeferredRegister()).getEntries()) {
            Item item2 = (Item)object.get();
            if (!(item2 instanceof MobBucketItem)) continue;
            name = BuiltInRegistries.ITEM.getKey((Object)item2).getPath();
            tacticalFishing.addCriterion(name, FilledBucketTrigger.TriggerInstance.filledBucket((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{item2})));
            names.add(name);
        }
        tacticalFishing.addCriterion("jellyfish_bucket", FilledBucketTrigger.TriggerInstance.filledBucket((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)UAItems.JELLYFISH_BUCKET.get()})));
        names.add("jellyfish_bucket");
        this.entry("husbandry/tactical_fishing").selects(new String[]{"husbandry/tactical_fishing"}).addModifier((ObjectModifier)tacticalFishing.addIndexedRequirements(0, false, names.toArray(new String[0])).build(), new ICondition[0]);
        this.entry("adventure/throw_trident").selects(new String[]{"adventure/throw_trident"}).addModifier((ObjectModifier)new ParentModifier(UpgradeAquatic.location("adventure/tooth_fairy")), new ICondition[0]);
    }
}

