/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.item;

import com.mojang.serialization.MapCodec;
import com.teamabnormals.upgrade_aquatic.core.other.JellyfishRegistry;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import java.util.List;
import java.util.Random;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;

public class JellyfishSpawnEggItem
extends DeferredSpawnEggItem {
    private static final MapCodec<EntityType<?>> ENTITY_TYPE_FIELD_CODEC = BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("id");

    public JellyfishSpawnEggItem(int primaryColor, int secondaryColor, Item.Properties properties) {
        super(UAEntityTypes.BOX_JELLYFISH, primaryColor, secondaryColor, properties);
    }

    public EntityType<?> getType(ItemStack stack) {
        CustomData customdata = (CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        return !customdata.isEmpty() ? customdata.read(ENTITY_TYPE_FIELD_CODEC).result().orElse(this.getRandomJellyfish()) : this.getRandomJellyfish();
    }

    private EntityType<?> getRandomJellyfish() {
        List<JellyfishRegistry.JellyfishEntry<?>> jellies = JellyfishRegistry.collectJelliesMatchingRarity(Rarity.COMMON);
        return jellies.get(new Random().nextInt(jellies.size())).jellyfish().get();
    }
}

