/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish;

import com.teamabnormals.upgrade_aquatic.common.block.JellyTorchBlock;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.jellyfish.JellyfishRandomSwimmingGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.AbstractJellyfish;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public class ImmortalJellyfish
extends AbstractJellyfish {
    private int healCooldown;
    private float prevHealth = this.getHealth();

    public ImmortalJellyfish(EntityType<? extends AbstractJellyfish> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return AbstractJellyfish.createAttributes().add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MAX_HEALTH, 7.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new JellyfishRandomSwimmingGoal(this));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.healCooldown > 0) {
            --this.healCooldown;
        } else if (this.tickCount % 5 == 0) {
            this.heal(0.5f);
        }
        if (this.prevHealth > this.getHealth()) {
            this.healCooldown = this.getRandom().nextInt(40) + 20;
        }
        this.prevHealth = this.getHealth();
    }

    @Override
    protected void readAdditionalSaveDataSharedWithBucket(CompoundTag tag) {
        super.readAdditionalSaveDataSharedWithBucket(tag);
        this.healCooldown = tag.getInt("HealCooldown");
    }

    @Override
    protected void addAdditionalSaveDataSharedWithBucket(CompoundTag tag) {
        super.addAdditionalSaveDataSharedWithBucket(tag);
        tag.putInt("HealCooldown", this.healCooldown);
    }

    @Override
    public AbstractJellyfish.BucketDisplayInfo getBucketDisplayInfo() {
        return this.bucketDisplayInfo("immortal", 7, JellyTorchBlock.JellyTorchType.WHITE, JellyTorchBlock.JellyTorchType.RED);
    }

    @Override
    public JellyTorchBlock.JellyTorchType getJellyTorchType() {
        return this.getRandom().nextFloat() < 0.75f ? JellyTorchBlock.JellyTorchType.WHITE : JellyTorchBlock.JellyTorchType.RED;
    }

    @Override
    public float getCooldownChance() {
        return 0.8f;
    }

    public int getMaxSpawnClusterSize() {
        return 3;
    }
}

