/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish;

import com.teamabnormals.blueprint.common.entity.ai.PredicateAttackGoal;
import com.teamabnormals.upgrade_aquatic.common.block.JellyTorchBlock;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.jellyfish.JellyfishRandomSwimmingGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.AbstractJellyfish;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.ColoredSizableJellyfish;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class BoxJellyfish
extends ColoredSizableJellyfish {
    private int huntingCooldown;

    public BoxJellyfish(EntityType<? extends BoxJellyfish> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return AbstractJellyfish.createAttributes().add(Attributes.ATTACK_DAMAGE, 5.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 4.0, true){

            public void stop() {
                super.stop();
                if (this.mob.getTarget() == null) {
                    ((BoxJellyfish)this.mob).setHuntingCooldown();
                }
            }
        });
        this.goalSelector.addGoal(2, (Goal)new JellyfishRandomSwimmingGoal(this));
        this.targetSelector.addGoal(1, (Goal)new PredicateAttackGoal((Mob)this, AbstractFish.class, 150, true, true, null, owner -> !((BoxJellyfish)((Object)owner)).hasCooldown() && !((BoxJellyfish)((Object)owner)).hasHuntingCooldown()));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.hasHuntingCooldown()) {
            --this.huntingCooldown;
        }
    }

    @Override
    protected void addAdditionalSaveDataSharedWithBucket(CompoundTag tag) {
        super.addAdditionalSaveDataSharedWithBucket(tag);
        tag.putInt("HuntingCooldown", this.huntingCooldown);
    }

    @Override
    protected void readAdditionalSaveDataSharedWithBucket(CompoundTag tag) {
        super.readAdditionalSaveDataSharedWithBucket(tag);
        this.huntingCooldown = tag.getInt("HuntingCooldown");
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(this.getSize());
    }

    public void setHuntingCooldown() {
        this.huntingCooldown = this.getRandom().nextInt(1600) + 1200;
    }

    public boolean hasHuntingCooldown() {
        return this.huntingCooldown > 0;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (super.hurt(source, amount)) {
            Entity entity = source.getEntity();
            if (!(!(entity instanceof LivingEntity) || this.getTarget() != null || entity.isSpectator() || entity instanceof Player && ((Player)entity).isCreative())) {
                this.setTarget((LivingEntity)entity);
            }
            return true;
        }
        return false;
    }

    public String getVariantName() {
        return switch (this.getColor()) {
            default -> "box";
            case 1 -> "red_box";
            case 2 -> "white_box";
        };
    }

    @Override
    public AbstractJellyfish.BucketDisplayInfo getBucketDisplayInfo() {
        JellyTorchBlock.JellyTorchType jellyTorchType = this.getJellyTorchType();
        return this.bucketDisplayInfo(this.getVariantName(), jellyTorchType.ordinal(), jellyTorchType);
    }

    @Override
    public JellyTorchBlock.JellyTorchType getJellyTorchType() {
        return switch (this.getColor()) {
            default -> JellyTorchBlock.JellyTorchType.BLUE;
            case 1 -> JellyTorchBlock.JellyTorchType.RED;
            case 2 -> JellyTorchBlock.JellyTorchType.WHITE;
        };
    }

    @Override
    public float getCooldownChance() {
        return this.getSize() >= 1.0f ? 0.05f : (this.getSize() < 0.5f ? 0.1f : 0.15f);
    }

    @Override
    public boolean stingEntity(LivingEntity livingEntity) {
        if (super.stingEntity(livingEntity)) {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 600, 1));
            if (this.getTarget() == null) {
                this.setTarget(livingEntity);
            }
            return true;
        }
        return false;
    }

    @Override
    protected float getDefaultSize() {
        return 1.0f;
    }

    @Override
    protected float getHealthSizeMultiplier() {
        return 8.0f;
    }

    public int getMaxSpawnClusterSize() {
        return 3;
    }
}

