/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.animal;

import com.google.common.collect.Lists;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.PerchHideInSeagrassGoal;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import com.teamabnormals.upgrade_aquatic.core.registry.UASoundEvents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class Perch
extends AbstractSchoolingFish {
    public Perch(EntityType<? extends Perch> type, Level world) {
        super(type, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PerchHideInSeagrassGoal(this));
    }

    public boolean isSeagrassNearby() {
        return !this.getNearbySeagrass().isEmpty();
    }

    public List<BlockPos> getNearbySeagrass() {
        ArrayList seagrasses = Lists.newArrayList();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int yy = this.blockPosition().getY() - 6;
        while ((double)yy <= this.getY() + 6.0) {
            int xx = this.blockPosition().getX() - 12;
            while ((double)xx <= this.getX() + 12.0) {
                int zz = this.blockPosition().getZ() - 12;
                while ((double)zz <= this.getZ() + 12.0) {
                    mutable.set(xx, yy, zz);
                    BlockState block = this.level().getBlockState((BlockPos)mutable);
                    if (block.is(Blocks.SEAGRASS) || block.is(Blocks.TALL_SEAGRASS)) {
                        seagrasses.add(mutable);
                    }
                    ++zz;
                }
                ++xx;
            }
            ++yy;
        }
        return seagrasses;
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)UAItems.PERCH_BUCKET.get());
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)UASoundEvents.PERCH_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)UASoundEvents.PERCH_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)UASoundEvents.PERCH_HURT.get();
    }

    protected SoundEvent getFlopSound() {
        return (SoundEvent)UASoundEvents.PERCH_FLOP.get();
    }
}

