/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.animal;

import com.teamabnormals.blueprint.common.entity.BucketableWaterAnimal;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Lionfish
extends BucketableWaterAnimal {
    private static final Predicate<LivingEntity> ENEMY_MATCHER = entity -> {
        if (entity == null) {
            return false;
        }
        return !(entity instanceof Lionfish) && !(entity instanceof AbstractFish);
    };
    private static final EntityDataAccessor<Boolean> HUNGY = SynchedEntityData.defineId(Lionfish.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> TIME_TILL_HUNGRY = SynchedEntityData.defineId(Lionfish.class, (EntityDataSerializer)EntityDataSerializers.INT);
    int lastTimeSinceHungry;

    public Lionfish(EntityType<? extends Lionfish> type, Level world) {
        super((EntityType)UAEntityTypes.LIONFISH.get(), world);
        this.moveControl = new MoveHelperController(this);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 8.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(4, (Goal)new RandomSwimmingGoal(this, (PathfinderMob)this, 1.35, 30){

            public boolean canUse() {
                Vec3 vec3d;
                if (this.mob.isVehicle()) {
                    return false;
                }
                if (!this.forceTrigger) {
                    if (this.mob.getNoActionTime() >= 100) {
                        return false;
                    }
                    if (((Lionfish)this.mob).isHungry() ? this.mob.getRandom().nextInt(60) != 0 : this.mob.getRandom().nextInt(30) != 0) {
                        return false;
                    }
                }
                if ((vec3d = this.getPosition()) == null) {
                    return false;
                }
                this.wantedX = vec3d.x;
                this.wantedY = vec3d.y;
                this.wantedZ = vec3d.z;
                this.forceTrigger = false;
                return true;
            }
        });
        this.goalSelector.addGoal(4, (Goal)new LionfishAttackGoal((PathfinderMob)this, 12.0, true));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal<TropicalFish>(this, (Mob)this, TropicalFish.class, true){

            public boolean canUse() {
                return ((Lionfish)this.mob).isHungry() && super.canUse();
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HUNGY, (Object)true);
        builder.define(TIME_TILL_HUNGRY, (Object)0);
    }

    public boolean isHungry() {
        return (Boolean)this.entityData.get(HUNGY);
    }

    public void setHungry(boolean hungry) {
        this.entityData.set(HUNGY, (Object)hungry);
    }

    public int getTimeTillHungry() {
        return (Integer)this.entityData.get(TIME_TILL_HUNGRY);
    }

    public void setTimeTillHungry(int ticks) {
        this.entityData.set(TIME_TILL_HUNGRY, (Object)ticks);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("IsHungry", this.isHungry());
        compound.putInt("TimeTillHungry", this.getTimeTillHungry());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setHungry(compound.getBoolean("IsHungry"));
        this.setTimeTillHungry(compound.getInt("TimeTillHungry"));
    }

    public int getMaxSpawnClusterSize() {
        return 3;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)UAItems.LIONFISH_SPAWN_EGG.get());
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)UAItems.LIONFISH_BUCKET.get());
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    public static boolean checkLionfishSpawnRules(EntityType<? extends Entity> entityType, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        for (int yy = pos.getY() - 2; yy <= pos.getY() + 2; ++yy) {
            for (int xx = pos.getX() - 6; xx <= pos.getX() + 6; ++xx) {
                for (int zz = pos.getZ() - 6; zz <= pos.getZ() + 6; ++zz) {
                    if (!world.getBlockState(new BlockPos(xx, yy, zz)).is(BlockTags.CORAL_BLOCKS)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void tick() {
        super.tick();
        if (!this.isInWater() && this.onGround() && this.verticalCollision) {
            this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.035f), (double)0.4f, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.035f)));
            this.setOnGround(false);
            this.hasImpulse = true;
            this.playSound(this.getFlopSound(), this.getSoundVolume(), this.getVoicePitch());
        }
        if (this.isAlive()) {
            for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.3), ENEMY_MATCHER)) {
                if (!entity.isAlive()) continue;
                this.attack(entity);
            }
        }
        if (!this.isHungry() && this.lastTimeSinceHungry < this.getTimeTillHungry()) {
            ++this.lastTimeSinceHungry;
        }
        if (this.lastTimeSinceHungry >= this.getTimeTillHungry()) {
            this.setHungry(true);
            this.lastTimeSinceHungry = 0;
        }
    }

    private void attack(LivingEntity entity) {
        if (entity.hurt(this.damageSources().mobAttack((LivingEntity)this), 2.0f) && entity.isInWater()) {
            entity.addEffect(new MobEffectInstance(MobEffects.POISON, 70, 1));
            this.playSound(SoundEvents.PUFFER_FISH_STING, 1.0f, 1.0f);
            if (entity instanceof Player) {
                this.setTarget(entity);
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity entitySource = source.getEntity();
        if (entitySource instanceof LivingEntity && (!(entitySource instanceof Player) || !((Player)entitySource).getAbilities().instabuild) && entitySource instanceof Player) {
            this.setTarget((LivingEntity)entitySource);
        }
        return super.hurt(source, amount);
    }

    public void travel(Vec3 p_213352_1_) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(0.01f, p_213352_1_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(p_213352_1_);
        }
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.PUFFER_FISH_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PUFFER_FISH_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.PUFFER_FISH_HURT;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.PUFFER_FISH_FLOP;
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.FISH_SWIM;
    }

    static class MoveHelperController
    extends MoveControl {
        private final Lionfish lionfish;

        MoveHelperController(Lionfish lionfish) {
            super((Mob)lionfish);
            this.lionfish = lionfish;
        }

        public void tick() {
            if (this.lionfish.isEyeInFluid(FluidTags.WATER)) {
                this.lionfish.setDeltaMovement(this.lionfish.getDeltaMovement().add(0.0, 0.005, 0.0));
            }
            if (this.operation == MoveControl.Operation.MOVE_TO && !this.lionfish.getNavigation().isDone()) {
                double d0 = this.wantedX - this.lionfish.getX();
                double d1 = this.wantedY - this.lionfish.getY();
                double d2 = this.wantedZ - this.lionfish.getZ();
                double d3 = Mth.sqrt((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                d1 /= d3;
                float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.lionfish.setYRot(this.rotlerp(this.lionfish.getYRot(), f, 90.0f));
                this.lionfish.yBodyRot = this.lionfish.getYRot();
                float f1 = (float)(this.speedModifier * this.lionfish.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                this.lionfish.setSpeed(Mth.lerp((float)0.125f, (float)this.lionfish.getSpeed(), (float)f1));
                this.lionfish.setDeltaMovement(this.lionfish.getDeltaMovement().add(0.0, (double)this.lionfish.getSpeed() * d1 * 0.03, 0.0));
            }
        }
    }

    static class LionfishAttackGoal
    extends MeleeAttackGoal {
        public LionfishAttackGoal(PathfinderMob creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.mob.isInWater();
        }

        protected void checkAndPerformAttack(LivingEntity enemy) {
            if (this.canPerformAttack(enemy)) {
                this.resetAttackCooldown();
                ((Lionfish)this.mob).attack(enemy);
                ((Lionfish)this.mob).setHungry(false);
                ((Lionfish)this.mob).setTimeTillHungry(this.mob.getRandom().nextInt(300) + 300);
                if (enemy instanceof Player) {
                    this.mob.setTarget(null);
                    this.stop();
                }
            }
        }
    }
}

