/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.thrasher;

import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.upgrade_aquatic.common.entity.monster.Thrasher;
import com.teamabnormals.upgrade_aquatic.core.registry.UAPlayableEndimations;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;

public class ThrasherThrashGoal
extends Goal {
    public Thrasher thrasher;
    private float originalYaw;
    private float thrashedTicks;

    public ThrasherThrashGoal(Thrasher thrasher) {
        this.thrasher = thrasher;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        Player player;
        Entity passenger = this.thrasher.getFirstPassenger();
        if (passenger instanceof Player && ((player = (Player)passenger).isCreative() || passenger.isSpectator())) {
            return false;
        }
        return !this.thrasher.isStunned() && passenger != null && this.thrasher.isNoEndimationPlaying() && this.thrasher.getRandom().nextFloat() < 0.1f;
    }

    public boolean canContinueToUse() {
        Player player;
        Entity passenger = this.thrasher.getFirstPassenger();
        if (passenger instanceof Player && ((player = (Player)passenger).isCreative() || passenger.isSpectator())) {
            return false;
        }
        return !this.thrasher.isStunned() && this.thrashedTicks <= 55.0f && passenger != null;
    }

    public void start() {
        this.originalYaw = this.thrasher.getYRot();
        this.thrasher.setHitsTillStun(this.thrasher.getRandom().nextInt(2) + 2);
        NetworkUtil.setPlayingAnimation((Entity)this.thrasher, (PlayableEndimation)UAPlayableEndimations.THRASHER_THRASH);
    }

    public void stop() {
        this.originalYaw = 0.0f;
        this.thrashedTicks = 0.0f;
        NetworkUtil.setPlayingAnimation((Entity)this.thrasher, (PlayableEndimation)PlayableEndimation.BLANK);
    }

    public void tick() {
        this.thrashedTicks += 1.0f;
        this.thrasher.getNavigation().stop();
        this.thrasher.yRotO = this.thrasher.getYRot();
        this.thrasher.yBodyRot = this.originalYaw + 75.0f * Mth.cos((float)((float)this.thrasher.tickCount * 0.5f)) * 1.0f;
        this.thrasher.setYRot(this.originalYaw + 75.0f * Mth.cos((float)((float)this.thrasher.tickCount * 0.5f)) * 1.0f);
        Entity entity = this.thrasher.getFirstPassenger();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.disablePlayersShield(player);
        }
        if (entity != null) {
            entity.setShiftKeyDown(false);
        }
        if (this.thrashedTicks % 5.0f == 0.0f && this.thrashedTicks > 0.0f) {
            this.thrasher.playSound(this.thrasher.getThrashingSound(), 1.0f, Math.max(0.75f, this.thrasher.getRandom().nextFloat()));
            if (entity != null) {
                entity.hurt(entity.damageSources().mobAttack((LivingEntity)this.thrasher), (float)this.thrasher.getAttribute(Attributes.ATTACK_DAMAGE).getValue());
            }
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    private void disablePlayersShield(Player player) {
        player.getCooldowns().addCooldown(Items.SHIELD, 30);
    }
}

