/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.pike;

import com.teamabnormals.upgrade_aquatic.common.entity.animal.Pike;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.phys.Vec3;

public final class HideInPickerelweedGoal
extends RandomStrollGoal {
    public HideInPickerelweedGoal(Pike pike) {
        super((PathfinderMob)pike, 1.1, 25);
    }

    public boolean canUse() {
        if (!(this.forceTrigger || this.mob.getNoActionTime() < 100 && this.mob.getRandom().nextInt(this.interval) == 0)) {
            return false;
        }
        Vec3 vec3d = this.getPosition();
        if (vec3d == null) {
            return false;
        }
        if (((Pike)this.mob).isPickerelweedNearby()) {
            this.wantedX = vec3d.x;
            this.wantedY = vec3d.y;
            this.wantedZ = vec3d.z;
            this.forceTrigger = false;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return ((Pike)this.mob).isPickerelweedNearby() && super.canContinueToUse();
    }

    @Nullable
    protected Vec3 getPosition() {
        Pike pike = (Pike)this.mob;
        if (pike.isPickerelweedNearby()) {
            int pickedWeed = pike.getRandom().nextInt(pike.getNearbyPickerelweeds().size());
            BlockPos pos = pike.getNearbyPickerelweeds().get(pickedWeed);
            return new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        }
        return null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

