/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.block;

import com.teamabnormals.upgrade_aquatic.core.registry.UAParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseCoralPlantBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class DeadCoralShowerBlock
extends BaseCoralPlantBlock {
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public DeadCoralShowerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !stateIn.canSurvive((LevelReader)worldIn, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        this.tryScheduleDieTick(stateIn, worldIn, currentPos);
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return facing == Direction.UP && !this.canSurvive(stateIn, (LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : stateIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        double xOffset = rand.nextBoolean() ? -(Math.random() * 0.4) : Math.random() * 0.4;
        double yOffset = rand.nextBoolean() ? -(Math.random() * 0.4) : Math.random() * 0.4;
        double zOffset = rand.nextBoolean() ? -(Math.random() * 0.4) : Math.random() * 0.4;
        double d0 = (double)pos.getX() + 0.5 + xOffset;
        double d1 = (double)pos.getY() + 0.5 + yOffset;
        double d2 = (double)pos.getZ() + 0.5 + zOffset;
        level.addParticle((ParticleOptions)UAParticleTypes.ELDER_PRISMARINE_SHOWER.get(), d0, d1, d2, 0.0, 0.004, 0.0);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.above();
        return level.getBlockState(blockpos).isFaceSturdy((BlockGetter)level, blockpos, Direction.DOWN);
    }
}

